/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiClass myClass;
    private final MyModificationTracker myTreeChangeTracker;
    private CachedValue<PsiMethod[]> myConstructorsCache;
    private CachedValue<PsiField[]> myFieldsCache;
    private CachedValue<PsiMethod[]> myMethodsCache;
    private CachedValue<Map<String, PsiField>> myFieldsMapCache;
    private CachedValue<Map<String, List<PsiMethod>>> myMethodsMapCache;
    private CachedValue<Map<String, PsiClass>> myInnerClassesMapCache;

    public ClassInnerStuffCache(PsiClass aClass) {
        this.myClass = aClass;
        this.myTreeChangeTracker = new MyModificationTracker();
        this.buildCaches();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] constructors = (PsiMethod[])this.myConstructorsCache.getValue();
        PsiMethod[] psiMethodArray = constructors != null ? constructors : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] fields = (PsiField[])this.myFieldsCache.getValue();
        PsiField[] psiFieldArray = fields != null ? fields : PsiField.EMPTY_ARRAY;
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] methods = (PsiMethod[])this.myMethodsCache.getValue();
        PsiMethod[] psiMethodArray = methods != null ? methods : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getMethods must not return null");
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (!checkBases) {
            Map cachedFields = (Map)this.myFieldsMapCache.getValue();
            return cachedFields != null ? (PsiField)cachedFields.get(name) : null;
        }
        return PsiClassImplUtil.findFieldByName(this.myClass, name, checkBases);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray;
        if (!checkBases) {
            List methods;
            Map cachedMethods = (Map)this.myMethodsMapCache.getValue();
            if (cachedMethods != null && (methods = (List)cachedMethods.get(name)) != null && methods.size() > 0) {
                psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
                if (psiMethodArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
                return psiMethodArray;
            } else {
                psiMethodArray = PsiMethod.EMPTY_ARRAY;
                if (PsiMethod.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
                return psiMethodArray;
            }
        }
        psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, checkBases);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (!checkBases) {
            Map inners = (Map)this.myInnerClassesMapCache.getValue();
            return inners != null ? (PsiClass)inners.get(name) : null;
        }
        return PsiClassImplUtil.findInnerByName(this.myClass, name, checkBases);
    }

    private void buildCaches() {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myClass.getProject());
        final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
        this.myConstructorsCache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                return CachedValueProvider.Result.create((Object)PsiImplUtil.getConstructors(ClassInnerStuffCache.this.myClass), (Object[])dependencies);
            }
        }, false);
        this.myFieldsCache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<PsiField[]>(){

            public CachedValueProvider.Result<PsiField[]> compute() {
                return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getAllFields(), (Object[])dependencies);
            }
        }, false);
        this.myMethodsCache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getAllMethods(), (Object[])dependencies);
            }
        }, false);
        this.myFieldsMapCache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiField>>(){

            public CachedValueProvider.Result<Map<String, PsiField>> compute() {
                return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getFieldsMap(), (Object[])dependencies);
            }
        }, false);
        this.myMethodsMapCache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, List<PsiMethod>>>(){

            public CachedValueProvider.Result<Map<String, List<PsiMethod>>> compute() {
                return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getMethodsMap(), (Object[])dependencies);
            }
        }, false);
        this.myInnerClassesMapCache = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiClass>>(){

            public CachedValueProvider.Result<Map<String, PsiClass>> compute() {
                return CachedValueProvider.Result.create((Object)ClassInnerStuffCache.this.getInnerClassesMap(), (Object[])dependencies);
            }
        }, false);
    }

    private PsiField[] getAllFields() {
        if (!(this.myClass instanceof PsiClassImpl)) {
            return this.myClass.getFields();
        }
        Object[] own = (PsiField[])((PsiClassImpl)this.myClass).getStubOrPsiChildren(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY);
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class);
        return (PsiField[])ArrayUtil.mergeArrayAndCollection((Object[])own, (Collection)ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
    }

    private PsiMethod[] getAllMethods() {
        if (!(this.myClass instanceof PsiClassImpl)) {
            return this.myClass.getMethods();
        }
        Object[] own = (PsiMethod[])((PsiClassImpl)this.myClass).getStubOrPsiChildren(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY);
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class);
        return (PsiMethod[])ArrayUtil.mergeArrayAndCollection((Object[])own, (Collection)ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
    }

    @Nullable
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            return null;
        }
        THashMap cachedFields = new THashMap();
        for (PsiField field : fields) {
            String name = field.getName();
            if (field instanceof ExternallyDefinedPsiElement && cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        return cachedFields;
    }

    @Nullable
    private Map<String, List<PsiMethod>> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            return null;
        }
        THashMap cachedMethods = new THashMap();
        for (PsiMethod method : methods) {
            ArrayList<PsiMethod> list = (ArrayList<PsiMethod>)cachedMethods.get(method.getName());
            if (list == null) {
                list = new ArrayList<PsiMethod>(1);
                cachedMethods.put(method.getName(), list);
            }
            list.add(method);
        }
        return cachedMethods;
    }

    @Nullable
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes = this.myClass.getInnerClasses();
        if (classes.length == 0) {
            return null;
        }
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : classes) {
            cachedInners.put(psiClass.getName(), psiClass);
        }
        return cachedInners;
    }

    public void dropCaches() {
        this.myTreeChangeTracker.myCount++;
    }

    private static class MyModificationTracker
    implements ModificationTracker {
        private long myCount = 0L;

        private MyModificationTracker() {
        }

        public long getModificationCount() {
            return this.myCount;
        }
    }
}

