/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;

public class JavaAnnotationElementType
extends JavaStubElementType<PsiAnnotationStub, PsiAnnotation> {
    public JavaAnnotationElementType() {
        super("ANNOTATION");
    }

    public PsiAnnotation createPsi(PsiAnnotationStub stub) {
        if (this.isCompiled(stub)) {
            return new ClsAnnotationImpl(stub);
        }
        return new PsiAnnotationImpl(stub);
    }

    @Override
    public PsiAnnotation createPsi(ASTNode node) {
        return new PsiAnnotationImpl(node);
    }

    public PsiAnnotationStub createStub(PsiAnnotation psi, StubElement parentStub) {
        return new PsiAnnotationStubImpl(parentStub, psi.getText());
    }

    public void serialize(PsiAnnotationStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeUTFFast(stub.getText());
    }

    public PsiAnnotationStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        return new PsiAnnotationStubImpl(parentStub, dataStream.readUTFFast());
    }

    public void indexStub(PsiAnnotationStub stub, IndexSink sink) {
        String text = stub.getText();
        String refText = JavaAnnotationElementType.getReferenceShortName(text);
        sink.occurrence(JavaAnnotationIndex.KEY, (Object)refText);
    }

    private static String getReferenceShortName(String annotationText) {
        int index = annotationText.indexOf(40);
        if (index >= 0) {
            return PsiNameHelper.getShortClassName((String)annotationText.substring(0, index));
        }
        return PsiNameHelper.getShortClassName((String)annotationText);
    }
}

