/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.search.IndexPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseFilterLexer
extends DelegateLexer
implements IdTableBuilding.ScanWordProcessor {
    private final OccurrenceConsumer myOccurrenceConsumer;
    private int myTodoScannedBound = 0;
    private int myOccurenceMask;
    private TodoScanningData[] myTodoScanningData;

    protected BaseFilterLexer(Lexer originalLexer, OccurrenceConsumer occurrenceConsumer) {
        super(originalLexer);
        this.myOccurrenceConsumer = occurrenceConsumer;
    }

    protected final void advanceTodoItemCountsInToken() {
        if (this.myOccurrenceConsumer.canConsumeTodoOccurrences()) {
            int start = this.getTokenStart();
            int end = this.getTokenEnd();
            if ((start = Math.max(start, this.myTodoScannedBound)) >= end) {
                return;
            }
            CharSequence input = this.getBufferSequence().subSequence(start, end);
            this.myTodoScanningData = BaseFilterLexer.advanceTodoItemsCount(input, this.myOccurrenceConsumer, this.myTodoScanningData);
            this.myTodoScannedBound = end;
        }
    }

    public static TodoScanningData[] advanceTodoItemsCount(CharSequence input, OccurrenceConsumer consumer, TodoScanningData[] todoScanningData) {
        if (todoScanningData == null) {
            IndexPattern[] patterns = CacheUtil.getIndexPatterns();
            todoScanningData = new TodoScanningData[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                IndexPattern indexPattern = patterns[i];
                Pattern pattern = indexPattern.getPattern();
                if (pattern == null) continue;
                todoScanningData[i] = new TodoScanningData(indexPattern, pattern.matcher(""));
            }
        }
        for (TodoScanningData data : todoScanningData) {
            if (data == null) continue;
            Matcher matcher = data.matcher;
            matcher.reset(input);
            while (matcher.find()) {
                if (matcher.start() == matcher.end()) continue;
                consumer.incTodoOccurrence(data.pattern);
            }
        }
        return todoScanningData;
    }

    @Override
    public final void run(CharSequence chars, int start, int end) {
        this.myOccurrenceConsumer.addOccurrence(chars, start, end, this.myOccurenceMask);
    }

    protected final void addOccurrenceInToken(int occurrenceMask) {
        this.myOccurrenceConsumer.addOccurrence(this.getBufferSequence(), this.getTokenStart(), this.getTokenEnd(), occurrenceMask);
    }

    protected final void scanWordsInToken(int occurrenceMask, boolean mayHaveFileRefs, boolean mayHaveEscapes) {
        this.myOccurenceMask = occurrenceMask;
        int start = this.getTokenStart();
        int end = this.getTokenEnd();
        IdTableBuilding.scanWords(this, this.getBufferSequence(), null, start, end, mayHaveEscapes);
        if (mayHaveFileRefs) {
            this.processPossibleComplexFileName(this.getBufferSequence(), start, end);
        }
    }

    private void processPossibleComplexFileName(CharSequence chars, int startOffset, int endOffset) {
        int offset = BaseFilterLexer.findCharsWithinRange(chars, startOffset, endOffset, "/\\");
        offset = Math.min(offset, endOffset);
        int start = startOffset;
        while (start < endOffset) {
            if (start != offset) {
                this.myOccurrenceConsumer.addOccurrence(chars, start, offset, 8);
            }
            start = offset + 1;
            offset = Math.min(endOffset, BaseFilterLexer.findCharsWithinRange(chars, start, endOffset, "/\\"));
        }
    }

    private static int findCharsWithinRange(CharSequence chars, int startOffset, int endOffset, String charsToFind) {
        while (startOffset < endOffset) {
            if (charsToFind.indexOf(chars.charAt(startOffset)) != -1) {
                return startOffset;
            }
            ++startOffset;
        }
        return startOffset;
    }

    public static class TodoScanningData {
        final IndexPattern pattern;
        final Matcher matcher;

        public TodoScanningData(IndexPattern pattern, Matcher matcher) {
            this.matcher = matcher;
            this.pattern = pattern;
        }
    }

    public static interface OccurrenceConsumer {
        public void addOccurrence(CharSequence var1, int var2, int var3, int var4);

        public boolean canConsumeTodoOccurrences();

        public void incTodoOccurrence(IndexPattern var1);
    }
}

