/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterImpl;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.EmptyCacheManager;
import com.intellij.psi.impl.EmptyFileManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.impl.cache.impl.CompositeCacheManager;
import com.intellij.psi.impl.cache.impl.IndexCacheManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiManagerImpl
extends PsiManagerEx
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiManagerImpl");
    private final Project myProject;
    private final FileManager myFileManager;
    private final PsiSearchHelperImpl mySearchHelper;
    private final CacheManager myCacheManager;
    private final PsiModificationTrackerImpl myModificationTracker;
    private final ResolveCache myResolveCache;
    private final NotNullLazyValue<CachedValuesManager> myCachedValuesManager = new NotNullLazyValue<CachedValuesManager>(){

        @NotNull
        protected CachedValuesManager compute() {
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)PsiManagerImpl.this.myProject);
            if (cachedValuesManager == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl$1.compute must not return null");
            }
            return cachedValuesManager;
        }
    };
    private final List<PsiTreeChangePreprocessor> myTreeChangePreprocessors = ContainerUtil.createEmptyCOWList();
    private final List<PsiTreeChangeListener> myTreeChangeListeners = ContainerUtil.createEmptyCOWList();
    private boolean myTreeChangeEventIsFiring = false;
    private final List<Runnable> myRunnablesOnChange = ContainerUtil.createEmptyCOWList();
    private final List<WeakReference<Runnable>> myWeakRunnablesOnChange = ContainerUtil.createEmptyCOWList();
    private final List<Runnable> myRunnablesOnAnyChange = ContainerUtil.createEmptyCOWList();
    private final List<Runnable> myRunnablesAfterAnyChange = ContainerUtil.createEmptyCOWList();
    private boolean myIsDisposed;
    private VirtualFileFilter myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
    private final AtomicInteger myBatchFilesProcessingModeCount = new AtomicInteger(0);
    private static final Key<PsiFile> CACHED_PSI_FILE_COPY_IN_FILECONTENT = Key.create((String)"CACHED_PSI_FILE_COPY_IN_FILECONTENT");
    private final List<LanguageInjector> myLanguageInjectors = ContainerUtil.createEmptyCOWList();

    public PsiManagerImpl(Project project, ProjectRootManagerEx projectRootManagerEx, StartupManager startupManager, FileTypeManager fileTypeManager, FileDocumentManager fileDocumentManager, PsiBuilderFactory psiBuilderFactory) {
        CacheManager[] managers;
        this.myProject = project;
        PsiBuilderFactory used = psiBuilderFactory;
        boolean isProjectDefault = project.isDefault();
        this.myFileManager = isProjectDefault ? new EmptyFileManager(this) : new FileManagerImpl(this, fileTypeManager, fileDocumentManager, projectRootManagerEx);
        this.mySearchHelper = new PsiSearchHelperImpl(this);
        CompositeCacheManager cacheManager = new CompositeCacheManager();
        if (isProjectDefault) {
            cacheManager.addCacheManager(new EmptyCacheManager());
        } else {
            cacheManager.addCacheManager(new IndexCacheManagerImpl(this));
        }
        for (CacheManager manager : managers = (CacheManager[])this.myProject.getComponents(CacheManager.class)) {
            cacheManager.addCacheManager(manager);
        }
        this.myCacheManager = cacheManager;
        this.myModificationTracker = new PsiModificationTrackerImpl(this.myProject);
        this.myTreeChangePreprocessors.add(this.myModificationTracker);
        this.myResolveCache = new ResolveCache(this);
        if (startupManager != null) {
            startupManager.registerPreStartupActivity(new Runnable(){

                @Override
                public void run() {
                    PsiManagerImpl.this.runPreStartupActivity();
                }
            });
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myFileManager.dispose();
        this.myCacheManager.dispose();
        this.myIsDisposed = true;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void dropResolveCaches() {
        this.myResolveCache.clearCache();
        this.physicalChange();
        this.nonPhysicalChange();
    }

    public boolean isInProject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.isInProject must not be null");
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiFileImpl && file.isPhysical() && file.getViewProvider().getVirtualFile() instanceof LightVirtualFile) {
            return true;
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs;
            for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)element).getDirectories()) {
                if (this.isInProject((PsiElement)dir)) continue;
                return false;
            }
            return true;
        }
        VirtualFile virtualFile = null;
        if (file != null) {
            virtualFile = file.getViewProvider().getVirtualFile();
        } else if (element instanceof PsiFileSystemItem) {
            virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        }
        if (virtualFile != null) {
            Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)element.getProject());
            return module != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performActionWithFormatterDisabled(final Runnable r) {
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.getProject().getComponent(PostprocessReformattingAspect.class);
        try {
            ((FormatterImpl)FormatterEx.getInstance()).disableFormatting();
            component.disablePostprocessFormattingInside(new Computable<Object>(){

                public Object compute() {
                    r.run();
                    return null;
                }
            });
        }
        finally {
            ((FormatterImpl)FormatterEx.getInstance()).enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Throwable> void performActionWithFormatterDisabled(final ThrowableRunnable<T> r) throws T {
        final Throwable[] throwable = new Throwable[1];
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.getProject().getComponent(PostprocessReformattingAspect.class);
        try {
            ((FormatterImpl)FormatterEx.getInstance()).disableFormatting();
            component.disablePostprocessFormattingInside(new Computable<Object>(){

                public Object compute() {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        throwable[0] = t;
                    }
                    return null;
                }
            });
        }
        finally {
            ((FormatterImpl)FormatterEx.getInstance()).enableFormatting();
        }
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        try {
            PostprocessReformattingAspect component = PostprocessReformattingAspect.getInstance(this.getProject());
            ((FormatterImpl)FormatterEx.getInstance()).disableFormatting();
            T t = component.disablePostprocessFormattingInside(r);
            return t;
        }
        finally {
            ((FormatterImpl)FormatterEx.getInstance()).enableFormatting();
        }
    }

    @Override
    @NotNull
    public List<? extends LanguageInjector> getLanguageInjectors() {
        List<LanguageInjector> list = this.myLanguageInjectors;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getLanguageInjectors must not return null");
        }
        return list;
    }

    public void registerLanguageInjector(@NotNull LanguageInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerLanguageInjector must not be null");
        }
        this.myLanguageInjectors.add(injector);
        InjectedLanguageManagerImpl.getInstanceImpl(this.myProject).psiManagerInjectorsChanged();
    }

    public void registerLanguageInjector(final @NotNull LanguageInjector injector, Disposable parentDisposable) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerLanguageInjector must not be null");
        }
        this.registerLanguageInjector(injector);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PsiManagerImpl.this.unregisterLanguageInjector(injector);
            }
        });
    }

    public void unregisterLanguageInjector(@NotNull LanguageInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.unregisterLanguageInjector must not be null");
        }
        this.myLanguageInjectors.remove(injector);
        InjectedLanguageManagerImpl.getInstanceImpl(this.myProject).psiManagerInjectorsChanged();
    }

    public void postponeAutoFormattingInside(Runnable runnable) {
        PostprocessReformattingAspect.getInstance(this.getProject()).postponeFormattingInside(runnable);
    }

    public void projectClosed() {
    }

    public void projectOpened() {
    }

    private void runPreStartupActivity() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PsiManager.runPreStartupActivity()");
        }
        this.myFileManager.runStartupActivity();
        this.myCacheManager.initialize();
        StartupManagerEx startupManager = StartupManagerEx.getInstanceEx(this.myProject);
        if (startupManager != null) {
            CacheUpdater[] updaters;
            for (CacheUpdater updater : updaters = this.myCacheManager.getCacheUpdaters()) {
                startupManager.registerCacheUpdater(updater);
            }
        }
    }

    public void setAssertOnFileLoadingFilter(VirtualFileFilter filter) {
        this.myAssertOnFileLoadingFilter = filter;
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.isAssertOnFileLoading must not be null");
        }
        return this.myAssertOnFileLoadingFilter.accept(file);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getProject must not return null");
        }
        return project;
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        FileManager fileManager = this.myFileManager;
        if (fileManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getFileManager must not return null");
        }
        return fileManager;
    }

    @Override
    @NotNull
    public CacheManager getCacheManager() {
        if (this.myIsDisposed) {
            LOG.error("Project is already disposed.");
        }
        CacheManager cacheManager = this.myCacheManager;
        if (cacheManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getCacheManager must not return null");
        }
        return cacheManager;
    }

    @NotNull
    public CodeStyleManager getCodeStyleManager() {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        if (codeStyleManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getCodeStyleManager must not return null");
        }
        return codeStyleManager;
    }

    @Override
    @NotNull
    public ResolveCache getResolveCache() {
        ProgressManager.checkCanceled();
        ResolveCache resolveCache = this.myResolveCache;
        if (resolveCache == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getResolveCache must not return null");
        }
        return resolveCache;
    }

    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        ProgressManager.checkCanceled();
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        return element1.equals(element2) || element1.isEquivalentTo(element2) || element2.isEquivalentTo(element1);
    }

    public PsiFile findFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.findFile must not be null");
        }
        return this.myFileManager.findFile(file);
    }

    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.findViewProvider must not be null");
        }
        return this.myFileManager.findViewProvider(file);
    }

    public void cleanupForNextTest() {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
    }

    @Nullable
    public PsiFile getFile(FileContent content) {
        PsiFile psiFile = (PsiFile)content.getUserData(CACHED_PSI_FILE_COPY_IN_FILECONTENT);
        if (psiFile == null) {
            VirtualFile vFile = content.getVirtualFile();
            psiFile = this.myFileManager.getCachedPsiFile(vFile);
            if (psiFile == null) {
                psiFile = this.findFile(vFile);
                if (psiFile == null) {
                    return null;
                }
                psiFile = CacheUtil.createFileCopy(content, psiFile);
            }
            content.putUserData(CACHED_PSI_FILE_COPY_IN_FILECONTENT, (Object)psiFile);
        }
        LOG.assertTrue(psiFile instanceof PsiCompiledElement || psiFile.isValid());
        return psiFile;
    }

    public PsiDirectory findDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.findDirectory must not be null");
        }
        ProgressManager.checkCanceled();
        return this.myFileManager.findDirectory(file);
    }

    @Override
    public void invalidateFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.invalidateFile must not be null");
        }
        if (this.myIsDisposed) {
            LOG.error("Disposed PsiManager calls invalidateFile!");
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (file.getViewProvider().isPhysical() && this.myCacheManager != null) {
            this.myCacheManager.addOrInvalidateFile(virtualFile);
        }
    }

    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.reloadFromDisk must not be null");
        }
        this.myFileManager.reloadFromDisk(file);
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.addPsiTreeChangeListener must not be null");
        }
        this.myTreeChangeListeners.add(listener);
    }

    public void addPsiTreeChangeListener(final @NotNull PsiTreeChangeListener listener, Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.addPsiTreeChangeListener must not be null");
        }
        this.addPsiTreeChangeListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PsiManagerImpl.this.removePsiTreeChangeListener(listener);
            }
        });
    }

    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.removePsiTreeChangeListener must not be null");
        }
        this.myTreeChangeListeners.remove(listener);
    }

    public void beforeChildAddition(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildAddition: parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.beforeChildRemoval must not be null");
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildRemoval: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.beforeChildReplacement must not be null");
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildReplacement: oldChild = " + event.getOldChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    public void beforeChildrenChange(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildrenChange: parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    public void beforeChildMovement(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildMovement: child = " + event.getChild() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent());
        }
        this.fireEvent(event);
    }

    public void beforePropertyChange(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforePropertyChange: element = " + event.getElement() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue());
        }
        this.fireEvent(event);
    }

    public void childAdded(PsiTreeChangeEventImpl event) {
        this.onChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childAdded: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterAnyChange();
    }

    public void childRemoved(PsiTreeChangeEventImpl event) {
        this.onChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childRemoved: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterAnyChange();
    }

    public void childReplaced(PsiTreeChangeEventImpl event) {
        this.onChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childReplaced: oldChild = " + event.getOldChild() + ", newChild = " + event.getNewChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterAnyChange();
    }

    public void childMoved(PsiTreeChangeEventImpl event) {
        this.onChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childMoved: child = " + event.getChild() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent());
        }
        this.fireEvent(event);
        this.afterAnyChange();
    }

    public void childrenChanged(PsiTreeChangeEventImpl event) {
        this.onChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childrenChanged: parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterAnyChange();
    }

    public void propertyChanged(PsiTreeChangeEventImpl event) {
        this.onChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("propertyChanged: element = " + event.getElement() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue());
        }
        this.fireEvent(event);
        this.afterAnyChange();
    }

    public void addTreeChangePreprocessor(PsiTreeChangePreprocessor preprocessor) {
        this.myTreeChangePreprocessors.add(preprocessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(PsiTreeChangeEventImpl event) {
        boolean isRealTreeChange = event.getCode() != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && event.getCode() != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE;
        PsiFile file = event.getFile();
        if (file == null || file.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (isRealTreeChange) {
            LOG.assertTrue(!this.myTreeChangeEventIsFiring, (Object)"Changes to PSI are not allowed inside event processing");
            this.myTreeChangeEventIsFiring = true;
        }
        try {
            for (PsiTreeChangePreprocessor preprocessor : this.myTreeChangePreprocessors) {
                preprocessor.treeChanged(event);
            }
            for (PsiTreeChangeListener listener : this.myTreeChangeListeners) {
                try {
                    switch (event.getCode()) {
                        case BEFORE_CHILD_ADDITION: {
                            listener.beforeChildAddition((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_REMOVAL: {
                            listener.beforeChildRemoval((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_REPLACEMENT: {
                            listener.beforeChildReplacement((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_MOVEMENT: {
                            listener.beforeChildMovement((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILDREN_CHANGE: {
                            listener.beforeChildrenChange((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_PROPERTY_CHANGE: {
                            listener.beforePropertyChange((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_ADDED: {
                            listener.childAdded((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_REMOVED: {
                            listener.childRemoved((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_REPLACED: {
                            listener.childReplaced((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_MOVED: {
                            listener.childMoved((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILDREN_CHANGED: {
                            listener.childrenChanged((PsiTreeChangeEvent)event);
                            break;
                        }
                        case PROPERTY_CHANGED: {
                            listener.propertyChanged((PsiTreeChangeEvent)event);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        finally {
            if (isRealTreeChange) {
                this.myTreeChangeEventIsFiring = false;
            }
        }
    }

    @Override
    public void registerRunnableToRunOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerRunnableToRunOnChange must not be null");
        }
        this.myRunnablesOnChange.add(runnable);
    }

    @Override
    public void registerWeakRunnableToRunOnChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerWeakRunnableToRunOnChange must not be null");
        }
        this.myWeakRunnablesOnChange.add(new WeakReference<Runnable>(runnable));
    }

    @Override
    public void registerRunnableToRunOnAnyChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerRunnableToRunOnAnyChange must not be null");
        }
        this.myRunnablesOnAnyChange.add(runnable);
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerRunnableToRunAfterAnyChange must not be null");
        }
        this.myRunnablesAfterAnyChange.add(runnable);
    }

    @Override
    public void nonPhysicalChange() {
        this.onChange(false);
    }

    @Override
    public void physicalChange() {
        this.onChange(true);
    }

    private void onChange(boolean isPhysical) {
        if (isPhysical) {
            PsiManagerImpl.runRunnables(this.myRunnablesOnChange);
            WeakReference[] refs = this.myWeakRunnablesOnChange.toArray(new WeakReference[this.myWeakRunnablesOnChange.size()]);
            this.myWeakRunnablesOnChange.clear();
            for (WeakReference ref : refs) {
                Runnable runnable;
                Runnable runnable2 = runnable = ref != null ? (Runnable)ref.get() : null;
                if (runnable == null) continue;
                runnable.run();
            }
        }
        PsiManagerImpl.runRunnables(this.myRunnablesOnAnyChange);
    }

    private void afterAnyChange() {
        PsiManagerImpl.runRunnables(this.myRunnablesAfterAnyChange);
    }

    private static void runRunnables(List<Runnable> runnables) {
        if (runnables.isEmpty()) {
            return;
        }
        for (int i = 0; i < runnables.size(); ++i) {
            runnables.get(i).run();
        }
    }

    @NotNull
    public PsiSearchHelper getSearchHelper() {
        PsiSearchHelperImpl psiSearchHelperImpl = this.mySearchHelper;
        if (psiSearchHelperImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getSearchHelper must not return null");
        }
        return psiSearchHelperImpl;
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        PsiModificationTrackerImpl psiModificationTrackerImpl = this.myModificationTracker;
        if (psiModificationTrackerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getModificationTracker must not return null");
        }
        return psiModificationTrackerImpl;
    }

    @NotNull
    public CachedValuesManager getCachedValuesManager() {
        CachedValuesManager cachedValuesManager = (CachedValuesManager)this.myCachedValuesManager.getValue();
        if (cachedValuesManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getCachedValuesManager must not return null");
        }
        return cachedValuesManager;
    }

    public void moveDirectory(@NotNull PsiDirectory dir, @NotNull PsiDirectory newParent) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.moveDirectory must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.moveDirectory must not be null");
        }
        this.checkMove((PsiElement)dir, (PsiElement)newParent);
        try {
            dir.getVirtualFile().move((Object)this, newParent.getVirtualFile());
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), (Exception)e);
        }
    }

    public void moveFile(@NotNull PsiFile file, @NotNull PsiDirectory newParent) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.moveFile must not be null");
        }
        this.checkMove((PsiElement)file, (PsiElement)newParent);
        try {
            VirtualFile virtualFile = file.getVirtualFile();
            assert (virtualFile != null);
            virtualFile.move((Object)this, newParent.getVirtualFile());
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), (Exception)e);
        }
    }

    public void checkMove(@NotNull PsiElement element, @NotNull PsiElement newContainer) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.checkMove must not be null");
        }
        if (newContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.checkMove must not be null");
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs = ((PsiDirectoryContainer)element).getDirectories();
            if (dirs.length == 0) {
                throw new IncorrectOperationException();
            }
            if (dirs.length > 1) {
                throw new IncorrectOperationException("Moving of packages represented by more than one physical directory is not supported.");
            }
            this.checkMove((PsiElement)dirs[0], newContainer);
            return;
        }
        newContainer.checkAdd(element);
        MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(element, newContainer);
    }

    public void startBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.incrementAndGet();
    }

    public void finishBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.decrementAndGet();
        LOG.assertTrue(this.myBatchFilesProcessingModeCount.get() >= 0);
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return this.myBatchFilesProcessingModeCount.get() > 0;
    }

    @NotNull
    public String getComponentName() {
        if ("PsiManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getComponentName must not return null");
        }
        return "PsiManager";
    }
}

