/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LabeledJavaBlock
extends AbstractJavaBlock {
    public LabeledJavaBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CodeStyleSettings settings) {
        super(node, wrap, alignment, indent, settings);
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        Indent currentIndent = this.getLabelIndent();
        Wrap currentWrap = null;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(child) || child.getTextLength() <= 0) continue;
            result.add(LabeledJavaBlock.createJavaBlock(child, this.mySettings, currentIndent, currentWrap, null));
            if (child.getElementType() != ElementType.COLON) continue;
            currentIndent = Indent.getNoneIndent();
            currentWrap = Wrap.createWrap((WrapType)Wrap.ALWAYS, (boolean)true);
        }
        return result;
    }

    private Indent getLabelIndent() {
        if (this.mySettings.getIndentOptions((FileType)StdFileTypes.JAVA).LABEL_INDENT_ABSOLUTE) {
            return Indent.getAbsoluteLabelIndent();
        }
        return Indent.getLabelIndent();
    }

    @Override
    protected Wrap getReservedWrap(IElementType elementType) {
        return null;
    }

    @Override
    protected void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/LabeledJavaBlock.getChildAttributes must not return null");
        }
        return childAttributes;
    }
}

