/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.TogglePopupHintsPanel;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.DefaultProjectProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="InspectionProjectProfileManager", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/inspectionProfiles/", scheme=StorageScheme.DIRECTORY_BASED, stateSplitter=DefaultProjectProfileManager.ProfileStateSplitter.class)})
public class InspectionProjectProfileManager
extends DefaultProjectProfileManager
implements SeverityProvider,
ProjectComponent,
PersistentStateComponent<Element> {
    private final Map<String, InspectionProfileWrapper> myName2Profile = new HashMap<String, InspectionProfileWrapper>();
    private final SeverityRegistrar mySeverityRegistrar = new SeverityRegistrar();
    private StatusBarEx myStatusBar;
    private TogglePopupHintsPanel myTogglePopupHintsPanel;

    public InspectionProjectProfileManager(Project project, DependencyValidationManager holder) {
        super(project, "INSPECTION", holder);
    }

    public static InspectionProjectProfileManager getInstance(Project project) {
        return (InspectionProjectProfileManager)project.getComponent(InspectionProjectProfileManager.class);
    }

    public String getProfileName() {
        return this.getInspectionProfile().getName();
    }

    public Element getState() {
        try {
            Element e = new Element("settings");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public InspectionProfile getInspectionProfile() {
        InspectionProfile inspectionProfile = (InspectionProfile)this.getProjectProfileImpl();
        if (inspectionProfile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/codeInspection/InspectionProjectProfileManager.getInspectionProfile must not return null");
        }
        return inspectionProfile;
    }

    @NotNull
    public InspectionProfile getInspectionProfile(PsiElement element) {
        InspectionProfile inspectionProfile = this.getInspectionProfile();
        if (inspectionProfile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/codeInspection/InspectionProjectProfileManager.getInspectionProfile must not return null");
        }
        return inspectionProfile;
    }

    public InspectionProfileWrapper getProfileWrapper() {
        InspectionProfile profile = this.getInspectionProfile();
        String profileName = profile.getName();
        if (!this.myName2Profile.containsKey(profileName)) {
            this.initProfileWrapper((Profile)profile);
        }
        return this.myName2Profile.get(profileName);
    }

    public InspectionProfileWrapper getProfileWrapper(String profileName) {
        return this.myName2Profile.get(profileName);
    }

    public void updateProfile(Profile profile) {
        super.updateProfile(profile);
        this.initProfileWrapper(profile);
    }

    public void deleteProfile(String name) {
        super.deleteProfile(name);
        InspectionProfileWrapper profileWrapper = this.myName2Profile.remove(name);
        LOG.assertTrue(profileWrapper != null, (Object)("Profile wasn't initialized" + name));
        profileWrapper.cleanup(this.myProject);
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("InspectionProjectProfileManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/codeInspection/InspectionProjectProfileManager.getComponentName must not return null");
        }
        return "InspectionProjectProfileManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        this.myStatusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(this.myProject);
        this.myTogglePopupHintsPanel = new TogglePopupHintsPanel(this.myStatusBar);
        this.myStatusBar.addFileStatusComponent(this.myTogglePopupHintsPanel);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                InspectionProjectProfileManager.this.myStatusBar.removeFileStatusComponent(InspectionProjectProfileManager.this.myTogglePopupHintsPanel);
            }
        });
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                final HashSet<Profile> profiles = new HashSet<Profile>();
                profiles.add(InspectionProjectProfileManager.this.getProjectProfileImpl());
                profiles.addAll(InspectionProjectProfileManager.this.getProfiles());
                profiles.addAll(InspectionProfileManager.getInstance().getProfiles());
                Application app = ApplicationManager.getApplication();
                Runnable initInspectionProfilesRunnable = new Runnable(){

                    @Override
                    public void run() {
                        for (Profile profile : profiles) {
                            InspectionProjectProfileManager.this.initProfileWrapper(profile);
                        }
                    }
                };
                if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
                    initInspectionProfilesRunnable.run();
                } else {
                    app.executeOnPooledThread(initInspectionProfilesRunnable);
                }
            }
        });
    }

    public void initProfileWrapper(Profile profile) {
        InspectionProfileWrapper wrapper = new InspectionProfileWrapper((InspectionProfile)profile);
        wrapper.init(this.myProject);
        this.myName2Profile.put(profile.getName(), wrapper);
    }

    public void projectClosed() {
        Application app = ApplicationManager.getApplication();
        Runnable cleanupInspectionProfilesRunnable = new Runnable(){

            @Override
            public void run() {
                for (InspectionProfileWrapper wrapper : InspectionProjectProfileManager.this.myName2Profile.values()) {
                    wrapper.cleanup(InspectionProjectProfileManager.this.myProject);
                }
            }
        };
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            cleanupInspectionProfilesRunnable.run();
        } else {
            app.executeOnPooledThread(cleanupInspectionProfilesRunnable);
        }
        HighlightingSettingsPerFile.getInstance(this.myProject).cleanProfileSettings();
    }

    @Override
    public SeverityRegistrar getSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    @Override
    public SeverityRegistrar getOwnSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.mySeverityRegistrar.readExternal(element);
        super.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.mySeverityRegistrar.writeExternal(element);
    }

    public void updateStatusBar() {
        if (this.myTogglePopupHintsPanel != null) {
            this.myTogglePopupHintsPanel.updateStatus();
        }
    }

    public Profile getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/codeInspection/InspectionProjectProfileManager.getProfile must not be null");
        }
        return this.getProfile(name, true);
    }

    public void convert(Element element) throws InvalidDataException {
        super.convert(element);
        if (this.PROJECT_PROFILE != null) {
            ((InspectionProfileImpl)this.getProjectProfileImpl()).convert(element);
        }
    }
}

