/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeVisitor;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.events.XmlTextChanged;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;

public class XmlTextChangedImpl
implements XmlTextChanged {
    private final String myOldText;
    private final XmlText myText;

    public XmlTextChangedImpl(XmlText xmlText, String oldText) {
        this.myOldText = oldText;
        this.myText = xmlText;
    }

    public String getOldText() {
        return this.myOldText;
    }

    public XmlText getText() {
        return this.myText;
    }

    public static PomModelEvent createXmlTextChanged(PomModel source, XmlText xmlText, String oldText) {
        PomModelEvent event = new PomModelEvent(source);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(source, (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)xmlText, XmlFile.class));
        xmlAspectChangeSet.add((XmlChange)new XmlTextChangedImpl(xmlText, oldText));
        event.registerChangeSet(source.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "text changed to '" + StringUtil.escapeStringCharacters((String)this.myText.getValue()) + "' was: '" + StringUtil.escapeStringCharacters((String)this.myOldText) + "'";
    }

    public void accept(XmlChangeVisitor visitor) {
        visitor.visitXmlTextChanged((XmlTextChanged)this);
    }
}

