/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.references;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomPsiReference;
import com.intellij.pom.references.PomReference;
import com.intellij.pom.references.PomReferenceProvider;
import com.intellij.pom.references.PomReferenceService;
import com.intellij.pom.references.PomReferenceUtil;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomReferenceServiceImpl
extends PomReferenceService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.pom.references.PomReferenceServiceImpl");
    private final Map<Class, SimpleProviderBinding<PomReferenceProvider>> myBindingsMap = CollectionFactory.newTroveMap();
    private final Map<Class, NamedObjectProviderBinding<PomReferenceProvider>> myNamedBindingsMap = CollectionFactory.newTroveMap();
    private final FactoryMap<Class, Set<Class>> myPossibleSupers = new ConcurrentFactoryMap<Class, Set<Class>>(){

        protected Set<Class> create(final Class key) {
            Set result = CollectionFactory.newTroveSet((Object[])new Object[0]);
            Condition<Class> condition = new Condition<Class>(){

                public boolean value(Class ancestor) {
                    return ancestor.isAssignableFrom(key);
                }
            };
            result.addAll(ContainerUtil.findAll(PomReferenceServiceImpl.this.myBindingsMap.keySet(), (Condition)condition));
            result.addAll(ContainerUtil.findAll(PomReferenceServiceImpl.this.myNamedBindingsMap.keySet(), (Condition)condition));
            return result;
        }
    };
    private static final Comparator<Trinity<PomReferenceProvider, ProcessingContext, Double>> PRIORITY_COMPARATOR = new Comparator<Trinity<PomReferenceProvider, ProcessingContext, Double>>(){

        @Override
        public int compare(Trinity<PomReferenceProvider, ProcessingContext, Double> o1, Trinity<PomReferenceProvider, ProcessingContext, Double> o2) {
            return ((Double)o2.getThird()).compareTo((Double)o1.getThird());
        }
    };

    public PomReferenceServiceImpl() {
        MyPomReferenceRegistrar registrar = new MyPomReferenceRegistrar();
        for (PsiReferenceContributor contributor : (PsiReferenceContributor[])PsiReferenceContributor.EP_NAME.getExtensions()) {
            contributor.registerReferenceProviders((PsiReferenceRegistrar)registrar);
        }
    }

    @NotNull
    private List<Trinity<PomReferenceProvider, ProcessingContext, Double>> getPairsByElement(@NotNull PsiElement element, @Nullable Integer offset) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl.getPairsByElement must not be null");
        }
        SmartList ret = null;
        for (Class aClass : (Set)ObjectUtils.assertNotNull((Object)this.myPossibleSupers.get(element.getClass()))) {
            SimpleProviderBinding<PomReferenceProvider> simpleBinding = this.myBindingsMap.get(aClass);
            NamedObjectProviderBinding<PomReferenceProvider> namedBinding = this.myNamedBindingsMap.get(aClass);
            if (simpleBinding == null && namedBinding == null) continue;
            if (ret == null) {
                ret = new SmartList();
            }
            if (simpleBinding != null) {
                simpleBinding.addAcceptableReferenceProviders(element, (List<Trinity<PomReferenceProvider, ProcessingContext, Double>>)ret, offset);
            }
            if (namedBinding == null) continue;
            namedBinding.addAcceptableReferenceProviders(element, (List<Trinity<PomReferenceProvider, ProcessingContext, Double>>)ret, offset);
        }
        List<Object> list = ret == null ? Collections.emptyList() : ret;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReferenceServiceImpl.getPairsByElement must not return null");
        }
        return list;
    }

    private List<PomReference> getReferencesFromProviders(PsiElement context, Integer offset) {
        ProgressManager.checkCanceled();
        assert (context.isValid()) : "Invalid context: " + context;
        List<Trinity<PomReferenceProvider, ProcessingContext, Double>> providers = this.getPairsByElement(context, offset);
        if (providers.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(providers, PRIORITY_COMPARATOR);
        ArrayList result = CollectionFactory.arrayList();
        Double maxPriority = Double.MAX_VALUE;
        for (Trinity<PomReferenceProvider, ProcessingContext, Double> trinity : providers) {
            if (result.isEmpty()) {
                maxPriority = (Double)trinity.third;
            } else if (!((Double)trinity.getThird()).equals(maxPriority)) break;
            PomReferenceProvider provider = (PomReferenceProvider)trinity.getFirst();
            for (PomReference reference : provider.getReferencesByElement(context, (ProcessingContext)trinity.getSecond())) {
                if (reference == null) {
                    LOG.error((Object)context);
                }
                if (!PomReferenceServiceImpl.offsetMatches(offset, reference)) continue;
                result.add(reference);
            }
        }
        return result;
    }

    private static boolean offsetMatches(@Nullable Integer offset, PomReference reference) {
        if (offset == null) {
            return true;
        }
        TextRange range = reference.getRangeInElement();
        int intOffset = offset;
        return range.getStartOffset() <= intOffset && intOffset <= range.getEndOffset();
    }

    @NotNull
    public List<PomReference> findReferencesAt(@NotNull PsiElement element, int offset) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl.findReferencesAt must not be null");
        }
        List<PomReference> list = this.findReferencesAt(element, offset, true);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReferenceServiceImpl.findReferencesAt must not return null");
        }
        return list;
    }

    @NotNull
    private List<PomReference> findReferencesAt(@NotNull PsiElement element, int offset, boolean includeNonPom) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl.findReferencesAt must not be null");
        }
        ArrayList result = CollectionFactory.arrayList();
        result.addAll(this.findPomReferencesAt(element, offset));
        if (includeNonPom) {
            PsiReference reference = element.findReferenceAt(offset);
            if (reference instanceof PsiMultiReference) {
                for (PsiReference psiReference : ((PsiMultiReference)reference).getReferences()) {
                    result.add(new PomPsiReference(psiReference));
                }
            } else if (reference != null) {
                result.add(new PomPsiReference(reference));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReferenceServiceImpl.findReferencesAt must not return null");
        }
        return arrayList;
    }

    private List<PomReference> findPomReferencesAt(PsiElement element, int offset) {
        PsiElement leaf = element.findElementAt(offset);
        if (leaf == null) {
            return Collections.emptyList();
        }
        PsiElement firstComposite = leaf.getParent();
        return this.getReferencesFromProviders(firstComposite, offset - firstComposite.getTextRange().getStartOffset());
    }

    @NotNull
    public List<PomReference> getReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl.getReferences must not be null");
        }
        ArrayList result = CollectionFactory.arrayList();
        result.addAll(this.getReferencesFromProviders(element, null));
        for (PsiReference psiReference : element.getReferences()) {
            result.add(new PomPsiReference(psiReference));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReferenceServiceImpl.getReferences must not return null");
        }
        return arrayList;
    }

    public List<PomReference> findReferencesAt(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl.findReferencesAt must not be null");
        }
        return this.findReferencesAt(editor, offset, true);
    }

    private List<PomReference> findReferencesAt(@NotNull Editor editor, int offset, boolean includeNonPom) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl.findReferencesAt must not be null");
        }
        Project project = editor.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return Collections.emptyList();
        }
        offset = TargetElementUtilBase.adjustOffset(document, offset);
        PsiFile element = file instanceof PsiCompiledElement ? ((PsiCompiledElement)file).getMirror() : file;
        return this.findReferencesAt((PsiElement)element, offset, includeNonPom);
    }

    public List<PomTarget> getReferencedTargets(@NotNull Editor editor, int offset) {
        int flags;
        PsiElement targetElement;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl.getReferencedTargets must not be null");
        }
        ArrayList result = CollectionFactory.arrayList();
        for (PomReference pomReference : this.findReferencesAt(editor, TargetElementUtilBase.adjustOffset(editor.getDocument(), offset), false)) {
            for (PomTarget target : pomReference.multiResolve()) {
                if (!target.canNavigate()) continue;
                result.add(target);
            }
        }
        if (!result.isEmpty()) {
            return result;
        }
        Project project = editor.getProject();
        TargetElementUtilBase oldStuff = TargetElementUtilBase.getInstance();
        if (project != null && (targetElement = oldStuff.findTargetElement(editor, flags = oldStuff.getAllAccepted() & 0xFFFFFFFD, offset)) != null) {
            return Arrays.asList(new DelegatePsiTarget(targetElement));
        }
        PsiReference psiReference = TargetElementUtilBase.findReference(editor, offset);
        if (psiReference != null) {
            for (PsiElement psiElement : oldStuff.getTargetCandidates(psiReference)) {
                PsiElement navElement = oldStuff.getGotoDeclarationTarget(psiElement, psiElement.getNavigationElement());
                result.add(PomReferenceUtil.convertPsi2Target((PsiElement)navElement));
            }
        }
        return result;
    }

    private class MyPomReferenceRegistrar
    extends PsiReferenceRegistrar {
        private MyPomReferenceRegistrar() {
        }

        public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
            if (pattern == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl$MyPomReferenceRegistrar.registerReferenceProvider must not be null");
            }
            if (provider == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl$MyPomReferenceRegistrar.registerReferenceProvider must not be null");
            }
        }

        public Project getProject() {
            return null;
        }

        public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PomReferenceProvider<T> provider, double priority) {
            SimpleProviderBinding<PomReferenceProvider<T>> providerBinding;
            if (pattern == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl$MyPomReferenceRegistrar.registerReferenceProvider must not be null");
            }
            if (provider == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/pom/references/PomReferenceServiceImpl$MyPomReferenceRegistrar.registerReferenceProvider must not be null");
            }
            Class scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)ContainerUtil.findInstance((Iterable)pattern.getCondition().getConditions(), PsiNamePatternCondition.class);
            if (nameCondition != null) {
                ValuePatternCondition valueCondition = (ValuePatternCondition)ContainerUtil.findInstance((Iterable)nameCondition.getNamePattern().getCondition().getConditions(), ValuePatternCondition.class);
                if (valueCondition != null) {
                    Collection strings = valueCondition.getValues();
                    this.registerNamedReferenceProvider(ArrayUtil.toStringArray((Collection)strings), nameCondition, scope, true, provider, priority, pattern);
                    return;
                }
                CaseInsensitiveValuePatternCondition ciCondition = (CaseInsensitiveValuePatternCondition)ContainerUtil.findInstance((Iterable)nameCondition.getNamePattern().getCondition().getConditions(), CaseInsensitiveValuePatternCondition.class);
                if (ciCondition != null) {
                    this.registerNamedReferenceProvider(ciCondition.getValues(), nameCondition, scope, false, provider, priority, pattern);
                    return;
                }
            }
            if ((providerBinding = (SimpleProviderBinding<PomReferenceProvider<T>>)PomReferenceServiceImpl.this.myBindingsMap.get(scope)) == null) {
                providerBinding = new SimpleProviderBinding<PomReferenceProvider<T>>();
                PomReferenceServiceImpl.this.myBindingsMap.put(scope, providerBinding);
            }
            providerBinding.registerProvider(provider, pattern, priority);
        }

        private void registerNamedReferenceProvider(String[] names, final PsiNamePatternCondition<?> nameCondition, Class scopeClass, boolean caseSensitive, PomReferenceProvider provider, double priority, ElementPattern pattern) {
            NamedObjectProviderBinding providerBinding = (NamedObjectProviderBinding)PomReferenceServiceImpl.this.myNamedBindingsMap.get(scopeClass);
            if (providerBinding == null) {
                providerBinding = new NamedObjectProviderBinding<PomReferenceProvider>(){

                    @Override
                    protected String getName(PsiElement position) {
                        return nameCondition.getPropertyValue((Object)position);
                    }
                };
                PomReferenceServiceImpl.this.myNamedBindingsMap.put(scopeClass, providerBinding);
            }
            providerBinding.registerProvider(names, pattern, caseSensitive, provider, priority);
        }
    }
}

