/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiFile;
import java.util.Set;
import javax.swing.Icon;

public class ModuleNode
extends PackageDependenciesNode {
    private final Module myModule;

    public ModuleNode(Module module) {
        this.myModule = module;
    }

    @Override
    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i);
            child.fillFiles(set, true);
        }
    }

    @Override
    public Icon getOpenIcon() {
        return this.myModule == null ? null : this.myModule.getModuleType().getNodeIcon(true);
    }

    @Override
    public Icon getClosedIcon() {
        return this.myModule == null ? null : this.myModule.getModuleType().getNodeIcon(false);
    }

    @Override
    public String toString() {
        return this.myModule == null ? AnalysisScopeBundle.message((String)"unknown.node.text", (Object[])new Object[0]) : this.myModule.getName();
    }

    public String getModuleName() {
        return this.myModule.getName();
    }

    public Module getModule() {
        return this.myModule;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleNode)) {
            return false;
        }
        ModuleNode moduleNode = (ModuleNode)o;
        return Comparing.equal((Object)this.myModule, (Object)moduleNode.myModule);
    }

    public int hashCode() {
        return this.myModule == null ? 0 : this.myModule.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.myModule != null && !this.myModule.isDisposed();
    }
}

