/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Encoding", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/encodings.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class EncodingProjectManagerImpl
extends EncodingProjectManager {
    private final Project myProject;
    private final GeneralSettings myGeneralSettings;
    private final EditorSettingsExternalizable myEditorSettings;
    private boolean myUseUTFGuessing = true;
    private boolean myNative2AsciiForPropertiesFiles;
    private Charset myDefaultCharsetForPropertiesFiles;
    private final Map<VirtualFile, Charset> myMapping = new HashMap();

    public EncodingProjectManagerImpl(Project project, GeneralSettings generalSettings, EditorSettingsExternalizable editorSettings, PsiDocumentManager documentManager) {
        this.myProject = project;
        this.myGeneralSettings = generalSettings;
        this.myEditorSettings = editorSettings;
        documentManager.addListener(new PsiDocumentManager.Listener(){

            public void documentCreated(Document document, PsiFile psiFile) {
                if (document != null) {
                    ((EncodingManagerImpl)EncodingManagerImpl.getInstance()).updateEncodingFromContent(document);
                }
            }

            public void fileCreated(PsiFile file, Document document) {
            }
        });
    }

    public Element getState() {
        Element element = new Element("x");
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myMapping.keySet());
        ContainerUtil.quickSort(files, (Comparator)new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                if (o1 == null || o2 == null) {
                    return o1 == null ? (o2 == null ? 0 : 1) : -1;
                }
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        for (VirtualFile file : files) {
            Charset charset = this.myMapping.get(file);
            Element child = new Element("file");
            element.addContent(child);
            child.setAttribute("url", file == null ? "PROJECT" : file.getUrl());
            child.setAttribute("charset", charset.name());
        }
        element.setAttribute("useUTFGuessing", Boolean.toString(this.myUseUTFGuessing));
        element.setAttribute("native2AsciiForPropertiesFiles", Boolean.toString(this.myNative2AsciiForPropertiesFiles));
        if (this.myDefaultCharsetForPropertiesFiles != null) {
            element.setAttribute("defaultCharsetForPropertiesFiles", this.myDefaultCharsetForPropertiesFiles.name());
        }
        return element;
    }

    public void loadState(Element element) {
        EncodingProjectManager defaultManager;
        List files = element.getChildren("file");
        for (Element fileElement : files) {
            VirtualFile file;
            String url = fileElement.getAttributeValue("url");
            String charsetName = fileElement.getAttributeValue("charset");
            Charset charset = CharsetToolkit.forName((String)charsetName);
            if (charset == null) continue;
            VirtualFile virtualFile = file = url.equals("PROJECT") ? null : VirtualFileManager.getInstance().findFileByUrl(url);
            if (file == null && !url.equals("PROJECT")) continue;
            this.myMapping.put(file, charset);
        }
        this.myUseUTFGuessing = Boolean.parseBoolean(element.getAttributeValue("useUTFGuessing"));
        this.myNative2AsciiForPropertiesFiles = Boolean.parseBoolean(element.getAttributeValue("native2AsciiForPropertiesFiles"));
        this.myDefaultCharsetForPropertiesFiles = CharsetToolkit.forName((String)element.getAttributeValue("defaultCharsetForPropertiesFiles"));
        boolean migrated = this.myGeneralSettings.migrateCharsetSettingsTo((EncodingManager)this);
        if ((migrated |= this.myEditorSettings.migrateCharsetSettingsTo((EncodingManager)this)) && (defaultManager = EncodingProjectManagerImpl.getInstance((Project)ProjectManager.getInstance().getDefaultProject())) != null) {
            this.myGeneralSettings.migrateCharsetSettingsTo((EncodingManager)defaultManager);
            this.myEditorSettings.migrateCharsetSettingsTo((EncodingManager)defaultManager);
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("EncodingProjectManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl.getComponentName must not return null");
        }
        return "EncodingProjectManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        VirtualFile parent = virtualFile;
        while (true) {
            Charset charset;
            if ((charset = this.myMapping.get(parent)) != null || !useParentDefaults) {
                return charset;
            }
            if (parent == null) break;
            parent = parent.getParent();
        }
        return null;
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        if (charset == null) {
            this.myMapping.remove(virtualFileOrDir);
        } else {
            this.myMapping.put(virtualFileOrDir, charset);
        }
        EncodingProjectManagerImpl.setAndSaveOrReload(virtualFileOrDir, charset);
    }

    private static void setAndSaveOrReload(VirtualFile virtualFileOrDir, Charset charset) {
        if (virtualFileOrDir == null || virtualFileOrDir.isDirectory()) {
            return;
        }
        virtualFileOrDir.setCharset(charset);
        EncodingProjectManagerImpl.saveOrReload(virtualFileOrDir);
    }

    private static void saveOrReload(VirtualFile virtualFile) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(virtualFile)) {
            Document document = documentManager.getDocument(virtualFile);
            if (document != null) {
                documentManager.saveDocument(document);
            }
        } else {
            ((VirtualFileListener)documentManager).contentsChanged(new VirtualFileEvent(null, virtualFile, virtualFile.getName(), virtualFile.getParent()));
        }
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        THashSet result = new THashSet();
        result.addAll(this.myMapping.values());
        result.add(CharsetToolkit.UTF8_CHARSET);
        result.add(CharsetToolkit.getDefaultSystemCharset());
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl.getFavorites must not return null");
        }
        return tHashSet;
    }

    public Map<VirtualFile, Charset> getAllMappings() {
        return this.myMapping;
    }

    public void setMapping(Map<VirtualFile, Charset> result) {
        HashMap map = new HashMap(result);
        this.myMapping.clear();
        this.myMapping.putAll((Map<VirtualFile, Charset>)map);
        for (VirtualFile virtualFile : map.keySet()) {
            Charset charset = (Charset)map.get(virtualFile);
            assert (charset != null);
            EncodingProjectManagerImpl.setAndSaveOrReload(virtualFile, charset);
        }
        for (VirtualFile open : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
            if (map.containsKey(open)) continue;
            EncodingProjectManagerImpl.saveOrReload(open);
        }
    }

    public Charset getDefaultCharset() {
        Charset charset = this.getEncoding(null, false);
        return charset == null ? EncodingManager.getInstance().getDefaultCharset() : charset;
    }

    public boolean isUseUTFGuessing(VirtualFile virtualFile) {
        return this.myUseUTFGuessing;
    }

    public void setUseUTFGuessing(VirtualFile virtualFile, boolean useUTFGuessing) {
        this.myUseUTFGuessing = useUTFGuessing;
    }

    public boolean isNative2AsciiForPropertiesFiles(VirtualFile virtualFile) {
        return this.myNative2AsciiForPropertiesFiles;
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
        if (this.myNative2AsciiForPropertiesFiles != native2Ascii) {
            this.myNative2AsciiForPropertiesFiles = native2Ascii;
            ((EncodingManagerImpl)EncodingManager.getInstance()).firePropertyChange("native2ascii", !native2Ascii, native2Ascii);
        }
    }

    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        return this.myDefaultCharsetForPropertiesFiles;
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, @Nullable Charset charset) {
        Charset old = this.myDefaultCharsetForPropertiesFiles;
        if (!Comparing.equal((Object)old, (Object)charset)) {
            this.myDefaultCharsetForPropertiesFiles = charset;
            ((EncodingManagerImpl)EncodingManager.getInstance()).firePropertyChange("propertiesFilesEncoding", old, charset);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        EncodingManager.getInstance().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        EncodingManager.getInstance().removePropertyChangeListener(listener);
    }

    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl.getCachedCharsetFromContent must not be null");
        }
        return EncodingManager.getInstance().getCachedCharsetFromContent(document);
    }
}

