/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.Alarm;
import gnu.trove.THashSet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Encoding", storages={@Storage(id="Encoding", file="$APP_CONFIG$/encoding.xml")})
public class EncodingManagerImpl
extends EncodingManager
implements PersistentStateComponent<Element>,
Disposable {
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport((Object)this);
    private String myDefaultEncoding = "";
    private Charset myCachedCharset = null;
    private final Alarm updateEncodingFromContent = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)this);
    private static final Key<Charset> CACHED_CHARSET_FROM_CONTENT = Key.create((String)"CACHED_CHARSET_FROM_CONTENT");
    private final Queue<Document> myChangedDocuments = new ConcurrentLinkedQueue<Document>();
    private final Runnable myEncodingUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            Document document = (Document)EncodingManagerImpl.this.myChangedDocuments.poll();
            if (document == null) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                return;
            }
            Project project = EncodingManagerImpl.guessProject(virtualFile);
            if (project != null && project.isDisposed()) {
                return;
            }
            Charset charset = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, document.getText());
            document.putUserData(CACHED_CHARSET_FROM_CONTENT, (Object)charset);
        }
    };

    public void dispose() {
        this.updateEncodingFromContent.cancelAllRequests();
    }

    public void updateEncodingFromContent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/encoding/EncodingManagerImpl.updateEncodingFromContent must not be null");
        }
        this.myChangedDocuments.offer(document);
        this.updateEncodingFromContent.cancelAllRequests();
        this.updateEncodingFromContent.addRequest(this.myEncodingUpdateRunnable, 400);
    }

    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/encoding/EncodingManagerImpl.getCachedCharsetFromContent must not be null");
        }
        return (Charset)document.getUserData(CACHED_CHARSET_FROM_CONTENT);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("EncodingManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/encoding/EncodingManagerImpl.getComponentName must not return null");
        }
        return "EncodingManager";
    }

    public void initComponent() {
        DocumentAdapter myDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                EncodingManagerImpl.this.updateEncodingFromContent(e.getDocument());
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)myDocumentListener, (Disposable)this);
    }

    public void disposeComponent() {
    }

    public Element getState() {
        Element result = new Element("x");
        result.setAttribute("default_encoding", this.myDefaultEncoding);
        return result;
    }

    public void loadState(Element state) {
        this.myCachedCharset = null;
        this.myDefaultEncoding = state.getAttributeValue("default_encoding");
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Project[] projects;
        THashSet result = new THashSet();
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            result.addAll(EncodingProjectManager.getInstance((Project)project).getFavorites());
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/encoding/EncodingManagerImpl.getFavorites must not return null");
        }
        return tHashSet;
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return null;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
        if (encodingManager == null) {
            return null;
        }
        return encodingManager.getEncoding(virtualFile, useParentDefaults);
    }

    @Nullable
    private static Project guessProject(VirtualFile virtualFile) {
        return ProjectLocator.getInstance().guessProjectForFile(virtualFile);
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Project project = EncodingManagerImpl.guessProject(virtualFileOrDir);
        EncodingProjectManager.getInstance((Project)project).setEncoding(virtualFileOrDir, charset);
    }

    public boolean isUseUTFGuessing(VirtualFile virtualFile) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        return project != null && EncodingProjectManager.getInstance((Project)project).isUseUTFGuessing(virtualFile);
    }

    public void setUseUTFGuessing(VirtualFile virtualFile, boolean useUTFGuessing) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project).setUseUTFGuessing(virtualFile, useUTFGuessing);
    }

    public boolean isNative2AsciiForPropertiesFiles(VirtualFile virtualFile) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        return project != null && EncodingProjectManager.getInstance((Project)project).isNative2AsciiForPropertiesFiles(virtualFile);
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project).setNative2AsciiForPropertiesFiles(virtualFile, native2Ascii);
    }

    public Charset getDefaultCharset() {
        Charset result = this.myCachedCharset;
        if (result == null) {
            this.myCachedCharset = result = this.cacheCharset();
        }
        return result;
    }

    public String getDefaultCharsetName() {
        return this.myDefaultEncoding;
    }

    public void setDefaultCharsetName(String name) {
        this.myDefaultEncoding = name;
        this.myCachedCharset = null;
    }

    private Charset cacheCharset() {
        Charset result = CharsetToolkit.getDefaultSystemCharset();
        if (!StringUtil.isEmpty((String)this.myDefaultEncoding)) {
            try {
                result = Charset.forName(this.myDefaultEncoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return null;
        }
        return EncodingProjectManager.getInstance((Project)project).getDefaultCharsetForPropertiesFiles(virtualFile);
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, Charset charset) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project).setDefaultCharsetForPropertiesFiles(virtualFile, charset);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

