/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.OptionsDialog;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ReadOnlyStatusDialog
extends OptionsDialog {
    private JPanel myTopPanel;
    private JList myFileList;
    private JRadioButton myUsingFileSystemRadioButton;
    private JRadioButton myUsingVcsRadioButton;
    private FileInfo[] myFiles;

    public ReadOnlyStatusDialog(Project project, FileInfo[] files) {
        super(project);
        this.myFiles = files;
        this.$$$setupUI$$$();
        this.initFileList();
        if (this.myUsingVcsRadioButton.isEnabled()) {
            this.myUsingVcsRadioButton.setSelected(true);
        } else {
            this.myUsingFileSystemRadioButton.setSelected(true);
        }
        this.myFileList.setCellRenderer(new FileListRenderer());
        this.setTitle(VcsBundle.message((String)"dialog.title.clear.read.only.file.status", (Object[])new Object[0]));
        this.init();
    }

    public long getTypeAheadTimeoutMs() {
        return Registry.intValue((String)"actionSystem.typeAheadTimeBeforeDialog");
    }

    private void initFileList() {
        this.myFileList.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return ReadOnlyStatusDialog.this.myFiles.length;
            }

            @Override
            public Object getElementAt(int index) {
                return ReadOnlyStatusDialog.this.myFiles[index].getFile();
            }
        });
        boolean hasVcs = false;
        for (FileInfo info : this.myFiles) {
            if (!info.hasVersionControl()) continue;
            hasVcs = true;
            break;
        }
        this.myUsingVcsRadioButton.setEnabled(hasVcs);
    }

    protected boolean isToBeShown() {
        return ((ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject)).getState().SHOW_DIALOG;
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        if (onOk) {
            ((ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject)).getState().SHOW_DIALOG = value;
        }
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "vcs.readOnlyHandler.ReadOnlyStatusDialog";
    }

    protected void doOKAction() {
        for (FileInfo info : this.myFiles) {
            if (this.myUsingFileSystemRadioButton.isSelected()) {
                info.getHandleType().selectFirst();
                continue;
            }
            if (!info.hasVersionControl()) continue;
            info.getHandleType().select(info.getHandleType().get(1));
        }
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        Collections.addAll(files, this.myFiles);
        ReadonlyStatusHandlerImpl.processFiles(files);
        if (files.isEmpty()) {
            super.doOKAction();
        } else {
            this.myFiles = files.toArray(new FileInfo[files.size()]);
            this.initFileList();
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JRootPane pane = this.getRootPane();
        return pane != null ? pane.getDefaultButton() : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JList jList;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFileList = jList = new JList();
        jScrollPane.setViewportView(jList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myUsingFileSystemRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Using file system");
        jRadioButton2.setMnemonic('F');
        jRadioButton2.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUsingVcsRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Using version control integration");
        jRadioButton.setMnemonic('V');
        jRadioButton.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }
}

