/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.ui.SeparatorFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class CommitLegendPanel {
    private JLabel myModifiedShown;
    private JLabel myModifiedIncluded;
    private JLabel myNewShown;
    private JLabel myNewIncluded;
    private JLabel myDeletedIncluded;
    private JLabel myTotalShown;
    private JLabel myTotalIncluded;
    private JPanel myRootPanel;
    private JLabel myDeletedShown;
    private JPanel myModifiedPanel;
    private JLabel myModifiedLabel;
    private JPanel myNewPanel;
    private JLabel myNewLabel;
    private JPanel myDeletedPanel;
    private JLabel myDeletedLabel;
    private JPanel myHeadingPanel;
    private final InfoCalculator myInfoCalculator;

    public CommitLegendPanel(InfoCalculator infoCalculator) {
        this.myInfoCalculator = infoCalculator;
        this.$$$setupUI$$$();
        Color background = UIUtil.getListBackground();
        this.myModifiedPanel.setBackground(background);
        this.myNewPanel.setBackground(background);
        this.myDeletedPanel.setBackground(background);
        this.myModifiedLabel.setForeground(FileStatus.MODIFIED.getColor());
        this.myModifiedLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.myNewLabel.setForeground(FileStatus.ADDED.getColor());
        this.myNewLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.myDeletedLabel.setForeground(FileStatus.DELETED.getColor());
        this.myDeletedLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        CommitLegendPanel.boldLabel(this.myModifiedLabel, true);
        CommitLegendPanel.boldLabel(this.myNewLabel, true);
        CommitLegendPanel.boldLabel(this.myDeletedLabel, true);
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void update() {
        int deleted = this.myInfoCalculator.getDeleted();
        int modified = this.myInfoCalculator.getModified();
        int cntNew = this.myInfoCalculator.getNew();
        int includedDeleted = this.myInfoCalculator.getIncludedDeleted();
        int includedModified = this.myInfoCalculator.getIncludedModified();
        int includedNew = this.myInfoCalculator.getIncludedNew();
        CommitLegendPanel.updateCategory(this.myTotalShown, this.myTotalIncluded, deleted + modified + cntNew, includedDeleted + includedModified + includedNew);
        CommitLegendPanel.updateCategory(this.myModifiedShown, this.myModifiedIncluded, modified, includedModified);
        CommitLegendPanel.updateCategory(this.myNewShown, this.myNewIncluded, cntNew, includedNew);
        CommitLegendPanel.updateCategory(this.myDeletedShown, this.myDeletedIncluded, deleted, includedDeleted);
    }

    private void createUIComponents() {
        this.myHeadingPanel = (JPanel)SeparatorFactory.createSeparator((String)VcsBundle.message((String)"commit.legend.summary", (Object[])new Object[0]), null);
    }

    private static void updateCategory(JLabel totalLabel, JLabel includedLabel, int totalCnt, int includedCnt) {
        CommitLegendPanel.updateLabel(totalLabel, totalCnt, false);
        CommitLegendPanel.updateLabel(includedLabel, includedCnt, totalCnt != includedCnt);
    }

    private static void updateLabel(JLabel label, int count, boolean bold) {
        label.setText(String.valueOf(count));
        label.setEnabled(bold || count != 0);
        CommitLegendPanel.boldLabel(label, bold);
    }

    private static void boldLabel(JLabel label, boolean bold) {
        label.setFont(label.getFont().deriveFont(bold ? 1 : 0));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JLabel jLabel2;
        JPanel jPanel2;
        JLabel jLabel3;
        JPanel jPanel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JLabel jLabel8;
        JLabel jLabel9;
        JLabel jLabel10;
        JLabel jLabel11;
        JPanel jPanel4;
        this.createUIComponents();
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("messages/VcsBundle").getString("commit.legend.files"));
        jPanel4.add((Component)jLabel12, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("messages/VcsBundle").getString("commit.legend.shown"));
        jPanel4.add((Component)jLabel13, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("messages/VcsBundle").getString("commit.legend.included"));
        jPanel4.add((Component)jLabel14, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(6, 0, 1, 3, 0, 1, 0, 3, null, null, null));
        this.myModifiedShown = jLabel11 = new JLabel();
        jLabel11.setText("0");
        jPanel4.add((Component)jLabel11, new GridConstraints(3, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myModifiedIncluded = jLabel10 = new JLabel();
        jLabel10.setText("0");
        jPanel4.add((Component)jLabel10, new GridConstraints(3, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myNewShown = jLabel9 = new JLabel();
        jLabel9.setText("0");
        jPanel4.add((Component)jLabel9, new GridConstraints(4, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myNewIncluded = jLabel8 = new JLabel();
        jLabel8.setText("0");
        jPanel4.add((Component)jLabel8, new GridConstraints(4, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myDeletedShown = jLabel7 = new JLabel();
        jLabel7.setText("0");
        jPanel4.add((Component)jLabel7, new GridConstraints(5, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myDeletedIncluded = jLabel6 = new JLabel();
        jLabel6.setText("0");
        jPanel4.add((Component)jLabel6, new GridConstraints(5, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTotalShown = jLabel5 = new JLabel();
        jLabel5.setText("1");
        jPanel4.add((Component)jLabel5, new GridConstraints(7, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTotalIncluded = jLabel4 = new JLabel();
        jLabel4.setText("0");
        jPanel4.add((Component)jLabel4, new GridConstraints(7, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myModifiedPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.myModifiedLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/VcsBundle").getString("commit.legend.modified"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myNewPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.myNewLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/VcsBundle").getString("commit.legend.new"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myDeletedPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.myDeletedLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/VcsBundle").getString("commit.legend.deleted"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel4.add((Component)jSeparator2, new GridConstraints(2, 0, 1, 3, 0, 1, 0, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("messages/VcsBundle").getString("commit.legend.total"));
        jPanel5.add((Component)jLabel15, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JPanel jPanel6 = this.myHeadingPanel;
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static class ChangeInfoCalculator
    implements InfoCalculator {
        private List<Change> myDisplayedChanges = Collections.emptyList();
        private List<Change> myIncludedChanges = Collections.emptyList();
        private static final Filter<Change> MODIFIED_FILTER = new Filter<Change>(){

            @Override
            public boolean matches(Change item) {
                return item.getType() == Change.Type.MODIFICATION || item.getType() == Change.Type.MOVED;
            }
        };
        private static final Filter<Change> NEW_FILTER = new Filter<Change>(){

            @Override
            public boolean matches(Change item) {
                return item.getType() == Change.Type.NEW;
            }
        };
        private static final Filter<Change> DELETED_FILTER = new Filter<Change>(){

            @Override
            public boolean matches(Change item) {
                return item.getType() == Change.Type.DELETED;
            }
        };

        public void update(List<Change> displayedChanges, List<Change> includedChanges) {
            this.myDisplayedChanges = displayedChanges;
            this.myIncludedChanges = includedChanges;
        }

        @Override
        public int getNew() {
            return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, NEW_FILTER);
        }

        @Override
        public int getModified() {
            return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, MODIFIED_FILTER);
        }

        @Override
        public int getDeleted() {
            return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, DELETED_FILTER);
        }

        @Override
        public int getIncludedNew() {
            return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, NEW_FILTER);
        }

        @Override
        public int getIncludedModified() {
            return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, MODIFIED_FILTER);
        }

        @Override
        public int getIncludedDeleted() {
            return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, DELETED_FILTER);
        }

        private static <T> int countMatchingItems(List<T> items, Filter<T> filter) {
            int count = 0;
            for (T item : items) {
                if (!filter.matches(item)) continue;
                ++count;
            }
            return count;
        }
    }

    public static interface InfoCalculator {
        public int getNew();

        public int getModified();

        public int getDeleted();

        public int getIncludedNew();

        public int getIncludedModified();

        public int getIncludedDeleted();
    }

    private static interface Filter<T> {
        public boolean matches(T var1);
    }
}

