/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CompositeRepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.Nullable;

public class CompositeCommittedChangesProvider
implements CommittedChangesProvider<CommittedChangeList, CompositeChangeBrowserSettings> {
    private final Project myProject;
    private List<AbstractVcs> myBaseVcss = new ArrayList<AbstractVcs>();

    public CompositeCommittedChangesProvider(Project project, AbstractVcs ... baseVcss) {
        this.myProject = project;
        this.myBaseVcss = new ArrayList<AbstractVcs>();
        Collections.addAll(this.myBaseVcss, baseVcss);
    }

    public CompositeChangeBrowserSettings createDefaultSettings() {
        HashMap<AbstractVcs, ChangeBrowserSettings> map = new HashMap<AbstractVcs, ChangeBrowserSettings>();
        for (AbstractVcs vcs : this.myBaseVcss) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            assert (provider != null);
            map.put(vcs, provider.createDefaultSettings());
        }
        return new CompositeChangeBrowserSettings(map);
    }

    public ChangesBrowserSettingsEditor<CompositeChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new CompositeChangesBrowserSettingsEditor();
    }

    public CompositeRepositoryLocation getLocationFor(FilePath root) {
        CommittedChangesProvider committedChangesProvider;
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root);
        if (vcs != null && (committedChangesProvider = vcs.getCommittedChangesProvider()) != null) {
            return new CompositeRepositoryLocation(committedChangesProvider, CommittedChangesCache.getInstance(this.myProject).getLocationCache().getLocation(vcs, root, false));
        }
        return null;
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    public VcsCommittedListsZipper getZipper() {
        throw new UnsupportedOperationException();
    }

    public List<CommittedChangeList> getCommittedChanges(CompositeChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        throw new UnsupportedOperationException();
    }

    public void loadCommittedChanges(CompositeChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        throw new UnsupportedOperationException();
    }

    public ChangeListColumn[] getColumns() {
        LinkedHashSet<ChangeListColumn> columns = new LinkedHashSet<ChangeListColumn>();
        for (AbstractVcs vcs : this.myBaseVcss) {
            ChangeListColumn[] providerColumns;
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            assert (provider != null);
            for (ChangeListColumn col : providerColumns = provider.getColumns()) {
                if (col != ChangeListColumn.DATE && col != ChangeListColumn.DESCRIPTION && col != ChangeListColumn.NAME && !(col instanceof ChangeListColumn.ChangeListNumberColumn)) continue;
                columns.add(col);
            }
        }
        return columns.toArray(new ChangeListColumn[columns.size()]);
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        JTabbedPane tabbedPane = null;
        ArrayList actions = null;
        ArrayList toolbarActions = null;
        final ArrayList<Runnable> calledOnDispose = new ArrayList<Runnable>();
        for (AbstractVcs baseVcs : this.myBaseVcss) {
            VcsCommittedViewAuxiliary auxiliary;
            CommittedChangesProvider provider = baseVcs.getCommittedChangesProvider();
            if (provider == null || (auxiliary = provider.createActions(manager, location)) == null) continue;
            if (tabbedPane == null) {
                tabbedPane = new JTabbedPane();
                actions = new ArrayList();
                toolbarActions = new ArrayList();
            }
            actions.addAll(auxiliary.getPopupActions());
            toolbarActions.addAll(auxiliary.getToolbarActions());
            calledOnDispose.add(auxiliary.getCalledOnViewDispose());
        }
        if (tabbedPane != null) {
            JPanel panel = new JPanel();
            panel.add(tabbedPane);
            return new VcsCommittedViewAuxiliary(actions, new Runnable(){

                @Override
                public void run() {
                    for (Runnable runnable : calledOnDispose) {
                        runnable.run();
                    }
                }
            }, toolbarActions);
        }
        return null;
    }

    public int getUnlimitedCountValue() {
        throw new UnsupportedOperationException();
    }

    private class CompositeChangesBrowserSettingsEditor
    implements ChangesBrowserSettingsEditor<CompositeChangeBrowserSettings> {
        private final JPanel myCompositePanel;
        private final DateFilterComponent myDateFilter;
        private CompositeChangeBrowserSettings mySettings;
        private final Map<AbstractVcs, ChangesBrowserSettingsEditor> myEditors = new HashMap<AbstractVcs, ChangesBrowserSettingsEditor>();
        private final Map<AbstractVcs, JCheckBox> myEnabledCheckboxes = new HashMap<AbstractVcs, JCheckBox>();

        public CompositeChangesBrowserSettingsEditor() {
            this.myCompositePanel = new JPanel();
            this.myCompositePanel.setLayout(new BoxLayout(this.myCompositePanel, 1));
            this.myDateFilter = new DateFilterComponent();
            this.myCompositePanel.add(this.myDateFilter.getPanel());
            for (AbstractVcs vcs : CompositeCommittedChangesProvider.this.myBaseVcss) {
                CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
                assert (provider != null);
                final ChangesBrowserSettingsEditor editor = provider.createFilterUI(false);
                this.myEditors.put(vcs, editor);
                JPanel wrapperPane = new JPanel(new BorderLayout());
                wrapperPane.setBorder(BorderFactory.createTitledBorder(vcs.getDisplayName()));
                final JCheckBox checkBox = new JCheckBox(VcsBundle.message((String)"composite.change.provider.include.vcs.checkbox", (Object[])new Object[]{vcs.getDisplayName()}), true);
                checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CompositeChangesBrowserSettingsEditor.this.updateVcsEnabled(checkBox, editor);
                    }
                });
                wrapperPane.add((Component)checkBox, "North");
                this.myEnabledCheckboxes.put(vcs, checkBox);
                wrapperPane.add((Component)editor.getComponent(), "Center");
                this.myCompositePanel.add(wrapperPane);
            }
        }

        private void updateVcsEnabled(JCheckBox checkBox, ChangesBrowserSettingsEditor editor) {
            UIUtil.setEnabled((Component)editor.getComponent(), (boolean)checkBox.isSelected(), (boolean)true);
            if (checkBox.isSelected()) {
                editor.updateEnabledControls();
            }
        }

        public JComponent getComponent() {
            return this.myCompositePanel;
        }

        public CompositeChangeBrowserSettings getSettings() {
            HashSet<AbstractVcs> enabledVcss = new HashSet<AbstractVcs>();
            for (AbstractVcs vcs : this.myEditors.keySet()) {
                ChangeBrowserSettings settings = this.myEditors.get(vcs).getSettings();
                this.myDateFilter.saveValues(settings);
                this.mySettings.put(vcs, settings);
                if (!this.myEnabledCheckboxes.get(vcs).isSelected()) continue;
                enabledVcss.add(vcs);
            }
            this.mySettings.setEnabledVcss(enabledVcss);
            return this.mySettings;
        }

        public void setSettings(CompositeChangeBrowserSettings settings) {
            this.mySettings = settings;
            boolean dateFilterInitialized = false;
            for (AbstractVcs vcs : this.myEditors.keySet()) {
                ChangeBrowserSettings vcsSettings = this.mySettings.get(vcs);
                ChangesBrowserSettingsEditor editor = this.myEditors.get(vcs);
                editor.setSettings(vcsSettings);
                if (!dateFilterInitialized) {
                    this.myDateFilter.initValues(vcsSettings);
                    dateFilterInitialized = true;
                }
                JCheckBox checkBox = this.myEnabledCheckboxes.get(vcs);
                checkBox.setSelected(settings.getEnabledVcss().contains(vcs));
                this.updateVcsEnabled(checkBox, editor);
            }
        }

        @Nullable
        public String validateInput() {
            for (ChangesBrowserSettingsEditor editor : this.myEditors.values()) {
                String result = editor.validateInput();
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public void updateEnabledControls() {
            for (ChangesBrowserSettingsEditor editor : this.myEditors.values()) {
                editor.updateEnabledControls();
            }
        }

        public String getDimensionServiceKey() {
            StringBuilder result = new StringBuilder();
            result.append("Composite");
            for (AbstractVcs vcs : CompositeCommittedChangesProvider.this.myBaseVcss) {
                result.append(".").append(vcs.getDisplayName());
            }
            return result.toString();
        }
    }

    public static class CompositeChangeBrowserSettings
    extends ChangeBrowserSettings {
        private final Map<AbstractVcs, ChangeBrowserSettings> myMap;
        private final Set<AbstractVcs> myEnabledVcs = new HashSet<AbstractVcs>();

        public CompositeChangeBrowserSettings(Map<AbstractVcs, ChangeBrowserSettings> map) {
            this.myMap = map;
            this.myEnabledVcs.addAll(map.keySet());
        }

        public void put(AbstractVcs vcs, ChangeBrowserSettings settings) {
            this.myMap.put(vcs, settings);
        }

        public ChangeBrowserSettings get(AbstractVcs vcs) {
            return this.myMap.get(vcs);
        }

        public void setEnabledVcss(Collection<AbstractVcs> vcss) {
            this.myEnabledVcs.clear();
            this.myEnabledVcs.addAll(vcss);
        }

        public Collection<AbstractVcs> getEnabledVcss() {
            return this.myEnabledVcs;
        }
    }
}

