/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeRequestChain;
import java.awt.KeyboardFocusManager;
import java.awt.Window;

public class ShowNextChangeAction
extends AnAction
implements DumbAware {
    public ShowNextChangeAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        ChangeRequestChain chain = (ChangeRequestChain)e.getData(VcsDataKeys.DIFF_REQUEST_CHAIN);
        e.getPresentation().setEnabled(chain != null && chain.canMoveForward());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        ChangeRequestChain chain = (ChangeRequestChain)e.getData(VcsDataKeys.DIFF_REQUEST_CHAIN);
        if (project == null || chain == null || !chain.canMoveForward()) {
            return;
        }
        DiffViewer diffViewer = (DiffViewer)e.getData(PlatformDataKeys.DIFF_VIEWER);
        if (diffViewer == null) {
            return;
        }
        DiffRequest request = chain.moveForward();
        if (request != null) {
            if (diffViewer.getContentsNumber() == request.getContents().length) {
                diffViewer.setDiffRequest(request);
            } else {
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                window.setVisible(false);
                DiffManager.getInstance().getDiffTool().show(request);
            }
        }
    }
}

