/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VirtualFileHolder
implements FileHolder {
    private final Set<VirtualFile> myFiles = new HashSet<VirtualFile>();
    private final Project myProject;
    private final FileHolder.HolderType myType;
    private int myNumDirs;

    public VirtualFileHolder(Project project, FileHolder.HolderType type) {
        this.myProject = project;
        this.myType = type;
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myType;
    }

    @Override
    public void cleanAll() {
        this.myFiles.clear();
        this.myNumDirs = 0;
    }

    static int cleanScope(final Project project, final Collection<VirtualFile> files, final VcsDirtyScope scope) {
        return (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

            public Integer compute() {
                int result = 0;
                if (project.isDisposed() || files.isEmpty()) {
                    return 0;
                }
                ArrayList currentFiles = new ArrayList(files);
                if (scope.getRecursivelyDirtyDirectories().size() == 0) {
                    Set dirtyFiles = scope.getDirtyFiles();
                    boolean cleanedDroppedFiles = false;
                    for (FilePath dirtyFile : dirtyFiles) {
                        VirtualFile f = dirtyFile.getVirtualFile();
                        if (f != null) {
                            files.remove(f);
                            if (!f.isDirectory()) continue;
                            ++result;
                            continue;
                        }
                        if (cleanedDroppedFiles) continue;
                        cleanedDroppedFiles = true;
                        for (VirtualFile file : currentFiles) {
                            if (!VirtualFileHolder.fileDropped(project, file)) continue;
                            files.remove(file);
                            if (!file.isDirectory()) continue;
                            ++result;
                        }
                    }
                } else {
                    for (VirtualFile file : currentFiles) {
                        if (!VirtualFileHolder.fileDropped(project, file) && !scope.belongsTo((FilePath)new FilePathImpl(file))) continue;
                        files.remove(file);
                        if (!file.isDirectory()) continue;
                        ++result;
                    }
                }
                return result;
            }
        });
    }

    @Override
    public void cleanScope(VcsDirtyScope scope) {
        this.myNumDirs -= VirtualFileHolder.cleanScope(this.myProject, this.myFiles, scope);
    }

    private static boolean fileDropped(Project project, VirtualFile file) {
        return !file.isValid() || ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file) == null;
    }

    public void addFile(VirtualFile file) {
        this.myFiles.add(file);
        if (file.isDirectory()) {
            ++this.myNumDirs;
        }
    }

    public void removeFile(VirtualFile file) {
        this.myFiles.remove(file);
        if (file.isDirectory()) {
            --this.myNumDirs;
        }
    }

    public List<VirtualFile> getFiles() {
        return new ArrayList<VirtualFile>(this.myFiles);
    }

    @Override
    public VirtualFileHolder copy() {
        VirtualFileHolder copyHolder = new VirtualFileHolder(this.myProject, this.myType);
        copyHolder.myFiles.addAll(this.myFiles);
        copyHolder.myNumDirs = this.myNumDirs;
        return copyHolder;
    }

    public boolean containsFile(VirtualFile file) {
        return this.myFiles.contains(file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFileHolder that = (VirtualFileHolder)o;
        return ((Object)this.myFiles).equals(that.myFiles);
    }

    public int hashCode() {
        return ((Object)this.myFiles).hashCode();
    }

    public int getSize() {
        return this.myFiles.size();
    }

    public int getNumDirs() {
        return this.myNumDirs;
    }
}

