/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.lifecycle.ControlledAlarmFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesOnServerTracker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LazyRefreshingSelfQueue;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteRevisionsNumbersCache
implements ChangesOnServerTracker {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.RemoteRevisionsNumbersCache");
    private static final long ourRottenPeriod = 3600000L;
    private final Map<String, Pair<VcsRoot, VcsRevisionNumber>> myData;
    private final Map<VcsRoot, LazyRefreshingSelfQueue<String>> myRefreshingQueues;
    private final Map<String, VcsRevisionNumber> myLatestRevisionsMap;
    private final ProjectLevelVcsManager myVcsManager;
    private final LocalFileSystem myLfs;
    private boolean mySomethingChanged;
    private final Object myLock = new Object();
    public static final VcsRevisionNumber NOT_LOADED = new VcsRevisionNumber(){

        public String asString() {
            return "NOT_LOADED";
        }

        public int compareTo(VcsRevisionNumber o) {
            if (o == this) {
                return 0;
            }
            return -1;
        }
    };
    public static final VcsRevisionNumber UNKNOWN = new VcsRevisionNumber(){

        public String asString() {
            return "UNKNOWN";
        }

        public int compareTo(VcsRevisionNumber o) {
            if (o == this) {
                return 0;
            }
            return -1;
        }
    };
    private final VcsConfiguration myVcsConfiguration;

    RemoteRevisionsNumbersCache(Project project) {
        this.myData = new HashMap<String, Pair<VcsRoot, VcsRevisionNumber>>();
        this.myRefreshingQueues = Collections.synchronizedMap(new HashMap());
        this.myLatestRevisionsMap = new HashMap<String, VcsRevisionNumber>();
        this.myLfs = LocalFileSystem.getInstance();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStep(AtomicSectionsAware atomicSectionsAware) {
        HashMap<VcsRoot, LazyRefreshingSelfQueue<String>> copyMap;
        this.mySomethingChanged = false;
        Object object = this.myLock;
        synchronized (object) {
            copyMap = new HashMap<VcsRoot, LazyRefreshingSelfQueue<String>>(this.myRefreshingQueues);
        }
        Iterator<Map.Entry<VcsRoot, LazyRefreshingSelfQueue<String>>> iterator = copyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VcsRoot, LazyRefreshingSelfQueue<String>> entry = iterator.next();
            VcsRoot key = entry.getKey();
            boolean backgroundOperationsAllowed = key.vcs.isVcsBackgroundOperationsAllowed(key.path);
            LOG.debug("backgroundOperationsAllowed: " + backgroundOperationsAllowed + " for " + key.vcs.getName() + ", " + key.path.getPath());
            if (backgroundOperationsAllowed) continue;
            iterator.remove();
        }
        LOG.debug("queues refresh started, queues: " + copyMap.size());
        ProgressIndicator pi = ControlledAlarmFactory.createProgressIndicator(atomicSectionsAware);
        for (LazyRefreshingSelfQueue<String> queue : copyMap.values()) {
            atomicSectionsAware.checkShouldExit();
            queue.updateStep(pi);
        }
        return this.mySomethingChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directoryMappingChanged() {
        Object object = this.myLock;
        synchronized (object) {
            HashSet<String> keys = new HashSet<String>(this.myData.keySet());
            for (String key : keys) {
                AbstractVcs newVcs;
                Pair<VcsRoot, VcsRevisionNumber> value = this.myData.get(key);
                VcsRoot storedVcsRoot = (VcsRoot)value.getFirst();
                VirtualFile vf = this.myLfs.refreshAndFindFileByIoFile(new File(key));
                AbstractVcs abstractVcs = newVcs = vf == null ? null : this.myVcsManager.getVcsFor(vf);
                if (newVcs == null) {
                    this.myData.remove(key);
                    this.getQueue(storedVcsRoot).forceRemove(key);
                    continue;
                }
                VirtualFile newRoot = this.myVcsManager.getVcsRootFor(vf);
                VcsRoot newVcsRoot = new VcsRoot(newVcs, newRoot);
                if (storedVcsRoot.equals((Object)newVcsRoot)) continue;
                this.switchVcs(storedVcsRoot, newVcsRoot, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchVcs(VcsRoot oldVcsRoot, VcsRoot newVcsRoot, String key) {
        Object object = this.myLock;
        synchronized (object) {
            LazyRefreshingSelfQueue<String> oldQueue = this.getQueue(oldVcsRoot);
            LazyRefreshingSelfQueue<String> newQueue = this.getQueue(newVcsRoot);
            this.myData.put(key, (Pair<VcsRoot, VcsRevisionNumber>)new Pair((Object)newVcsRoot, (Object)NOT_LOADED));
            oldQueue.forceRemove(key);
            newQueue.addRequest(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void plus(Pair<String, AbstractVcs> pair) {
        if (((AbstractVcs)pair.getSecond()).getDiffProvider() == null) {
            return;
        }
        String key = (String)pair.getFirst();
        AbstractVcs newVcs = (AbstractVcs)pair.getSecond();
        VirtualFile root = this.getRootForPath(key);
        if (root == null) {
            return;
        }
        VcsRoot vcsRoot = new VcsRoot(newVcs, root);
        Object object = this.myLock;
        synchronized (object) {
            Pair<VcsRoot, VcsRevisionNumber> value = this.myData.get(key);
            if (value == null) {
                LazyRefreshingSelfQueue<String> queue = this.getQueue(vcsRoot);
                this.myData.put(key, (Pair<VcsRoot, VcsRevisionNumber>)new Pair((Object)vcsRoot, (Object)NOT_LOADED));
                queue.addRequest(key);
            } else if (!((VcsRoot)value.getFirst()).equals((Object)vcsRoot)) {
                this.switchVcs((VcsRoot)value.getFirst(), vcsRoot, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Collection<String> paths) {
        Object object = this.myLock;
        synchronized (object) {
            for (String path : paths) {
                Pair<VcsRoot, VcsRevisionNumber> pair = this.myData.remove(path);
                if (pair == null) continue;
                VcsRoot vcsRoot = (VcsRoot)pair.getFirst();
                LazyRefreshingSelfQueue<String> queue = this.getQueue(vcsRoot);
                queue.forceRemove(path);
                queue.addRequest(path);
                this.myData.put(path, (Pair<VcsRoot, VcsRevisionNumber>)new Pair((Object)vcsRoot, (Object)NOT_LOADED));
            }
        }
    }

    @Nullable
    private VirtualFile getRootForPath(String s) {
        return this.myVcsManager.getVcsRootFor((FilePath)new FilePathImpl(new File(s), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void minus(Pair<String, AbstractVcs> pair) {
        LazyRefreshingSelfQueue<String> queue;
        if (((AbstractVcs)pair.getSecond()).getDiffProvider() == null) {
            return;
        }
        VirtualFile root = this.getRootForPath((String)pair.getFirst());
        if (root == null) {
            return;
        }
        String key = (String)pair.getFirst();
        Object object = this.myLock;
        synchronized (object) {
            queue = this.getQueue(new VcsRoot((AbstractVcs)pair.getSecond(), root));
            this.myData.remove(key);
        }
        queue.forceRemove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private LazyRefreshingSelfQueue<String> getQueue(VcsRoot vcsRoot) {
        LazyRefreshingSelfQueue<String> lazyRefreshingSelfQueue;
        LazyRefreshingSelfQueue<String> lazyRefreshingSelfQueue2;
        Object object = this.myLock;
        synchronized (object) {
            LazyRefreshingSelfQueue<String> queue = this.myRefreshingQueues.get(vcsRoot);
            if (queue != null) {
                LazyRefreshingSelfQueue<String> lazyRefreshingSelfQueue3 = queue;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                lazyRefreshingSelfQueue2 = lazyRefreshingSelfQueue3;
                if (lazyRefreshingSelfQueue3 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/RemoteRevisionsNumbersCache.getQueue must not return null");
                return lazyRefreshingSelfQueue2;
            }
            queue = new LazyRefreshingSelfQueue<String>(new Getter<Long>(){

                public Long get() {
                    return ((RemoteRevisionsNumbersCache)RemoteRevisionsNumbersCache.this).myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL > 0 ? (long)(((RemoteRevisionsNumbersCache)RemoteRevisionsNumbersCache.this).myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL * 60000) : 3600000L;
                }
            }, new MyShouldUpdateChecker(vcsRoot), new MyUpdater(vcsRoot));
            this.myRefreshingQueues.put(vcsRoot, queue);
            lazyRefreshingSelfQueue = queue;
        }
        lazyRefreshingSelfQueue2 = lazyRefreshingSelfQueue;
        if (lazyRefreshingSelfQueue != null) return lazyRefreshingSelfQueue2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/RemoteRevisionsNumbersCache.getQueue must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcsRevisionNumber getNumber(String path) {
        Object object = this.myLock;
        synchronized (object) {
            Pair<VcsRoot, VcsRevisionNumber> pair = this.myData.get(path);
            return pair == null ? NOT_LOADED : (VcsRevisionNumber)pair.getSecond();
        }
    }

    @Override
    public boolean isUpToDate(Change change) {
        if (change.getBeforeRevision() != null && change.getAfterRevision() != null && !change.isMoved() && !change.isRenamed()) {
            return this.getRevisionState(change.getBeforeRevision());
        }
        return this.getRevisionState(change.getBeforeRevision()) && this.getRevisionState(change.getAfterRevision());
    }

    private boolean getRevisionState(ContentRevision revision) {
        if (revision != null) {
            VcsRevisionNumber local = revision.getRevisionNumber();
            String path = revision.getFile().getIOFile().getAbsolutePath();
            VcsRevisionNumber remote = this.getNumber(path);
            if (NOT_LOADED == remote || UNKNOWN == remote) {
                return true;
            }
            return local.compareTo((Object)remote) == 0;
        }
        return true;
    }

    private class MyShouldUpdateChecker
    implements Computable<Boolean> {
        private final VcsRoot myVcsRoot;

        public MyShouldUpdateChecker(VcsRoot vcsRoot) {
            this.myVcsRoot = vcsRoot;
        }

        public Boolean compute() {
            AbstractVcs vcs = this.myVcsRoot.vcs;
            String vcsName = vcs.getName();
            LOG.debug("should update for: " + vcsName + " root: " + this.myVcsRoot.path.getPath());
            VcsRevisionNumber latestNew = vcs.getDiffProvider().getLatestCommittedRevision(this.myVcsRoot.path);
            VcsRevisionNumber latestKnown = (VcsRevisionNumber)RemoteRevisionsNumbersCache.this.myLatestRevisionsMap.get(vcsName);
            if (latestNew == null) {
                return true;
            }
            if (latestKnown == null || latestNew.compareTo((Object)latestKnown) != 0) {
                RemoteRevisionsNumbersCache.this.myLatestRevisionsMap.put(vcsName, latestNew);
                return true;
            }
            return false;
        }
    }

    private class MyUpdater
    implements Consumer<String> {
        private final VcsRoot myVcsRoot;

        public MyUpdater(VcsRoot vcsRoot) {
            this.myVcsRoot = vcsRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(String s) {
            Pair oldPair;
            LOG.debug("update for: " + s);
            VirtualFile vf = RemoteRevisionsNumbersCache.this.myLfs.refreshAndFindFileByIoFile(new File(s));
            DiffProvider diffProvider = this.myVcsRoot.vcs.getDiffProvider();
            ItemLatestState state = vf == null ? diffProvider.getLastRevision((FilePath)FilePathImpl.createForDeletedFile(new File(s), false)) : diffProvider.getLastRevision(vf);
            VcsRevisionNumber newNumber = state == null || state.isDefaultHead() ? UNKNOWN : state.getNumber();
            Object object = RemoteRevisionsNumbersCache.this.myLock;
            synchronized (object) {
                oldPair = (Pair)RemoteRevisionsNumbersCache.this.myData.get(s);
                RemoteRevisionsNumbersCache.this.myData.put(s, new Pair((Object)this.myVcsRoot, (Object)newNumber));
            }
            if (oldPair == null || oldPair != null && ((VcsRevisionNumber)oldPair.getSecond()).compareTo((Object)newNumber) != 0) {
                LOG.debug("refresh triggered by " + s);
                RemoteRevisionsNumbersCache.this.mySomethingChanged = true;
            }
        }
    }
}

