/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommonCheckinAction
extends AbstractVcsAction {
    @Override
    public void actionPerformed(final VcsContext context) {
        final Project project = context.getProject();
        if (project == null) {
            return;
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
            return;
        }
        final FilePath[] roots = AbstractCommonCheckinAction.filterDescindingFiles(this.getRoots(context), project);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().saveAll();
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        changeListManager.invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                LocalChangeList initialSelection = AbstractCommonCheckinAction.this.getInitiallySelectedChangeList(context, project);
                Change[] changes = context.getSelectedChanges();
                if (changes != null && changes.length > 0) {
                    ArrayList<Change> changeCollection = new ArrayList<Change>();
                    Collections.addAll(changeCollection, changes);
                    CommitChangeListDialog.commitChanges(project, changeCollection, initialSelection, AbstractCommonCheckinAction.this.getExecutor(project), null);
                } else {
                    CommitChangeListDialog.commitPaths(project, Arrays.asList(roots), initialSelection, AbstractCommonCheckinAction.this.getExecutor(project), null);
                }
            }
        }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), ModalityState.current());
    }

    @Nullable
    protected CommitExecutor getExecutor(Project project) {
        return null;
    }

    @Nullable
    protected LocalChangeList getInitiallySelectedChangeList(VcsContext context, Project project) {
        Change[] selectedChanges;
        ChangeList[] selectedChangeLists = context.getSelectedChangeLists();
        LocalChangeList initialSelection = selectedChangeLists != null && selectedChangeLists.length > 0 ? ChangeListManager.getInstance((Project)project).findChangeList(selectedChangeLists[0].getName()) : ((selectedChanges = context.getSelectedChanges()) != null && selectedChanges.length > 0 ? ChangeListManager.getInstance((Project)project).getChangeList(selectedChanges[0]) : ChangeListManager.getInstance((Project)project).getDefaultChangeList());
        return initialSelection;
    }

    @Nullable
    protected static AbstractVcs getCommonVcsFor(FilePath[] roots, Project project) {
        if (roots.length == 0) {
            return null;
        }
        AbstractVcs firstVcs = VcsUtil.getVcsFor((Project)project, (FilePath)roots[0]);
        if (firstVcs == null) {
            return null;
        }
        for (FilePath file : roots) {
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file);
            if (vcs == null) {
                return null;
            }
            if (firstVcs == vcs) continue;
            return null;
        }
        return firstVcs;
    }

    protected abstract String getActionName(VcsContext var1);

    protected abstract FilePath[] getRoots(VcsContext var1);

    protected abstract boolean approximatelyHasRoots(VcsContext var1);

    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        Project project = vcsContext.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        if (plVcsManager.getAllActiveVcss().length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        if (!this.approximatelyHasRoots(vcsContext)) {
            presentation.setEnabled(false);
            return;
        }
        String actionName = this.getActionName(vcsContext) + "...";
        presentation.setText(actionName);
        presentation.setEnabled(!plVcsManager.isBackgroundVcsOperationRunning());
        presentation.setVisible(true);
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    protected abstract boolean filterRootsBeforeAction();

    protected static FilePath[] getAllContentRoots(VcsContext context) {
        VirtualFile[] roots;
        Project project = context.getProject();
        ArrayList<FilePathImpl> virtualFiles = new ArrayList<FilePathImpl>();
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile root : roots = manager.getAllVersionedRoots()) {
            virtualFiles.add(new FilePathImpl(root));
        }
        return virtualFiles.toArray(new FilePath[virtualFiles.size()]);
    }
}

