/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureConfigurableContext
implements Disposable,
LibraryEditorListener {
    private final ProjectStructureDaemonAnalyzer myDaemonAnalyzer;
    public final ModulesConfigurator myModulesConfigurator;
    public final Map<String, LibrariesModifiableModel> myLevel2Providers = new THashMap();
    private List<LibraryEditorListener> myLibraryEditorListeners = new ArrayList<LibraryEditorListener>();
    private final Project myProject;

    public StructureConfigurableContext(Project project, ModulesConfigurator modulesConfigurator) {
        this.myProject = project;
        this.myModulesConfigurator = modulesConfigurator;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDaemonAnalyzer = new ProjectStructureDaemonAnalyzer(this);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ProjectStructureDaemonAnalyzer getDaemonAnalyzer() {
        return this.myDaemonAnalyzer;
    }

    public void dispose() {
    }

    public ModulesConfigurator getModulesConfigurator() {
        return this.myModulesConfigurator;
    }

    public Module[] getModules() {
        return this.myModulesConfigurator.getModules();
    }

    public String getRealName(Module module) {
        ModifiableModuleModel moduleModel = this.myModulesConfigurator.getModuleModel();
        String newName = moduleModel.getNewName(module);
        return newName != null ? newName : module.getName();
    }

    public void resetLibraries() {
        LibraryTablesRegistrar tablesRegistrar = LibraryTablesRegistrar.getInstance();
        this.myLevel2Providers.clear();
        this.myLevel2Providers.put("application", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(), this.myProject, this));
        this.myLevel2Providers.put("project", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(this.myProject), this.myProject, this));
        for (LibraryTable table : tablesRegistrar.getCustomLibraryTables()) {
            this.myLevel2Providers.put(table.getTableLevel(), new LibrariesModifiableModel(table, this.myProject, this));
        }
    }

    public void addLibraryEditorListener(LibraryEditorListener listener) {
        this.myLibraryEditorListeners.add(listener);
    }

    public void removeLibraryEditorListener(LibraryEditorListener listener) {
        this.myLibraryEditorListeners.remove(listener);
    }

    @Override
    public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext.libraryRenamed must not be null");
        }
        for (LibraryEditorListener listener : this.myLibraryEditorListeners) {
            listener.libraryRenamed(library, oldName, newName);
        }
    }

    public LibraryTableModifiableModelProvider getGlobalLibrariesProvider(boolean tableEditable) {
        return this.createModifiableModelProvider("application", tableEditable);
    }

    public LibraryTableModifiableModelProvider createModifiableModelProvider(final String level, final boolean isTableEditable) {
        final LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, this.myProject);
        return new LibraryTableModifiableModelProvider(){

            @Override
            public LibraryTable.ModifiableModel getModifiableModel() {
                return StructureConfigurableContext.this.myLevel2Providers.get(level);
            }

            @Override
            public String getTableLevel() {
                return table.getTableLevel();
            }

            @Override
            public LibraryTablePresentation getLibraryTablePresentation() {
                return table.getPresentation();
            }

            @Override
            public boolean isLibraryTableEditable() {
                return isTableEditable && table.isEditable();
            }
        };
    }

    public LibraryTableModifiableModelProvider getProjectLibrariesProvider(boolean tableEditable) {
        return this.createModifiableModelProvider("project", tableEditable);
    }

    public List<LibraryTableModifiableModelProvider> getCustomLibrariesProviders(final boolean tableEditable) {
        return ContainerUtil.map2List((Collection)LibraryTablesRegistrar.getInstance().getCustomLibraryTables(), (Function)new NotNullFunction<LibraryTable, LibraryTableModifiableModelProvider>(){

            @NotNull
            public LibraryTableModifiableModelProvider fun(LibraryTable libraryTable) {
                LibraryTableModifiableModelProvider libraryTableModifiableModelProvider = StructureConfigurableContext.this.createModifiableModelProvider(libraryTable.getTableLevel(), tableEditable);
                if (libraryTableModifiableModelProvider == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext$2.fun must not return null");
                }
                return libraryTableModifiableModelProvider;
            }
        });
    }

    @Nullable
    public Library getLibrary(String libraryName, String libraryLevel) {
        LibrariesModifiableModel model = this.myLevel2Providers.get(libraryLevel);
        return model == null ? null : StructureConfigurableContext.findLibraryModel(libraryName, model);
    }

    @Nullable
    private static Library findLibraryModel(@NotNull String libraryName, @NotNull LibrariesModifiableModel model) {
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext.findLibraryModel must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext.findLibraryModel must not be null");
        }
        for (Library library : model.getLibraries()) {
            Library libraryModel = StructureConfigurableContext.findLibraryModel(library, model);
            if (libraryModel == null || !libraryName.equals(libraryModel.getName())) continue;
            return libraryModel;
        }
        return null;
    }

    @Nullable
    public Library getLibraryModel(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext.getLibraryModel must not be null");
        }
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            return StructureConfigurableContext.findLibraryModel(library, this.myLevel2Providers.get(libraryTable.getTableLevel()));
        }
        return library;
    }

    @Nullable
    private static Library findLibraryModel(Library library, LibrariesModifiableModel tableModel) {
        if (tableModel == null) {
            return library;
        }
        if (tableModel.wasLibraryRemoved(library)) {
            return null;
        }
        return tableModel.hasLibraryEditor(library) ? (Library)tableModel.getLibraryEditor(library).getModel() : library;
    }

    public void reset() {
        this.resetLibraries();
        this.myModulesConfigurator.resetModuleEditors();
        this.myDaemonAnalyzer.reset();
    }

    public void clear() {
        this.myLevel2Providers.clear();
    }
}

