/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import org.jetbrains.annotations.Nullable;

public class NewModuleAction
extends AnAction
implements DumbAware {
    public NewModuleAction() {
        super(ProjectBundle.message((String)"module.new.action", (Object[])new Object[0]), ProjectBundle.message((String)"module.new.action.description", (Object[])new Object[0]), null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = NewModuleAction.getProject(e);
        if (project == null) {
            return;
        }
        Object dataFromContext = this.prepareDataFromContext(e);
        AddModuleWizard wizard = new AddModuleWizard(project, new DefaultModulesProvider(project), null);
        wizard.show();
        if (wizard.isOK()) {
            ProjectBuilder builder = wizard.getProjectBuilder();
            if (builder instanceof ModuleBuilder) {
                ModuleBuilder moduleBuilder = (ModuleBuilder)builder;
                if (moduleBuilder.getName() == null) {
                    moduleBuilder.setName(wizard.getProjectName());
                }
                if (moduleBuilder.getModuleFilePath() == null) {
                    moduleBuilder.setModuleFilePath(wizard.getModuleFilePath());
                }
            }
            if (!builder.validate(project, project)) {
                return;
            }
            if (builder instanceof ModuleBuilder) {
                Module module = ((ModuleBuilder)builder).commitModule(project, null);
                if (module != null) {
                    this.processCreatedModule(module, dataFromContext);
                }
            } else {
                builder.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
                if (builder.isOpenProjectSettingsAfter()) {
                    ModulesConfigurator.showDialog(project, null, null, true);
                }
            }
        }
    }

    @Nullable
    protected Object prepareDataFromContext(AnActionEvent e) {
        return null;
    }

    protected void processCreatedModule(Module module, Object dataFromContext) {
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(NewModuleAction.getProject(e) != null);
    }

    @Nullable
    private static Project getProject(AnActionEvent e) {
        return (Project)e.getData(PlatformDataKeys.PROJECT);
    }
}

