/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeleteProvider
implements DeleteProvider {
    public boolean canDeleteElement(DataContext dataContext) {
        return LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext) != null;
    }

    public void deleteElement(DataContext dataContext) {
        final Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        assert (modules != null);
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        String names = StringUtil.join(Arrays.asList(modules), (Function)new Function<Module, String>(){

            public String fun(Module module) {
                return "'" + module.getName() + "'";
            }
        }, (String)", ");
        int ret = Messages.showOkCancelDialog((String)ProjectBundle.message((String)"module.remove.confirmation.prompt", (Object[])new Object[]{names, modules.length}), (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                        Module[] currentModules = moduleManager.getModules();
                        ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
                        HashMap<Module, ModifiableRootModel> otherModuleRootModels = new HashMap<Module, ModifiableRootModel>();
                        for (Module module : modules) {
                            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                            for (Module otherModule : currentModules) {
                                if (otherModule == module || ArrayUtil.find((Object[])modules, (Object)otherModule) != -1 || otherModuleRootModels.containsKey(otherModule)) continue;
                                otherModuleRootModels.put(otherModule, ModuleRootManager.getInstance((Module)otherModule).getModifiableModel());
                            }
                            ModuleDeleteProvider.removeModule(module, modifiableModel, otherModuleRootModels.values(), modifiableModuleModel);
                        }
                        ModifiableRootModel[] modifiableRootModels = otherModuleRootModels.values().toArray(new ModifiableRootModel[otherModuleRootModels.size()]);
                        ProjectRootManager.getInstance((Project)project).multiCommit(modifiableModuleModel, modifiableRootModels);
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, ProjectBundle.message((String)"module.remove.command", (Object[])new Object[0]), null);
    }

    public static void removeModule(@NotNull Module moduleToRemove, @Nullable ModifiableRootModel modifiableRootModelToRemove, @NotNull Collection<ModifiableRootModel> otherModuleRootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (moduleToRemove == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider.removeModule must not be null");
        }
        if (otherModuleRootModels == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider.removeModule must not be null");
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider.removeModule must not be null");
        }
        for (ModifiableRootModel modifiableRootModel : otherModuleRootModels) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = modifiableRootModel.getOrderEntries()) {
                Module orderEntryModule;
                if (!(orderEntry instanceof ModuleOrderEntry) || !orderEntry.isValid() || (orderEntryModule = ((ModuleOrderEntry)orderEntry).getModule()) == null || !orderEntryModule.equals(moduleToRemove)) continue;
                modifiableRootModel.removeOrderEntry(orderEntry);
            }
        }
        if (modifiableRootModelToRemove != null) {
            modifiableRootModelToRemove.dispose();
        }
        moduleModel.disposeModule(moduleToRemove);
    }
}

