/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.JavaUtilForVfs;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DetectedSourceRootsDialog;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class PathUIUtils {
    private PathUIUtils() {
    }

    public static VirtualFile[] scanAndSelectDetectedJavaSourceRoots(Object parent, final VirtualFile[] rootCandidates) {
        final HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        final LinkedHashMap<VirtualFile, List<VirtualFile>> detectedRootsMap = new LinkedHashMap<VirtualFile, List<VirtualFile>>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile candidate : rootCandidates) {
                    List<VirtualFile> detectedRoots = JavaUtilForVfs.suggestRoots(candidate);
                    if (!(detectedRoots.isEmpty() || detectedRoots.size() <= 1 && detectedRoots.get(0) == candidate)) {
                        detectedRootsMap.put(candidate, detectedRoots);
                        continue;
                    }
                    result.add(candidate);
                }
            }
        }, "Scanning for source roots", true, null);
        if (!detectedRootsMap.isEmpty()) {
            DetectedSourceRootsDialog dlg = parent instanceof Component ? new DetectedSourceRootsDialog((Component)parent, detectedRootsMap) : new DetectedSourceRootsDialog((Project)parent, detectedRootsMap);
            dlg.show();
            if (dlg.isOK()) {
                result.addAll(dlg.getChosenRoots());
            } else {
                result.clear();
            }
        }
        return VfsUtil.toVirtualFileArray(result);
    }
}

