/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.JavaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.JavaContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SwingWorker;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class JavaContentEntriesEditor
extends CommonContentEntriesEditor {
    public JavaContentEntriesEditor(String moduleName, ModuleConfigurationState state) {
        super(moduleName, state, true, true);
    }

    @Override
    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        return new JavaContentEntryEditor(contentEntryUrl){

            @Override
            protected ModifiableRootModel getModel() {
                return JavaContentEntriesEditor.this.getModel();
            }
        };
    }

    @Override
    protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project) {
        return new ContentEntryTreeEditor(project, true, true);
    }

    @Override
    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        List<ContentEntry> contentEntries = super.addContentEntries(files);
        if (!contentEntries.isEmpty()) {
            final ContentEntry[] contentEntriesArray = contentEntries.toArray(new ContentEntry[contentEntries.size()]);
            JavaContentEntriesEditor.addSourceRoots(this.myProject, contentEntriesArray, new Runnable(){

                @Override
                public void run() {
                    JavaContentEntriesEditor.this.addContentEntryPanels(contentEntriesArray);
                }
            });
        }
        return contentEntries;
    }

    private static void addSourceRoots(Project project, final ContentEntry[] contentEntries, final Runnable finishRunnable) {
        final HashMap<ContentEntry, Object> entryToRootMap = new HashMap<ContentEntry, Object>();
        final HashMap<File, ContentEntry> fileToEntryMap = new HashMap<File, ContentEntry>();
        for (ContentEntry contentEntry : contentEntries) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            entryToRootMap.put(contentEntry, null);
            fileToEntryMap.put(VfsUtil.virtualToIoFile((VirtualFile)file), contentEntry);
        }
        final ProgressWindow progressWindow = new ProgressWindow(true, project);
        final SmoothProgressAdapter progressIndicator = new SmoothProgressAdapter(progressWindow, project);
        final Runnable searchRunnable = new Runnable(){

            @Override
            public void run() {
                Runnable process = new Runnable(){

                    @Override
                    public void run() {
                        for (File file : fileToEntryMap.keySet()) {
                            progressIndicator.setText(ProjectBundle.message((String)"module.paths.searching.source.roots.progress", (Object[])new Object[]{file.getPath()}));
                            List<Pair<File, String>> roots = JavaUtil.suggestRoots(file);
                            entryToRootMap.put(fileToEntryMap.get(file), roots);
                        }
                    }
                };
                progressWindow.setTitle(ProjectBundle.message((String)"module.paths.searching.source.roots.title", (Object[])new Object[0]));
                ProgressManager.getInstance().runProcess(process, progressIndicator);
            }
        };
        final Runnable addSourcesRunnable = new Runnable(){

            @Override
            public void run() {
                for (ContentEntry contentEntry : contentEntries) {
                    List suggestedRoots = (List)entryToRootMap.get(contentEntry);
                    if (suggestedRoots == null) continue;
                    for (Pair suggestedRoot : suggestedRoots) {
                        VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByIoFile((File)suggestedRoot.first);
                        VirtualFile fileContent = contentEntry.getFile();
                        if (sourceRoot == null || fileContent == null || !VfsUtil.isAncestor((VirtualFile)fileContent, (VirtualFile)sourceRoot, (boolean)false)) continue;
                        contentEntry.addSourceFolder(sourceRoot, false, (String)suggestedRoot.getSecond());
                    }
                }
                if (finishRunnable != null) {
                    finishRunnable.run();
                }
            }
        };
        new SwingWorker(){

            public Object construct() {
                searchRunnable.run();
                return null;
            }

            public void finished() {
                addSourcesRunnable.run();
            }
        }.start();
    }

    @Override
    protected JPanel createBottomControl(Module module) {
        JPanel innerPanel = new JPanel(new GridBagLayout());
        innerPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 6));
        return innerPanel;
    }
}

