/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ActionsHeaderComponent
extends JPanel {
    private static final int HEADER_Y_OFFSET = 4;
    private JLabel myHeaderLabel;

    @Override
    public void addNotify() {
        super.addNotify();
        Dimension preferredSize = new Dimension(0, 0);
        this.calcPreferredSize(this, preferredSize);
        preferredSize.height += 4;
        this.setPreferredSize(preferredSize);
    }

    public void setHeaderTextColor(Color color) {
        this.myHeaderLabel.setForeground(color);
    }

    private void calcPreferredSize(Container container, Dimension dimension) {
        Component[] components = container.getComponents();
        int maxWidth = 0;
        int maxHeight = 0;
        for (Component component : components) {
            if (component instanceof Container) {
                this.calcPreferredSize((Container)component, dimension);
                maxWidth = Math.max(maxWidth, dimension.width);
                maxHeight = Math.max(maxHeight, dimension.height);
                continue;
            }
            Dimension preferredSize = component.getPreferredSize();
            maxWidth = Math.max(maxWidth, preferredSize.width);
            maxHeight = Math.max(maxHeight, preferredSize.height);
        }
        Dimension preferredSize = container.getPreferredSize();
        dimension.width = Math.max(maxWidth, preferredSize.width);
        dimension.height = Math.max(maxHeight, preferredSize.height);
    }

    public final void setSelected(boolean isSelected) {
        this.setBackground(isSelected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground());
        this.myHeaderLabel.setForeground(isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground());
        this.revalidate();
        this.repaint();
    }
}

