/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.impl.storage.FileSet;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathStorage
implements StateStorage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.storage.ClasspathStorage");
    @NonNls
    public static final String DEFAULT_STORAGE = "default";
    @NonNls
    public static final String SPECIAL_STORAGE = "special";
    public static final String DEFAULT_STORAGE_DESCR = ProjectBundle.message((String)"project.roots.classpath.format.default.descr", (Object[])new Object[0]);
    @NonNls
    public static final String CLASSPATH_OPTION = "classpath";
    @NonNls
    public static final String CLASSPATH_DIR_OPTION = "classpath-dir";
    @NonNls
    private static final String COMPONENT_TAG = "component";
    private Object mySession;
    private final ClasspathStorageProvider.ClasspathConverter myConverter;

    public ClasspathStorage(Module module) {
        this.myConverter = ClasspathStorage.getProvider(ClasspathStorage.getStorageType(module)).createConverter(module);
        MessageBus messageBus = module.getMessageBus();
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)module.getPicoContainer().getComponentInstanceOfType(VirtualFileTracker.class);
        if (virtualFileTracker != null && messageBus != null) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            try {
                this.myConverter.getFileSet().listFiles(files);
                for (VirtualFile file : files) {
                    final StateStorage.Listener listener = (StateStorage.Listener)messageBus.syncPublisher(STORAGE_TOPIC);
                    virtualFileTracker.addTracker(file.getUrl(), (VirtualFileListener)new VirtualFileAdapter(){

                        public void contentsChanged(VirtualFileEvent event) {
                            listener.storageFileChanged(event, (StateStorage)ClasspathStorage.this);
                        }
                    }, true, (Disposable)module);
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
    }

    private FileSet getFileSet() {
        return this.myConverter.getFileSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getState(Object component, String componentName, Class<T> stateClass, @Nullable T mergeInto) throws StateStorage.StateStorageException {
        assert (component instanceof ModuleRootManager);
        assert (componentName.equals("NewModuleRootManager"));
        assert (stateClass == ModuleRootManagerImpl.ModuleRootManagerState.class);
        try {
            Set<String> macros;
            Module module = ((ModuleRootManagerImpl)((Object)component)).getModule();
            Element element = new Element(COMPONENT_TAG);
            ModifiableRootModel model = null;
            try {
                model = ((ModuleRootManagerImpl)((Object)component)).getModifiableModel();
                macros = this.myConverter.getClasspath(model, element);
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
            boolean macrosOk = ProjectMacrosUtil.checkMacros(module.getProject(), macros);
            PathMacroManager.getInstance((ComponentManager)module).expandPaths(element);
            ModuleRootManagerImpl.ModuleRootManagerState moduleRootManagerState = new ModuleRootManagerImpl.ModuleRootManagerState();
            moduleRootManagerState.readExternal(element);
            if (!macrosOk) {
                throw new StateStorage.StateStorageException(ProjectBundle.message((String)"project.load.undefined.path.variables.error", (Object[])new Object[0]));
            }
            return (T)moduleRootManagerState;
        }
        catch (InvalidDataException e) {
            throw new StateStorage.StateStorageException(e.getMessage());
        }
        catch (IOException e) {
            throw new StateStorage.StateStorageException(e.getMessage());
        }
    }

    public boolean hasState(Object component, String componentName, Class<?> aClass, boolean reloadData) throws StateStorage.StateStorageException {
        return true;
    }

    public void setState(Object component, String componentName, Object state) throws StateStorage.StateStorageException {
        assert (component instanceof ModuleRootManager);
        assert (componentName.equals("NewModuleRootManager"));
        assert (state.getClass() == ModuleRootManagerImpl.ModuleRootManagerState.class);
        try {
            this.myConverter.setClasspath((ModuleRootModel)((ModuleRootManagerImpl)((Object)component)));
        }
        catch (WriteExternalException e) {
            throw new StateStorage.StateStorageException(e.getMessage());
        }
        catch (IOException e) {
            throw new StateStorage.StateStorageException(e.getMessage());
        }
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        StateStorage.ExternalizationSession session = new StateStorage.ExternalizationSession(){

            public void setState(Object component, String componentName, Object state, Storage storageSpec) throws StateStorage.StateStorageException {
                assert (ClasspathStorage.this.mySession == this);
                ClasspathStorage.this.setState(component, componentName, state);
            }
        };
        this.mySession = session;
        StateStorage.ExternalizationSession externalizationSession = session;
        if (externalizationSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/storage/ClasspathStorage.startExternalization must not return null");
        }
        return externalizationSession;
    }

    @NotNull
    public StateStorage.SaveSession startSave(StateStorage.ExternalizationSession externalizationSession) {
        assert (this.mySession == externalizationSession);
        StateStorage.SaveSession session = new StateStorage.SaveSession(){

            public boolean needsSave() throws StateStorage.StateStorageException {
                assert (ClasspathStorage.this.mySession == this);
                return ClasspathStorage.this.needsSave();
            }

            public void save() throws StateStorage.StateStorageException {
                assert (ClasspathStorage.this.mySession == this);
                ClasspathStorage.this.save();
            }

            @Nullable
            public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> changedFiles) {
                return null;
            }

            public Collection<IFile> getStorageFilesToSave() throws StateStorage.StateStorageException {
                return this.needsSave() ? this.getAllStorageFiles() : Collections.emptyList();
            }

            public List<IFile> getAllStorageFiles() {
                ArrayList<IFile> list = new ArrayList<IFile>();
                ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
                ClasspathStorage.this.getFileSet().listFiles(virtualFiles);
                for (VirtualFile virtualFile : virtualFiles) {
                    File ioFile = VfsUtil.virtualToIoFile((VirtualFile)virtualFile);
                    list.add(FileSystem.FILE_SYSTEM.createFile(ioFile.getAbsolutePath()));
                }
                return list;
            }
        };
        this.mySession = session;
        StateStorage.SaveSession saveSession = session;
        if (saveSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/storage/ClasspathStorage.startSave must not return null");
        }
        return saveSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSave(StateStorage.SaveSession saveSession) {
        try {
            LOG.assertTrue(this.mySession == saveSession);
        }
        finally {
            this.mySession = null;
        }
    }

    public void reload(Set<String> changedComponents) throws StateStorage.StateStorageException {
    }

    public boolean needsSave() throws StateStorage.StateStorageException {
        return this.getFileSet().hasChanged();
    }

    public void save() throws StateStorage.StateStorageException {
        final Ref ref = new Ref();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    ClasspathStorage.this.getFileSet().commit();
                }
                catch (IOException e) {
                    ref.set((Object)e);
                }
            }
        });
        if (!ref.isNull()) {
            throw new StateStorage.StateStorageException((Throwable)ref.get());
        }
    }

    public static ClasspathStorageProvider getProvider(String type) {
        for (ClasspathStorageProvider provider : ClasspathStorage.getProviders()) {
            if (!type.equals(provider.getID())) continue;
            return provider;
        }
        return new UnsupportedStorageProvider(type);
    }

    public static List<ClasspathStorageProvider> getProviders() {
        ArrayList<ClasspathStorageProvider> list = new ArrayList<ClasspathStorageProvider>();
        list.add(new DefaultStorageProvider());
        list.addAll(Arrays.asList(Extensions.getExtensions(ClasspathStorageProvider.EXTENSION_POINT_NAME)));
        return list;
    }

    @NotNull
    public static String getStorageType(Module module) {
        String id = module.getOptionValue(CLASSPATH_OPTION);
        String string = id != null ? id : DEFAULT_STORAGE;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/storage/ClasspathStorage.getStorageType must not return null");
        }
        return string;
    }

    public static String getModuleDir(Module module) {
        return new File(module.getModuleFilePath()).getParent();
    }

    public static String getStorageRootFromOptions(Module module) {
        String moduleRoot = ClasspathStorage.getModuleDir(module);
        String storageRef = module.getOptionValue(CLASSPATH_DIR_OPTION);
        if (storageRef == null) {
            return moduleRoot;
        }
        if (FileUtil.isAbsolute((String)storageRef)) {
            return storageRef;
        }
        return FileUtil.toSystemIndependentName((String)new File(moduleRoot, storageRef).getPath());
    }

    public static void setStorageType(ModifiableRootModel model, String storageID) {
        Module module = model.getModule();
        String oldStorageType = ClasspathStorage.getStorageType(module);
        if (oldStorageType.equals(storageID)) {
            return;
        }
        ClasspathStorage.getProvider(oldStorageType).detach(module);
        if (storageID.equals(DEFAULT_STORAGE)) {
            module.clearOption(CLASSPATH_OPTION);
            module.clearOption(CLASSPATH_DIR_OPTION);
        } else {
            module.setOption(CLASSPATH_OPTION, storageID);
            module.setOption(CLASSPATH_DIR_OPTION, ClasspathStorage.getProvider(storageID).getContentRoot(model));
        }
    }

    public static void moduleRenamed(Module module, String newName) {
        ClasspathStorage.getProvider(ClasspathStorage.getStorageType(module)).moduleRenamed(module, newName);
    }

    public static class UnsupportedStorageProvider
    implements ClasspathStorageProvider {
        private final String myType;

        public UnsupportedStorageProvider(String type) {
            this.myType = type;
        }

        @Override
        @NonNls
        public String getID() {
            return this.myType;
        }

        @Override
        @Nls
        public String getDescription() {
            return "Unsupported classpath format " + this.myType;
        }

        @Override
        public void assertCompatible(ModifiableRootModel model) throws ConfigurationException {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public void detach(Module module) {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public void moduleRenamed(Module module, String newName) {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public ClasspathStorageProvider.ClasspathConverter createConverter(Module module) {
            return new ClasspathStorageProvider.ClasspathConverter(){

                @Override
                public FileSet getFileSet() {
                    throw new StateStorage.StateStorageException(UnsupportedStorageProvider.this.getDescription());
                }

                @Override
                public Set<String> getClasspath(ModifiableRootModel model, Element element) throws IOException, InvalidDataException {
                    throw new InvalidDataException(UnsupportedStorageProvider.this.getDescription());
                }

                @Override
                public void setClasspath(ModuleRootModel model) throws IOException, WriteExternalException {
                    throw new WriteExternalException(UnsupportedStorageProvider.this.getDescription());
                }
            };
        }

        @Override
        public String getContentRoot(ModifiableRootModel model) {
            return null;
        }
    }

    private static class DefaultStorageProvider
    implements ClasspathStorageProvider {
        private DefaultStorageProvider() {
        }

        @Override
        @NonNls
        public String getID() {
            return ClasspathStorage.DEFAULT_STORAGE;
        }

        @Override
        @Nls
        public String getDescription() {
            return DEFAULT_STORAGE_DESCR;
        }

        @Override
        public void assertCompatible(ModifiableRootModel model) throws ConfigurationException {
        }

        @Override
        public void detach(Module module) {
        }

        @Override
        public void moduleRenamed(Module module, String newName) {
        }

        @Override
        public ClasspathStorageProvider.ClasspathConverter createConverter(Module module) {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public String getContentRoot(ModifiableRootModel model) {
            return null;
        }
    }
}

