/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import java.io.File;
import org.jetbrains.annotations.NotNull;

@State(name="libraryTable", roamingType=RoamingType.DISABLED, storages={@Storage(id="default", file="$OPTIONS$/applicationLibraries.xml")})
public class ApplicationLibraryTable
extends LibraryTableBase
implements ExportableComponent {
    private static final LibraryTablePresentation GLOBAL_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        public String getDisplayName(boolean plural) {
            return ProjectBundle.message((String)"global.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
        }

        public String getDescription() {
            return ProjectBundle.message((String)"libraries.node.text.ide", (Object[])new Object[0]);
        }

        public String getLibraryTableEditorTitle() {
            return ProjectBundle.message((String)"library.configure.global.title", (Object[])new Object[0]);
        }
    };

    public static ApplicationLibraryTable getApplicationTable() {
        return (ApplicationLibraryTable)ServiceManager.getService(ApplicationLibraryTable.class);
    }

    public String getTableLevel() {
        return "application";
    }

    public LibraryTablePresentation getPresentation() {
        return GLOBAL_LIBRARY_TABLE_PRESENTATION;
    }

    public boolean isEditable() {
        return true;
    }

    private static String getExternalFileName() {
        return "applicationLibraries";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)ApplicationLibraryTable.getExternalFileName())};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/ApplicationLibraryTable.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"library.global.settings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/ApplicationLibraryTable.getPresentableName must not return null");
        }
        return string;
    }
}

