/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.application.options.pathMacros.PathMacroConfigurable;
import com.intellij.application.options.pathMacros.PathMacroListEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class UndefinedMacrosConfigurable
implements Configurable {
    private PathMacroListEditor myEditor;
    private final String myText;
    private final Collection<String> myUndefinedMacroNames;

    public UndefinedMacrosConfigurable(String text, Collection<String> undefinedMacroNames) {
        this.myText = text;
        this.myUndefinedMacroNames = undefinedMacroNames;
    }

    public String getHelpTopic() {
        return "preferences.pathVariables";
    }

    public Icon getIcon() {
        return PathMacroConfigurable.ICON;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.configure.path.variables.title", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.myEditor = new PathMacroListEditor(this.myUndefinedMacroNames);
        JComponent editorPanel = this.myEditor.getPanel();
        mainPanel.add((Component)editorPanel, "Center");
        JLabel textLabel = new JLabel(this.myText);
        textLabel.setUI((LabelUI)new MultiLineLabelUI());
        textLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)6, (int)6, (int)6, (int)6));
        mainPanel.add((Component)textLabel, "North");
        return mainPanel;
    }

    public boolean isModified() {
        return this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myEditor.commit();
    }

    public void reset() {
        this.myEditor.reset();
    }

    public void disposeUIResources() {
        this.myEditor = null;
    }
}

