/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.CacheUpdateSession;
import com.intellij.openapi.project.FileContentQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;

class CacheUpdateRunner {
    private final Project myProject;
    private final Collection<CacheUpdater> myUpdaters;
    private CacheUpdateSession mySession;

    CacheUpdateRunner(Project project, Collection<CacheUpdater> updaters) {
        this.myProject = project;
        this.myUpdaters = updaters;
    }

    public int queryNeededFiles(ProgressIndicator indicator) {
        if (this.mySession == null) {
            this.mySession = new CacheUpdateSession(this.myUpdaters, indicator);
        }
        return this.mySession.getFilesToUpdate().size();
    }

    public int getNumberOfPendingUpdateJobs(ProgressIndicator indicator) {
        if (this.mySession == null) {
            this.mySession = new CacheUpdateSession(this.myUpdaters, indicator);
        }
        return this.mySession.getNumberOfPendingUpdateJobs();
    }

    public void processFiles(final ProgressIndicator indicator, boolean processInReadAction) {
        try {
            indicator.checkCanceled();
            FileContentQueue queue = new FileContentQueue();
            Collection<VirtualFile> files = this.mySession.getFilesToUpdate();
            final double total = files.size();
            queue.queue(files, indicator);
            Consumer<VirtualFile> progressUpdater = new Consumer<VirtualFile>(){
                final Set<VirtualFile> processed = new THashSet();

                public void consume(VirtualFile virtualFile) {
                    indicator.checkCanceled();
                    this.processed.add(virtualFile);
                    indicator.setFraction((double)this.processed.size() / total);
                    if (virtualFile.isValid()) {
                        indicator.setText2(virtualFile.getPresentableUrl());
                    } else {
                        indicator.setText2("");
                    }
                }
            };
            while (!this.myProject.isDisposed()) {
                indicator.checkCanceled();
                if (!this.processSomeFilesWhileUserIsInactive(queue, progressUpdater, this.mySession, processInReadAction)) continue;
            }
            if (this.myProject.isDisposed()) {
                indicator.cancel();
                indicator.checkCanceled();
            }
        }
        catch (ProcessCanceledException e) {
            this.mySession.canceled();
            throw e;
        }
    }

    public void updatingDone() {
        try {
            this.mySession.updatingDone();
        }
        catch (ProcessCanceledException e) {
            this.mySession.canceled();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processSomeFilesWhileUserIsInactive(final FileContentQueue queue, final Consumer<VirtualFile> progressUpdater, final CacheUpdateSession session, final boolean processInReadAction) {
        final ProgressIndicatorBase innerIndicator = new ProgressIndicatorBase();
        ApplicationAdapter canceller = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                innerIndicator.cancel();
            }
        };
        final Application application = ApplicationManager.getApplication();
        application.addApplicationListener((ApplicationListener)canceller);
        final boolean[] isFinished = new boolean[1];
        try {
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    while (!CacheUpdateRunner.this.myProject.isDisposed()) {
                        if (innerIndicator.isCanceled()) {
                            return;
                        }
                        final FileContent fileContent = queue.take();
                        if (fileContent == null) {
                            isFinished[0] = true;
                            return;
                        }
                        try {
                            Runnable action = new Runnable(){

                                @Override
                                public void run() {
                                    innerIndicator.checkCanceled();
                                    if (CacheUpdateRunner.this.myProject.isDisposed()) {
                                        return;
                                    }
                                    VirtualFile file = fileContent.getVirtualFile();
                                    progressUpdater.consume((Object)file);
                                    session.processFile(fileContent);
                                }
                            };
                            if (processInReadAction) {
                                application.runReadAction(action);
                                continue;
                            }
                            action.run();
                        }
                        catch (ProcessCanceledException e) {
                            queue.pushback(fileContent);
                            return;
                        }
                    }
                    return;
                }
            }, (ProgressIndicator)innerIndicator);
        }
        finally {
            application.removeApplicationListener((ApplicationListener)canceller);
        }
        return isFinished[0];
    }
}

