/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.HighlighterList;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class IterationState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.IterationState");
    private final TextAttributes myMergedAttributes = new TextAttributes();
    private final HighlighterIterator myHighlighterIterator;
    private final List<RangeHighlighterImpl> myViewHighlighters;
    private int myCurrentViewHighlighterIdx;
    private final List<RangeHighlighterImpl> myDocumentHighlighters;
    private int myCurrentDocHighlighterIdx;
    private int myStartOffset;
    private int myEndOffset;
    private final int myEnd;
    private final int mySelectionStart;
    private final int mySelectionEnd;
    private ArrayList<RangeHighlighterImpl> myCurrentHighlighters;
    private RangeHighlighterImpl myNextViewHighlighter = null;
    private RangeHighlighterImpl myNextDocumentHighlighter = null;
    private final FoldingModelEx myFoldingModel;
    private final boolean hasSelection;
    private FoldRegion myCurrentFold = null;
    private final TextAttributes myFoldTextAttributes;
    private final TextAttributes mySelectionAttributes;
    private final TextAttributes myCaretRowAttributes;
    private final Color myDefaultBackground;
    private final Color myDefaultForeground;
    private final int myCaretRowStart;
    private final int myCaretRowEnd;
    private final ArrayList<TextAttributes> myCachedAttributesList;
    private final DocumentEx myDocument;
    private final EditorEx myEditor;
    private final Color myReadOnlyColor;

    public IterationState(EditorEx editor, int start, boolean useCaretAndSelection) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myDocument = (DocumentEx)editor.getDocument();
        this.myStartOffset = start;
        this.myEnd = editor.getDocument().getTextLength();
        this.myEditor = editor;
        LOG.assertTrue(this.myStartOffset <= this.myEnd);
        this.myHighlighterIterator = editor.getHighlighter().createIterator(start);
        HighlighterList editorList = ((MarkupModelEx)editor.getMarkupModel()).getHighlighterList();
        int longestViewHighlighterLength = editorList == null ? 0 : editorList.getLongestHighlighterLength();
        this.myViewHighlighters = editorList == null ? null : editorList.getSortedHighlighters();
        MarkupModelEx docMarkup = (MarkupModelEx)editor.getDocument().getMarkupModel(editor.getProject());
        HighlighterList docList = docMarkup.getHighlighterList();
        this.myDocumentHighlighters = docList != null ? docList.getSortedHighlighters() : new ArrayList<RangeHighlighterImpl>();
        int longestDocHighlighterLength = docList != null ? docList.getLongestHighlighterLength() : 0;
        this.hasSelection = useCaretAndSelection && editor.getSelectionModel().hasSelection();
        this.mySelectionStart = this.hasSelection ? editor.getSelectionModel().getSelectionStart() : -1;
        this.mySelectionEnd = this.hasSelection ? editor.getSelectionModel().getSelectionEnd() : -1;
        this.myFoldingModel = (FoldingModelEx)editor.getFoldingModel();
        this.myFoldTextAttributes = this.myFoldingModel.getPlaceholderAttributes();
        this.mySelectionAttributes = editor.getSelectionModel().getTextAttributes();
        this.myReadOnlyColor = this.myEditor.getColorsScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        CaretModel caretModel = editor.getCaretModel();
        this.myCaretRowAttributes = editor.isRendererMode() ? null : caretModel.getTextAttributes();
        this.myDefaultBackground = editor.getColorsScheme().getDefaultBackground();
        this.myDefaultForeground = editor.getColorsScheme().getDefaultForeground();
        this.myCurrentHighlighters = new ArrayList();
        this.myCurrentViewHighlighterIdx = this.initHighlighterIterator(start, this.myViewHighlighters, longestViewHighlighterLength);
        while (this.myCurrentViewHighlighterIdx < this.myViewHighlighters.size()) {
            this.myNextViewHighlighter = this.myViewHighlighters.get(this.myCurrentViewHighlighterIdx);
            if (!this.skipHighlighter(this.myNextViewHighlighter)) break;
            ++this.myCurrentViewHighlighterIdx;
        }
        if (this.myCurrentViewHighlighterIdx == this.myViewHighlighters.size()) {
            this.myNextViewHighlighter = null;
        }
        this.myCurrentDocHighlighterIdx = this.initHighlighterIterator(start, this.myDocumentHighlighters, longestDocHighlighterLength);
        this.myNextDocumentHighlighter = null;
        while (this.myCurrentDocHighlighterIdx < this.myDocumentHighlighters.size()) {
            this.myNextDocumentHighlighter = this.myDocumentHighlighters.get(this.myCurrentDocHighlighterIdx);
            if (!this.skipHighlighter(this.myNextDocumentHighlighter)) break;
            ++this.myCurrentDocHighlighterIdx;
        }
        if (this.myCurrentDocHighlighterIdx == this.myDocumentHighlighters.size()) {
            this.myNextDocumentHighlighter = null;
        }
        this.advanceSegmentHighlighters();
        this.myCaretRowStart = caretModel.getVisualLineStart();
        this.myCaretRowEnd = caretModel.getVisualLineEnd();
        this.myEndOffset = Math.min(this.getHighlighterEnd(this.myStartOffset), this.getSelectionEnd(this.myStartOffset));
        this.myEndOffset = Math.min(this.myEndOffset, this.getSegmentHighlightersEnd());
        this.myEndOffset = Math.min(this.myEndOffset, this.getFoldRangesEnd(this.myStartOffset));
        this.myEndOffset = Math.min(this.myEndOffset, this.getCaretEnd(this.myStartOffset));
        this.myEndOffset = Math.min(this.myEndOffset, this.getGuardedBlockEnd(this.myStartOffset));
        this.myCurrentFold = this.myFoldingModel.getCollapsedRegionAtOffset(this.myStartOffset);
        if (this.myCurrentFold != null) {
            this.myEndOffset = this.myCurrentFold.getEndOffset();
        }
        this.myCachedAttributesList = new ArrayList(5);
        this.reinit();
    }

    private int initHighlighterIterator(int start, List<RangeHighlighterImpl> sortedHighlighters, int longestHighlighterLength) {
        int i;
        int low = 0;
        int high = sortedHighlighters.size();
        int search = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(start)) - longestHighlighterLength - 1;
        if (search > 0) {
            while (low < high) {
                int mid;
                for (mid = (low + high) / 2; mid > 0 && !sortedHighlighters.get(mid).isValid(); --mid) {
                }
                if (mid < low + 1) break;
                RangeHighlighterImpl midHighlighter = sortedHighlighters.get(mid);
                if (midHighlighter.getStartOffset() < search) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        }
        int n = i = low == high ? low : 0;
        while (i < sortedHighlighters.size()) {
            RangeHighlighterImpl rangeHighlighter = sortedHighlighters.get(i);
            if (!this.skipHighlighter(rangeHighlighter) && rangeHighlighter.getAffectedAreaEndOffset() >= start) {
                return i;
            }
            ++i;
        }
        return sortedHighlighters.size();
    }

    private boolean skipHighlighter(RangeHighlighterImpl highlighter) {
        if (!highlighter.isValid() || highlighter.isAfterEndOfLine() || highlighter.getTextAttributes() == null) {
            return true;
        }
        FoldRegion region = this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaStartOffset());
        if (region != null && region == this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaEndOffset())) {
            return true;
        }
        return !highlighter.getEditorFilter().avaliableIn((Editor)this.myEditor);
    }

    public void advance() {
        this.myStartOffset = this.myEndOffset;
        this.advanceSegmentHighlighters();
        this.myCurrentFold = this.myFoldingModel.fetchOutermost(this.myStartOffset);
        if (this.myCurrentFold != null) {
            this.myEndOffset = this.myCurrentFold.getEndOffset();
        } else {
            this.myEndOffset = Math.min(this.getHighlighterEnd(this.myStartOffset), this.getSelectionEnd(this.myStartOffset));
            this.myEndOffset = Math.min(this.myEndOffset, this.getSegmentHighlightersEnd());
            this.myEndOffset = Math.min(this.myEndOffset, this.getFoldRangesEnd(this.myStartOffset));
            this.myEndOffset = Math.min(this.myEndOffset, this.getCaretEnd(this.myStartOffset));
            this.myEndOffset = Math.min(this.myEndOffset, this.getGuardedBlockEnd(this.myStartOffset));
        }
        this.reinit();
    }

    private int getHighlighterEnd(int start) {
        while (!this.myHighlighterIterator.atEnd()) {
            int end = this.myHighlighterIterator.getEnd();
            if (end > start) {
                return end;
            }
            this.myHighlighterIterator.advance();
        }
        return this.myEnd;
    }

    private int getCaretEnd(int start) {
        if (this.myCaretRowStart > start) {
            return this.myCaretRowStart;
        }
        if (this.myCaretRowEnd > start) {
            return this.myCaretRowEnd;
        }
        return this.myEnd;
    }

    private int getGuardedBlockEnd(int start) {
        List<RangeMarker> blocks = this.myDocument.getGuardedBlocks();
        int min = this.myEnd;
        for (int i = 0; i < blocks.size(); ++i) {
            RangeMarker block = blocks.get(i);
            if (block.getStartOffset() > start) {
                min = Math.min(min, block.getStartOffset());
                continue;
            }
            if (block.getEndOffset() <= start) continue;
            min = Math.min(min, block.getEndOffset());
        }
        return min;
    }

    private int getSelectionEnd(int start) {
        if (!this.hasSelection) {
            return this.myEnd;
        }
        if (this.mySelectionStart > start) {
            return this.mySelectionStart;
        }
        if (this.mySelectionEnd > start) {
            return this.mySelectionEnd;
        }
        return this.myEnd;
    }

    private void advanceSegmentHighlighters() {
        RangeHighlighterImpl highlighter;
        if (this.myNextDocumentHighlighter != null && this.myNextDocumentHighlighter.getAffectedAreaStartOffset() <= this.myStartOffset) {
            this.myCurrentHighlighters.add(this.myNextDocumentHighlighter);
            this.myNextDocumentHighlighter = null;
        }
        if (this.myNextViewHighlighter != null && this.myNextViewHighlighter.getAffectedAreaStartOffset() <= this.myStartOffset) {
            this.myCurrentHighlighters.add(this.myNextViewHighlighter);
            this.myNextViewHighlighter = null;
        }
        int docHighlightersSize = this.myDocumentHighlighters.size();
        while (this.myNextDocumentHighlighter == null && this.myCurrentDocHighlighterIdx < docHighlightersSize) {
            if (this.skipHighlighter(highlighter = this.myDocumentHighlighters.get(this.myCurrentDocHighlighterIdx++))) continue;
            if (highlighter.getAffectedAreaStartOffset() > this.myStartOffset) {
                this.myNextDocumentHighlighter = highlighter;
                break;
            }
            this.myCurrentHighlighters.add(highlighter);
        }
        int viewHighlightersSize = this.myViewHighlighters.size();
        while (this.myNextViewHighlighter == null && this.myCurrentViewHighlighterIdx < viewHighlightersSize) {
            if (this.skipHighlighter(highlighter = this.myViewHighlighters.get(this.myCurrentViewHighlighterIdx++))) continue;
            if (highlighter.getAffectedAreaStartOffset() > this.myStartOffset) {
                this.myNextViewHighlighter = highlighter;
                break;
            }
            this.myCurrentHighlighters.add(highlighter);
        }
        if (this.myCurrentHighlighters.size() == 1) {
            if (this.myCurrentHighlighters.get(0).getAffectedAreaEndOffset() <= this.myStartOffset) {
                this.myCurrentHighlighters = new ArrayList();
            }
        } else if (!this.myCurrentHighlighters.isEmpty()) {
            ArrayList<RangeHighlighterImpl> copy = new ArrayList<RangeHighlighterImpl>(this.myCurrentHighlighters.size());
            for (int i = 0; i < this.myCurrentHighlighters.size(); ++i) {
                highlighter = this.myCurrentHighlighters.get(i);
                if (highlighter.getAffectedAreaEndOffset() <= this.myStartOffset) continue;
                copy.add(highlighter);
            }
            this.myCurrentHighlighters = copy;
        }
    }

    private int getFoldRangesEnd(int startOffset) {
        int end = this.myEnd;
        FoldRegion[] topLevelCollapsed = this.myFoldingModel.fetchTopLevel();
        if (topLevelCollapsed != null) {
            for (int i = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset) + 1; i >= 0 && i < topLevelCollapsed.length; ++i) {
                int rangeEnd;
                FoldRegion range = topLevelCollapsed[i];
                if (!range.isValid() || (rangeEnd = range.getStartOffset()) <= startOffset) continue;
                if (rangeEnd >= end) break;
                end = rangeEnd;
            }
        }
        return end;
    }

    private int getSegmentHighlightersEnd() {
        int end = this.myEnd;
        for (RangeHighlighterImpl highlighter : this.myCurrentHighlighters) {
            if (highlighter.getAffectedAreaEndOffset() >= end) continue;
            end = highlighter.getAffectedAreaEndOffset();
        }
        if (this.myNextDocumentHighlighter != null && this.myNextDocumentHighlighter.getAffectedAreaStartOffset() < end) {
            end = this.myNextDocumentHighlighter.getAffectedAreaStartOffset();
        }
        if (this.myNextViewHighlighter != null && this.myNextViewHighlighter.getAffectedAreaStartOffset() < end) {
            end = this.myNextViewHighlighter.getAffectedAreaStartOffset();
        }
        return end;
    }

    private void reinit() {
        RangeHighlighterImpl highlighter;
        int i;
        if (this.myHighlighterIterator.atEnd()) {
            return;
        }
        boolean isInSelection = this.hasSelection && this.myStartOffset >= this.mySelectionStart && this.myStartOffset < this.mySelectionEnd;
        boolean isInCaretRow = this.myStartOffset >= this.myCaretRowStart && this.myStartOffset < this.myCaretRowEnd;
        boolean isInGuardedBlock = this.myDocument.getOffsetGuard(this.myStartOffset) != null;
        TextAttributes syntax = this.myHighlighterIterator.getTextAttributes();
        TextAttributes selection = isInSelection ? this.mySelectionAttributes : null;
        TextAttributes caret = isInCaretRow ? this.myCaretRowAttributes : null;
        TextAttributes fold = this.myCurrentFold != null ? this.myFoldTextAttributes : null;
        TextAttributes guard = isInGuardedBlock ? new TextAttributes(null, this.myReadOnlyColor, null, EffectType.BOXED, 0) : null;
        int size = this.myCurrentHighlighters.size();
        if (size > 1) {
            ContainerUtil.quickSort(this.myCurrentHighlighters, (Comparator)LayerComparator.INSTANCE);
        }
        for (i = 0; i < size; ++i) {
            highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getTextAttributes() != TextAttributes.ERASE_MARKER) continue;
            syntax = null;
        }
        this.myCachedAttributesList.clear();
        for (i = 0; i < size; ++i) {
            TextAttributes textAttributes;
            highlighter = this.myCurrentHighlighters.get(i);
            if (selection != null && highlighter.getLayer() < 6000) {
                this.myCachedAttributesList.add(selection);
                selection = null;
            }
            if (syntax != null && highlighter.getLayer() < 2000) {
                if (fold != null) {
                    this.myCachedAttributesList.add(fold);
                    fold = null;
                }
                this.myCachedAttributesList.add(syntax);
                syntax = null;
            }
            if (guard != null && highlighter.getLayer() < 3500) {
                this.myCachedAttributesList.add(guard);
                guard = null;
            }
            if (caret != null && highlighter.getLayer() < 1000) {
                this.myCachedAttributesList.add(caret);
                caret = null;
            }
            if ((textAttributes = highlighter.getTextAttributes()) == null) continue;
            this.myCachedAttributesList.add(textAttributes);
        }
        if (selection != null) {
            this.myCachedAttributesList.add(selection);
        }
        if (fold != null) {
            this.myCachedAttributesList.add(fold);
        }
        if (guard != null) {
            this.myCachedAttributesList.add(guard);
        }
        if (syntax != null) {
            this.myCachedAttributesList.add(syntax);
        }
        if (caret != null) {
            this.myCachedAttributesList.add(caret);
        }
        Color fore = null;
        Color back = isInGuardedBlock ? this.myReadOnlyColor : null;
        Color effect = null;
        EffectType effectType = null;
        int fontType = 0;
        for (int i2 = 0; i2 < this.myCachedAttributesList.size(); ++i2) {
            TextAttributes attrs = this.myCachedAttributesList.get(i2);
            if (fore == null) {
                fore = IterationState.ifDiffers(attrs.getForegroundColor(), this.myDefaultForeground);
            }
            if (back == null) {
                back = IterationState.ifDiffers(attrs.getBackgroundColor(), this.myDefaultBackground);
            }
            if (fontType == 0) {
                fontType = attrs.getFontType();
            }
            if (effect != null) continue;
            effect = attrs.getEffectColor();
            effectType = attrs.getEffectType();
        }
        if (fore == null) {
            fore = this.myDefaultForeground;
        }
        if (back == null) {
            back = this.myDefaultBackground;
        }
        if (effectType == null) {
            effectType = EffectType.BOXED;
        }
        this.myMergedAttributes.setForegroundColor(fore);
        this.myMergedAttributes.setBackgroundColor(back);
        this.myMergedAttributes.setFontType(fontType);
        this.myMergedAttributes.setEffectColor(effect);
        this.myMergedAttributes.setEffectType(effectType);
    }

    @Nullable
    private static Color ifDiffers(Color c1, Color c2) {
        return c1 == c2 ? null : c1;
    }

    public boolean atEnd() {
        return this.myStartOffset >= this.myEnd;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public TextAttributes getMergedAttributes() {
        return this.myMergedAttributes;
    }

    public FoldRegion getCurrentFold() {
        return this.myCurrentFold;
    }

    @Nullable
    public Color getPastFileEndBackground() {
        boolean isInCaretRow = this.myEditor.getCaretModel().getLogicalPosition().line >= this.myDocument.getLineCount() - 1;
        Color caret = isInCaretRow && this.myCaretRowAttributes != null ? this.myCaretRowAttributes.getBackgroundColor() : null;
        ContainerUtil.quickSort(this.myCurrentHighlighters, (Comparator)LayerComparator.INSTANCE);
        for (int i = 0; i < this.myCurrentHighlighters.size(); ++i) {
            Color backgroundColor;
            TextAttributes textAttributes;
            RangeHighlighterImpl highlighter = this.myCurrentHighlighters.get(i);
            if (caret != null && highlighter.getLayer() < 1000) {
                return caret;
            }
            if (highlighter.getTargetArea() != HighlighterTargetArea.LINES_IN_RANGE || this.myDocument.getLineNumber(highlighter.getEndOffset()) < this.myDocument.getLineCount() - 1 || (textAttributes = highlighter.getTextAttributes()) == null || (backgroundColor = textAttributes.getBackgroundColor()) == null) continue;
            return backgroundColor;
        }
        return caret;
    }

    private static class LayerComparator
    implements Comparator<RangeHighlighterImpl> {
        private static final LayerComparator INSTANCE = new LayerComparator();

        private LayerComparator() {
        }

        @Override
        public int compare(RangeHighlighterImpl o1, RangeHighlighterImpl o2) {
            int layerDiff = o2.getLayer() - o1.getLayer();
            if (layerDiff != 0) {
                return layerDiff;
            }
            int o1Length = o1.getEndOffset() - o1.getStartOffset();
            int o2Length = o2.getEndOffset() - o2.getStartOffset();
            return o1Length - o2Length;
        }
    }
}

