/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.Nullable;

public class ToggleShowIndentLinesAction
extends ToggleAction {
    public void setSelected(AnActionEvent e, boolean state) {
        Editor editor = ToggleShowIndentLinesAction.getEditor(e);
        assert (editor != null);
        editor.getSettings().setIndentGuidesShown(state);
    }

    public boolean isSelected(AnActionEvent e) {
        Editor editor = ToggleShowIndentLinesAction.getEditor(e);
        return editor != null && editor.getSettings().isIndentGuidesShown();
    }

    @Nullable
    private static Editor getEditor(AnActionEvent e) {
        return (Editor)e.getData(PlatformDataKeys.EDITOR);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        if (ToggleShowIndentLinesAction.getEditor(e) == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setVisible(true);
        }
    }
}

