/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeSearchHelper;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.EditorPlace;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.settings.DiffPreviewProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.JPanel;

public class DiffPreviewPanel
implements PreviewPanel {
    private final MergePanel2.AsComponent myMergePanelComponent;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public DiffPreviewPanel(Disposable parent) {
        this.myMergePanelComponent = new MergePanel2.AsComponent(parent);
        this.myPanel.add((Component)this.myMergePanelComponent, "Center");
        this.myMergePanelComponent.setToolbarEnabled(false);
        MergePanel2 mergePanel = this.getMergePanel();
        mergePanel.setEditorProperty(MergePanel2.LINE_NUMBERS, Boolean.FALSE);
        mergePanel.setEditorProperty(MergePanel2.LINE_MARKERS_AREA, Boolean.FALSE);
        mergePanel.setEditorProperty(MergePanel2.ADDITIONAL_LINES, 1);
        mergePanel.setEditorProperty(MergePanel2.ADDITIONAL_COLUMNS, 1);
        mergePanel.setScrollToFirstDiff(false);
        for (int i = 0; i < 3; ++i) {
            final EditorMouseListener motionListener = new EditorMouseListener(i);
            final EditorClickListener clickListener = new EditorClickListener(i);
            mergePanel.getEditorPlace(i).addListener(new EditorPlace.EditorListener(){

                @Override
                public void onEditorCreated(EditorPlace place) {
                    Editor editor = place.getEditor();
                    editor.addEditorMouseMotionListener((EditorMouseMotionListener)motionListener);
                    editor.addEditorMouseListener((com.intellij.openapi.editor.event.EditorMouseListener)clickListener);
                    editor.getCaretModel().addCaretListener((CaretListener)clickListener);
                }

                @Override
                public void onEditorReleased(Editor releasedEditor) {
                    releasedEditor.removeEditorMouseMotionListener((EditorMouseMotionListener)motionListener);
                    releasedEditor.removeEditorMouseListener((com.intellij.openapi.editor.event.EditorMouseListener)clickListener);
                }
            });
            Editor editor = mergePanel.getEditor(i);
            if (editor == null) continue;
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)motionListener);
            editor.addEditorMouseListener((com.intellij.openapi.editor.event.EditorMouseListener)clickListener);
        }
    }

    @Override
    public Component getPanel() {
        return this.myPanel;
    }

    @Override
    public void updateView() {
        MergeList mergeList = this.getMergePanel().getMergeList();
        if (mergeList != null) {
            mergeList.updateMarkup();
        }
        this.myMergePanelComponent.repaint();
    }

    public void setMergeRequest(Project project) {
        this.getMergePanel().setDiffRequest(new SampleMerge(project));
    }

    private MergePanel2 getMergePanel() {
        return this.myMergePanelComponent.getMergePanel();
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        this.getMergePanel().setColorScheme(highlighterSettings);
        this.getMergePanel().setEditorProperty(MergePanel2.HIGHLIGHTER_SETTINGS, highlighterSettings);
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void blinkSelectedHighlightType(Object selected) {
    }

    @Override
    public void disposeUIResources() {
    }

    private class EditorClickListener
    extends EditorMouseAdapter
    implements CaretListener {
        private final int myIndex;

        private EditorClickListener(int i) {
            this.myIndex = i;
        }

        public void mouseClicked(EditorMouseEvent e) {
            this.select(MergeSearchHelper.findChangeAt(e, DiffPreviewPanel.this.getMergePanel(), this.myIndex));
        }

        private void select(Change change) {
            if (change == null) {
                return;
            }
            ((ColorAndFontSettingsListener)DiffPreviewPanel.this.myDispatcher.getMulticaster()).selectionInPreviewChanged(change.getType().getTextDiffType().getDisplayName());
        }

        public void caretPositionChanged(CaretEvent e) {
            this.select(MergeSearchHelper.findChangeAt(e, DiffPreviewPanel.this.getMergePanel(), this.myIndex));
        }
    }

    public static class SampleMerge
    extends DiffRequest {
        public SampleMerge(Project project) {
            super(project);
        }

        public DiffContent[] getContents() {
            return DiffPreviewProvider.getContents();
        }

        public String[] getContentTitles() {
            return new String[]{"", "", ""};
        }

        public String getWindowTitle() {
            return DiffBundle.message((String)"merge.color.options.dialog.title", (Object[])new Object[0]);
        }
    }

    private class EditorMouseListener
    extends EditorMouseMotionAdapter {
        private final int myIndex;

        private EditorMouseListener(int index) {
            this.myIndex = index;
        }

        public void mouseMoved(EditorMouseEvent e) {
            MergePanel2 mergePanel = DiffPreviewPanel.this.getMergePanel();
            Editor editor = mergePanel.getEditor(this.myIndex);
            if (MergeSearchHelper.findChangeAt(e, mergePanel, this.myIndex) != null) {
                EditorUtil.setHandCursor(editor);
            }
        }
    }
}

