/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageAnnotationsDefaultValues;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.CompoundExternalizationSession;
import com.intellij.openapi.components.impl.stores.CompoundSaveSession;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class StateStorageManagerImpl
implements StateStorageManager,
Disposable,
StreamProvider,
ComponentVersionProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + StateStorageManagerImpl.class.getName()));
    private static final boolean ourHeadlessEnvironment;
    private final Map<String, String> myMacros = new HashMap<String, String>();
    private final Map<String, StateStorage> myStorages = new HashMap<String, StateStorage>();
    private final Map<String, StateStorage> myPathToStorage = new HashMap<String, StateStorage>();
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    private final String myRootTagName;
    private Object mySession;
    private final PicoContainer myPicoContainer;
    private Map<String, Long> myComponentVersions;
    private final Object myComponentVersLock = new Object();
    private String myVersionsFilePath = null;
    private final MultiMap<RoamingType, StreamProvider> myStreamProviders = new MultiMap();
    private static final Pattern MACRO_PATTERN;

    public StateStorageManagerImpl(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, String rootTagName, @Nullable Disposable parentDisposable, PicoContainer picoContainer) {
        this.myPicoContainer = picoContainer;
        this.myRootTagName = rootTagName;
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    @Override
    public TrackingPathMacroSubstitutor getMacroSubstitutor() {
        return this.myPathMacroSubstitutor;
    }

    @Override
    public synchronized void addMacro(String macro, String expansion) {
        this.myMacros.put("$" + macro + "$", expansion);
    }

    @Override
    @Nullable
    public StateStorage getStateStorage(@NotNull Storage storageSpec) throws StateStorage.StateStorageException {
        if (storageSpec == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StateStorageManagerImpl.getStateStorage must not be null");
        }
        String key = StateStorageManagerImpl.getStorageSpecId(storageSpec);
        return this.getStateStorage(storageSpec, key);
    }

    @Nullable
    private StateStorage getStateStorage(Storage storageSpec, String key) throws StateStorage.StateStorageException {
        if (this.myStorages.get(key) == null) {
            StateStorage stateStorage = this.createStateStorage(storageSpec);
            this.putStorageToMap(key, stateStorage);
        }
        return this.myStorages.get(key);
    }

    @Override
    @Nullable
    public StateStorage getFileStateStorage(String fileName) {
        if (this.myStorages.get(fileName) == null) {
            StateStorage stateStorage = this.createFileStateStorage(fileName);
            this.putStorageToMap(fileName, stateStorage);
        }
        return this.myStorages.get(fileName);
    }

    @Override
    public Collection<String> getStorageFileNames() {
        return Collections.unmodifiableCollection(new HashSet<String>(this.myStorages.keySet()));
    }

    private void putStorageToMap(String key, StateStorage stateStorage) {
        if (stateStorage != null) {
            if (stateStorage instanceof FileBasedStorage) {
                String filePath = ((FileBasedStorage)stateStorage).getFilePath();
                if (this.myPathToStorage.containsKey(filePath)) {
                    StateStorage existing = this.myPathToStorage.get(filePath);
                    this.myStorages.put(key, existing);
                } else {
                    this.myPathToStorage.put(filePath, stateStorage);
                    this.myStorages.put(key, stateStorage);
                }
            } else {
                this.myStorages.put(key, stateStorage);
            }
        }
    }

    @Override
    public long getVersion(String name) {
        Map<String, Long> versions = this.getComponentVersions();
        return versions.containsKey(name) ? versions.get(name) : 0L;
    }

    public void changeVersionsFilePath(String newPath) {
        this.myVersionsFilePath = newPath;
        this.resetLocalVersions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLocalVersions() {
        Object object = this.myComponentVersLock;
        synchronized (object) {
            this.myComponentVersions = null;
        }
    }

    private Map<String, Long> loadVersions() {
        if (this.myVersionsFilePath == null) {
            this.myVersionsFilePath = this.getVersionsFilePath();
        }
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        String filePath = this.getNotNullVersionsFilePath();
        if (filePath != null) {
            try {
                Document document = JDOMUtil.loadDocument((File)new File(filePath));
                StateStorageManagerImpl.loadComponentVersions(result, document);
            }
            catch (JDOMException e) {
                LOG.debug((Throwable)e);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return result;
    }

    private String getNotNullVersionsFilePath() {
        if (this.myVersionsFilePath == null) {
            this.myVersionsFilePath = this.getVersionsFilePath();
        }
        return this.myVersionsFilePath;
    }

    public static void loadComponentVersions(Map<String, Long> result, Document document) {
        List componentObjs = document.getRootElement().getChildren("component");
        for (Object componentObj : componentObjs) {
            if (!(componentObj instanceof Element)) continue;
            Element componentEl = (Element)componentObj;
            String name = componentEl.getAttributeValue("name");
            String version = componentEl.getAttributeValue("version");
            if (name == null || version == null) continue;
            try {
                result.put(name, Long.parseLong(version));
            }
            catch (NumberFormatException e) {}
        }
    }

    protected abstract String getVersionsFilePath();

    @Override
    public void changeVersion(String name, long version) {
        this.getComponentVersions().put(name, version);
    }

    @Nullable
    private StateStorage createStateStorage(Storage storageSpec) throws StateStorage.StateStorageException {
        if (!storageSpec.storageClass().equals(StorageAnnotationsDefaultValues.NullStateStorage.class)) {
            String key = UUID.randomUUID().toString();
            ((MutablePicoContainer)this.myPicoContainer).registerComponentImplementation((Object)key, storageSpec.storageClass());
            return (StateStorage)this.myPicoContainer.getComponentInstance((Object)key);
        }
        if (!storageSpec.stateSplitter().equals(StorageAnnotationsDefaultValues.NullStateSplitter.class)) {
            return this.createDirectoryStateStorage(storageSpec.file(), storageSpec.stateSplitter());
        }
        return this.createFileStateStorage(storageSpec.file());
    }

    private static String getStorageSpecId(Storage storageSpec) {
        if (!storageSpec.storageClass().equals(StorageAnnotationsDefaultValues.NullStateStorage.class)) {
            return storageSpec.storageClass().getName();
        }
        return storageSpec.file();
    }

    @Override
    public void clearStateStorage(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StateStorageManagerImpl.clearStateStorage must not be null");
        }
        this.myStorages.remove(file);
    }

    @Nullable
    private StateStorage createDirectoryStateStorage(String file, Class<? extends StateSplitter> splitterClass) throws StateStorage.StateStorageException {
        StateSplitter splitter;
        String expandedFile = this.expandMacroses(file);
        if (expandedFile == null) {
            this.myStorages.put(file, null);
            return null;
        }
        try {
            splitter = splitterClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new StateStorage.StateStorageException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StateStorage.StateStorageException((Throwable)e);
        }
        return new DirectoryBasedStorage(this.myPathMacroSubstitutor, expandedFile, splitter, this, this.myPicoContainer);
    }

    @Nullable
    StateStorage createFileStateStorage(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StateStorageManagerImpl.createFileStateStorage must not be null");
        }
        String expandedFile = this.expandMacroses(fileSpec);
        if (expandedFile == null) {
            this.myStorages.put(fileSpec, null);
            return null;
        }
        String extension = FileUtil.getExtension((String)new File(expandedFile).getName());
        if (!ourHeadlessEnvironment && extension.length() == 0) {
            throw new IllegalArgumentException("Extension is missing for storage file: " + expandedFile);
        }
        return this.createFileStateStorage(fileSpec, expandedFile, this.myRootTagName, this.myPicoContainer);
    }

    protected StateStorage createFileStateStorage(final String fileSpec, String expandedFile, String rootTagName, PicoContainer picoContainer) {
        return new FileBasedStorage(this.getMacroSubstitutor(fileSpec), this, expandedFile, fileSpec, rootTagName, this, picoContainer, ComponentRoamingManager.getInstance(), this){

            @Override
            @NotNull
            protected XmlElementStorage.StorageData createStorageData() {
                XmlElementStorage.StorageData storageData = StateStorageManagerImpl.this.createStorageData(fileSpec);
                if (storageData == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$1.createStorageData must not return null");
                }
                return storageData;
            }
        };
    }

    public void saveContent(String fileSpec, InputStream content, long size, RoamingType roamingType, boolean async) {
        for (StreamProvider streamProvider : this.getStreamProviders(roamingType)) {
            try {
                if (!streamProvider.isEnabled()) continue;
                streamProvider.saveContent(fileSpec, content, size, roamingType, async);
            }
            catch (ConnectException e) {
                LOG.debug("Cannot send user profile to server: " + e.getLocalizedMessage());
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public void deleteFile(String fileSpec, RoamingType roamingType) {
        for (StreamProvider streamProvider : this.getStreamProviders(roamingType)) {
            try {
                if (!streamProvider.isEnabled()) continue;
                streamProvider.deleteFile(fileSpec, roamingType);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamProvider[] getStreamProviders(RoamingType type) {
        MultiMap<RoamingType, StreamProvider> multiMap = this.myStreamProviders;
        synchronized (multiMap) {
            Collection providers = this.myStreamProviders.get((Object)type);
            return providers.toArray(new StreamProvider[providers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StreamProvider> getStreamProviders() {
        MultiMap<RoamingType, StreamProvider> multiMap = this.myStreamProviders;
        synchronized (multiMap) {
            return Collections.unmodifiableCollection(this.myStreamProviders.values());
        }
    }

    public InputStream loadContent(String fileSpec, RoamingType roamingType) throws IOException {
        for (StreamProvider streamProvider : this.getStreamProviders(roamingType)) {
            try {
                InputStream content;
                if (!streamProvider.isEnabled() || (content = streamProvider.loadContent(fileSpec, roamingType)) == null) continue;
                return content;
            }
            catch (ConnectException e) {
                LOG.debug("Cannot send user profile o server: " + e.getLocalizedMessage());
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
        return null;
    }

    public String[] listSubFiles(String fileSpec) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean isEnabled() {
        for (StreamProvider provider : this.getStreamProviders()) {
            if (!provider.isEnabled()) continue;
            return true;
        }
        return false;
    }

    protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StateStorageManagerImpl.getMacroSubstitutor must not be null");
        }
        return this.myPathMacroSubstitutor;
    }

    protected abstract XmlElementStorage.StorageData createStorageData(String var1);

    @Override
    @Nullable
    public String expandMacroses(String file) {
        Matcher matcher = MACRO_PATTERN.matcher(file);
        while (matcher.find()) {
            String m = matcher.group(1);
            if (this.myMacros.containsKey(m) && (ApplicationManagerEx.getApplication().isUnitTestMode() || this.myMacros.get(m) != null)) continue;
            throw new IllegalArgumentException("Unknown macro: " + m + " in storage spec: " + file);
        }
        String actualFile = file;
        for (String macro : this.myMacros.keySet()) {
            String replacement = this.myMacros.get(macro);
            if (replacement == null) continue;
            actualFile = StringUtil.replace((String)actualFile, (String)macro, (String)replacement);
        }
        return actualFile;
    }

    @Override
    public StateStorageManager.ExternalizationSession startExternalization() {
        if (this.mySession != null) {
            LOG.error("Starting duplicate externalization session: " + this.mySession);
        }
        MyExternalizationSession session = new MyExternalizationSession();
        this.mySession = session;
        return session;
    }

    @Override
    public StateStorageManager.SaveSession startSave(StateStorageManager.ExternalizationSession externalizationSession) {
        assert (this.mySession == externalizationSession);
        MySaveSession session = this.createSaveSession(externalizationSession);
        this.mySession = session;
        return session;
    }

    protected MySaveSession createSaveSession(StateStorageManager.ExternalizationSession externalizationSession) {
        return new MySaveSession((MyExternalizationSession)externalizationSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSave(StateStorageManager.SaveSession saveSession) {
        try {
            assert (this.mySession == saveSession) : "mySession=" + this.mySession + " saveSession=" + saveSession;
            ((MySaveSession)saveSession).finishSave();
        }
        finally {
            this.mySession = null;
            this.save();
        }
    }

    @Override
    public void reset() {
        this.mySession = null;
    }

    @Override
    @Nullable
    public StateStorage getOldStorage(Object component, String componentName, StateStorageOperation operation) throws StateStorage.StateStorageException {
        return this.getFileStateStorage(this.getOldStorageSpec(component, componentName, operation));
    }

    protected abstract String getOldStorageSpec(Object var1, String var2, StateStorageOperation var3) throws StateStorage.StateStorageException;

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStreamProvider(StreamProvider streamProvider, RoamingType type) {
        MultiMap<RoamingType, StreamProvider> multiMap = this.myStreamProviders;
        synchronized (multiMap) {
            this.myStreamProviders.putValue((Object)type, (Object)streamProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterStreamProvider(StreamProvider streamProvider, RoamingType roamingType) {
        MultiMap<RoamingType, StreamProvider> multiMap = this.myStreamProviders;
        synchronized (multiMap) {
            this.myStreamProviders.removeValue((Object)roamingType, (Object)streamProvider);
        }
    }

    public void save() {
        String filePath = this.getNotNullVersionsFilePath();
        if (filePath != null) {
            new File(filePath).getParentFile().mkdirs();
            try {
                JDOMUtil.writeDocument((Document)new Document(StateStorageManagerImpl.createComponentVersionsXml(this.getComponentVersions())), (String)filePath, (String)"\n");
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> getComponentVersions() {
        Object object = this.myComponentVersLock;
        synchronized (object) {
            if (this.myComponentVersions == null) {
                this.myComponentVersions = this.loadVersions();
            }
            return this.myComponentVersions;
        }
    }

    public static Element createComponentVersionsXml(Map<String, Long> versions) {
        Element vers = new Element("versions");
        for (String name : versions.keySet()) {
            long version = versions.get(name);
            if (version == 0L) continue;
            Element element = new Element("component");
            vers.addContent(element);
            element.setAttribute("name", name);
            element.setAttribute("version", String.valueOf(version));
        }
        return vers;
    }

    static {
        ApplicationEx ex = ApplicationManagerEx.getApplicationEx();
        ourHeadlessEnvironment = ex.isHeadlessEnvironment() || ex.isUnitTestMode();
        MACRO_PATTERN = Pattern.compile("(\\$[^\\$]*\\$)");
    }

    protected class MySaveSession
    implements StateStorageManager.SaveSession {
        CompoundSaveSession myCompoundSaveSession;

        public MySaveSession(MyExternalizationSession externalizationSession) {
            this.myCompoundSaveSession = new CompoundSaveSession(externalizationSession.myCompoundExternalizationSession);
        }

        @Override
        public List<IFile> getAllStorageFilesToSave() throws StateStorage.StateStorageException {
            assert (StateStorageManagerImpl.this.mySession == this);
            return this.myCompoundSaveSession.getAllStorageFilesToSave();
        }

        @Override
        public List<IFile> getAllStorageFiles() {
            return this.myCompoundSaveSession.getAllStorageFiles();
        }

        @Override
        public void save() throws StateStorage.StateStorageException {
            assert (StateStorageManagerImpl.this.mySession == this);
            this.myCompoundSaveSession.save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishSave() {
            try {
                LOG.assertTrue(StateStorageManagerImpl.this.mySession == this);
            }
            finally {
                this.myCompoundSaveSession.finishSave();
            }
        }

        @Override
        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            HashSet<String> result = new HashSet<String>();
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                StateStorage stateStorage = (StateStorage)pair.second;
                StateStorage.SaveSession saveSession = this.myCompoundSaveSession.getSaveSession(stateStorage);
                if (saveSession == null) continue;
                Set s = saveSession.analyzeExternalChanges(changedFiles);
                if (s == null) {
                    return null;
                }
                result.addAll(s);
            }
            return result;
        }
    }

    protected class MyExternalizationSession
    implements StateStorageManager.ExternalizationSession {
        CompoundExternalizationSession myCompoundExternalizationSession = new CompoundExternalizationSession();

        protected MyExternalizationSession() {
        }

        @Override
        public void setState(@NotNull Storage[] storageSpecs, Object component, String componentName, Object state) throws StateStorage.StateStorageException {
            if (storageSpecs == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$MyExternalizationSession.setState must not be null");
            }
            assert (StateStorageManagerImpl.this.mySession == this);
            for (Storage storageSpec : storageSpecs) {
                StateStorage stateStorage = StateStorageManagerImpl.this.getStateStorage(storageSpec);
                if (stateStorage == null) continue;
                StateStorage.ExternalizationSession extSession = this.myCompoundExternalizationSession.getExternalizationSession(stateStorage);
                extSession.setState(component, componentName, state, storageSpec);
            }
        }

        @Override
        public void setStateInOldStorage(Object component, String componentName, Object state) throws StateStorage.StateStorageException {
            assert (StateStorageManagerImpl.this.mySession == this);
            StateStorage stateStorage = StateStorageManagerImpl.this.getOldStorage(component, componentName, StateStorageOperation.WRITE);
            if (stateStorage != null) {
                this.myCompoundExternalizationSession.getExternalizationSession(stateStorage).setState(component, componentName, state, null);
            }
        }
    }
}

