/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.DocumentReferenceByVirtualFile;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.util.containers.WeakValueHashMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DocumentReferenceManagerImpl
extends DocumentReferenceManager
implements ApplicationComponent {
    private static final Key<List<VirtualFile>> DELETED_FILES = Key.create((String)(DocumentReferenceManagerImpl.class.getName() + ".DELETED_FILES"));
    private final Map<Reference<Document>, DocumentReference> myDocToRef = new WeakValueHashMap();
    private final Map<VirtualFile, DocumentReference> myFileToRef = new WeakValueHashMap();
    private final Map<FilePath, DocumentReference> myDeletedFilePathToRef = new WeakValueHashMap();

    @NotNull
    public String getComponentName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/command/impl/DocumentReferenceManagerImpl.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(VirtualFileEvent event) {
                VirtualFile f = event.getFile();
                DocumentReference ref = (DocumentReference)DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.remove(new FilePath(f.getUrl()));
                if (ref != null) {
                    DocumentReferenceManagerImpl.this.myFileToRef.put(f, ref);
                    ((DocumentReferenceByVirtualFile)ref).update(f);
                }
            }

            public void beforeFileDeletion(VirtualFileEvent event) {
                VirtualFile f = event.getFile();
                f.putUserData(DELETED_FILES, (Object)DocumentReferenceManagerImpl.this.collectDeletedFiles(f, new ArrayList()));
            }

            public void fileDeleted(VirtualFileEvent event) {
                VirtualFile f = event.getFile();
                List files = (List)f.getUserData(DELETED_FILES);
                f.putUserData(DELETED_FILES, null);
                for (VirtualFile each : files) {
                    DocumentReference ref = (DocumentReference)DocumentReferenceManagerImpl.this.myFileToRef.remove(each);
                    if (ref == null) continue;
                    DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.put(new FilePath(each.getUrl()), ref);
                }
            }
        });
    }

    private List<VirtualFile> collectDeletedFiles(VirtualFile f, List<VirtualFile> files) {
        if (!(f instanceof NewVirtualFile)) {
            return files;
        }
        if (!f.isDirectory()) {
            files.add(f);
        } else {
            for (VirtualFile each : ((NewVirtualFile)f).getInDbChildren()) {
                if (each == NullVirtualFile.INSTANCE) continue;
                this.collectDeletedFiles(each, files);
            }
        }
        return files;
    }

    public void disposeComponent() {
    }

    public DocumentReference create(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/impl/DocumentReferenceManagerImpl.create must not be null");
        }
        this.assertInDispatchThread();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return file != null ? this.create(file) : this.doCreate(document);
    }

    private DocumentReference doCreate(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/impl/DocumentReferenceManagerImpl.doCreate must not be null");
        }
        final int hashCode = document.hashCode();
        WeakReference<Document> reference = new WeakReference<Document>(document){

            public int hashCode() {
                return hashCode;
            }

            public boolean equals(Object obj) {
                Document mydoc = (Document)this.get();
                return mydoc != null && obj instanceof Reference && ((Reference)obj).get() == mydoc;
            }
        };
        DocumentReference result = this.myDocToRef.get(reference);
        if (result == null) {
            result = new DocumentReferenceByDocument(document);
            this.myDocToRef.put((Reference<Document>)reference, result);
        }
        return result;
    }

    public DocumentReference create(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/impl/DocumentReferenceManagerImpl.create must not be null");
        }
        this.assertInDispatchThread();
        assert (file.isValid()) : "file is invalid: " + file;
        DocumentReference result = this.myFileToRef.get(file);
        if (result == null) {
            result = new DocumentReferenceByVirtualFile(file);
            this.myFileToRef.put(file, result);
        }
        return result;
    }

    private void assertInDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }
}

