/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class ModalityStateEx
extends ModalityState {
    private static final WeakReference[] EMPTY_REFS_ARRAY = new WeakReference[0];
    private final WeakReference[] myModalEntities;

    public ModalityStateEx() {
        this(EMPTY_REFS_ARRAY);
    }

    public ModalityStateEx(Object[] modalEntities) {
        if (modalEntities.length > 0) {
            this.myModalEntities = new WeakReference[modalEntities.length];
            for (int i = 0; i < modalEntities.length; ++i) {
                Object entity = modalEntities[i];
                this.myModalEntities[i] = new WeakReference<Object>(entity);
            }
        } else {
            this.myModalEntities = EMPTY_REFS_ARRAY;
        }
    }

    public ModalityState appendProgress(ProgressIndicator progress) {
        return this.appendEntity(progress);
    }

    ModalityStateEx appendEntity(Object anEntity) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (WeakReference modalEntity : this.myModalEntities) {
            Object entity = modalEntity.get();
            if (entity == null) continue;
            list.add(entity);
        }
        list.add(anEntity);
        return new ModalityStateEx(list.toArray());
    }

    private static boolean contains(WeakReference[] array, Object o) {
        for (WeakReference reference : array) {
            Object o1 = reference.get();
            if (o1 == null || !o1.equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean dominates(ModalityState anotherState) {
        for (WeakReference modalEntity : this.myModalEntities) {
            Object entity = modalEntity.get();
            if (entity == null || ModalityStateEx.contains(((ModalityStateEx)anotherState).myModalEntities, entity)) continue;
            return true;
        }
        return false;
    }

    boolean contains(Object modalEntity) {
        return ModalityStateEx.contains(this.myModalEntities, modalEntity);
    }

    @NonNls
    public String toString() {
        if (this.myModalEntities.length == 0) {
            return "ModalityState.NON_MODAL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("ModalityState:");
        for (int i = 0; i < this.myModalEntities.length; ++i) {
            Object entity = this.myModalEntities[i].get();
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(entity);
        }
        return buffer.toString();
    }
}

