/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ApplicationInfoImpl
extends ApplicationInfoEx
implements JDOMExternalizable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.ApplicationInfoImpl");
    @NonNls
    private static final String BUILD_STUB = "__BUILD_NUMBER__";
    private String myCodeName = null;
    private String myMajorVersion = null;
    private String myMinorVersion = null;
    private String myBuildNumber = null;
    private String myLogoUrl = null;
    private Color myLogoTextColor = new Color(0, 35, 135);
    private String myAboutLogoUrl = null;
    @NonNls
    private String myIconUrl = "/icon.png";
    @NonNls
    private String mySmallIconUrl = "/icon_small.png";
    @NonNls
    private String myOpaqueIconUrl = "/icon.png";
    @NonNls
    private String myToolWindowIconUrl = "/general/toolWindowProject.png";
    private Calendar myBuildDate = null;
    private String myPackageCode = null;
    private boolean myShowLicensee = true;
    private String myWelcomeScreenCaptionUrl;
    private String myWelcomeScreenDeveloperSloganUrl;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myEAPFeedbackUrl;
    private String myReleaseFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myPluginsDownloadUrl;
    private String myDefaultUpdateChannel;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    @NonNls
    private String myHelpFileName = "ideahelp.jar";
    @NonNls
    private String myHelpRootName = "idea";
    @NonNls
    private String myWebHelpUrl = "http://www.jetbrains.com/idea/webhelp/";
    private List<ApplicationInfoEx.PluginChooserPage> myPluginChooserPages = new ArrayList<ApplicationInfoEx.PluginChooserPage>();
    @NonNls
    private static final String IDEA_PATH = "/idea/";
    @NonNls
    private static final String ELEMENT_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_MAJOR = "major";
    @NonNls
    private static final String ATTRIBUTE_MINOR = "minor";
    @NonNls
    private static final String ATTRIBUTE_CODENAME = "codename";
    @NonNls
    private static final String ELEMENT_BUILD = "build";
    @NonNls
    private static final String ATTRIBUTE_NUMBER = "number";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ELEMENT_LOGO = "logo";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_TEXTCOLOR = "textcolor";
    @NonNls
    private static final String ELEMENT_ABOUT = "about";
    @NonNls
    private static final String ELEMENT_ICON = "icon";
    @NonNls
    private static final String ATTRIBUTE_SIZE32 = "size32";
    @NonNls
    private static final String ATTRIBUTE_SIZE16 = "size16";
    @NonNls
    private static final String ATTRIBUTE_SIZE12 = "size12";
    @NonNls
    private static final String ATTRIBUTE_SIZE32OPAQUE = "size32opaque";
    @NonNls
    private static final String ELEMENT_PACKAGE = "package";
    @NonNls
    private static final String ATTRIBUTE_CODE = "code";
    @NonNls
    private static final String ELEMENT_LICENSEE = "licensee";
    @NonNls
    private static final String ATTRIBUTE_SHOW = "show";
    @NonNls
    private static final String WELCOME_SCREEN_ELEMENT_NAME = "welcome-screen";
    @NonNls
    private static final String CAPTION_URL_ATTR = "caption-url";
    @NonNls
    private static final String SLOGAN_URL_ATTR = "slogan-url";
    @NonNls
    private static final String UPDATE_URLS_ELEMENT_NAME = "update-urls";
    @NonNls
    private static final String XML_EXTENSION = ".xml";
    @NonNls
    private static final String ATTRIBUTE_EAP = "eap";
    @NonNls
    private static final String HELP_ELEMENT_NAME = "help";
    @NonNls
    private static final String ATTRIBUTE_HELP_FILE = "file";
    @NonNls
    private static final String ATTRIBUTE_HELP_ROOT = "root";
    @NonNls
    private static final String PLUGINS_PAGE_ELEMENT_NAME = "plugins-page";
    @NonNls
    private static final String ELEMENT_DOCUMENTATION = "documentation";
    @NonNls
    private static final String ELEMENT_SUPPORT = "support";
    @NonNls
    private static final String ELEMENT_FEEDBACK = "feedback";
    @NonNls
    private static final String ATTRIBUTE_RELEASE_URL = "release-url";
    @NonNls
    private static final String ATTRIBUTE_EAP_URL = "eap-url";
    @NonNls
    private static final String ELEMENT_PLUGINS = "plugins";
    @NonNls
    private static final String ATTRIBUTE_LIST_URL = "list-url";
    @NonNls
    private static final String ATTRIBUTE_DOWNLOAD_URL = "download-url";
    @NonNls
    private static final String ATTRIBUTE_WEBHELP_URL = "webhelp-url";
    @NonNls
    private static final String ELEMENT_WHATSNEW = "whatsnew";
    @NonNls
    private static final String ELEMENT_KEYMAP = "keymap";
    @NonNls
    private static final String ATTRIBUTE_WINDOWS_URL = "win";
    @NonNls
    private static final String ATTRIBUTE_MAC_URL = "mac";
    private static final String DEFAULT_PLUGINS_HOST = "http://plugins.intellij.net";
    private static ApplicationInfoImpl ourShadowInstance;

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public Calendar getBuildDate() {
        return this.myBuildDate;
    }

    public BuildNumber getBuild() {
        return BuildNumber.fromString((String)this.myBuildNumber);
    }

    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP) {
            return fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    @NonNls
    public String getHelpURL() {
        return "jar:file:///" + this.getHelpJarPath() + "!/" + this.myHelpRootName;
    }

    @NonNls
    private String getHelpJarPath() {
        return PathManager.getHomePath() + File.separator + HELP_ELEMENT_NAME + File.separator + this.myHelpFileName;
    }

    @Override
    public String getLogoUrl() {
        return this.myLogoUrl;
    }

    @Override
    public Color getLogoTextColor() {
        return this.myLogoTextColor;
    }

    @Override
    public String getAboutLogoUrl() {
        return this.myAboutLogoUrl;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    public String getSmallIconUrl() {
        return this.mySmallIconUrl;
    }

    @Override
    public String getOpaqueIconUrl() {
        return this.myOpaqueIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    public String getPackageCode() {
        return this.myPackageCode;
    }

    @Override
    public String getWelcomeScreenCaptionUrl() {
        return this.myWelcomeScreenCaptionUrl;
    }

    @Override
    public String getWelcomeScreenDeveloperSloganUrl() {
        return this.myWelcomeScreenDeveloperSloganUrl;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    public String getDefaultUpdateChannel() {
        return this.myDefaultUpdateChannel;
    }

    @Override
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getEAPFeedbackUrl() {
        return this.myEAPFeedbackUrl;
    }

    @Override
    public String getReleaseFeedbackUrl() {
        return this.myReleaseFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public String getFullApplicationName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getVersionName());
        buffer.append(" ");
        if (this.getMajorVersion() != null && !this.isEAP()) {
            buffer.append(this.getMajorVersion());
            if (this.getMinorVersion() != null && this.getMinorVersion().length() > 0) {
                buffer.append(".");
                buffer.append(this.getMinorVersion());
            }
        } else {
            buffer.append(this.getBuild().asString());
        }
        return buffer.toString();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    public static ApplicationInfoEx getShadowInstance() {
        if (ourShadowInstance == null) {
            ourShadowInstance = new ApplicationInfoImpl();
            try {
                Document doc = JDOMUtil.loadDocument((InputStream)ApplicationInfoImpl.class.getResourceAsStream(IDEA_PATH + ApplicationNamesInfo.getComponentName() + XML_EXTENSION));
                ourShadowInstance.readExternal(doc.getRootElement());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return ourShadowInstance;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        Element keymapElement;
        Element whatsnewElement;
        Element feedbackElement;
        Element supportElement;
        Element helpElement;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconElement;
        Element aboutLogoElement;
        Element buildElement;
        Element versionElement = parentNode.getChild(ELEMENT_VERSION);
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue(ATTRIBUTE_MAJOR);
            this.myMinorVersion = versionElement.getAttributeValue(ATTRIBUTE_MINOR);
            this.myCodeName = versionElement.getAttributeValue(ATTRIBUTE_CODENAME);
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue(ATTRIBUTE_EAP));
            this.myDefaultUpdateChannel = versionElement.getAttributeValue("update-channel");
        }
        if ((buildElement = parentNode.getChild(ELEMENT_BUILD)) != null) {
            this.myBuildNumber = buildElement.getAttributeValue(ATTRIBUTE_NUMBER);
            String dateString = buildElement.getAttributeValue(ATTRIBUTE_DATE);
            if (dateString.equals("__BUILD_DATE__")) {
                this.myBuildDate = new GregorianCalendar();
            } else {
                int year = 0;
                int month = 0;
                int day = 0;
                try {
                    year = Integer.parseInt(dateString.substring(0, 4));
                    month = Integer.parseInt(dateString.substring(4, 6));
                    day = Integer.parseInt(dateString.substring(6, 8));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (month > 0) {
                    --month;
                }
                this.myBuildDate = new GregorianCalendar(year, month, day);
            }
        }
        Thread currentThread = Thread.currentThread();
        currentThread.setName(currentThread.getName() + " " + this.myMajorVersion + "." + this.myMinorVersion + "#" + this.myBuildNumber + ", eap:" + this.myEAP);
        Element logoElement = parentNode.getChild(ELEMENT_LOGO);
        if (logoElement != null) {
            this.myLogoUrl = logoElement.getAttributeValue(ATTRIBUTE_URL);
            int rgb = Integer.parseInt(logoElement.getAttributeValue(ATTRIBUTE_TEXTCOLOR), 16);
            this.myLogoTextColor = new Color(rgb);
        }
        if ((aboutLogoElement = parentNode.getChild(ELEMENT_ABOUT)) != null) {
            this.myAboutLogoUrl = aboutLogoElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((iconElement = parentNode.getChild(ELEMENT_ICON)) != null) {
            this.myIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE32);
            this.mySmallIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE16);
            this.myOpaqueIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE32OPAQUE);
            String toolWindowIcon = iconElement.getAttributeValue(ATTRIBUTE_SIZE12);
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
        }
        if ((packageElement = parentNode.getChild(ELEMENT_PACKAGE)) != null) {
            this.myPackageCode = packageElement.getAttributeValue(ATTRIBUTE_CODE);
        }
        if ((showLicensee = parentNode.getChild(ELEMENT_LICENSEE)) != null) {
            this.myShowLicensee = Boolean.valueOf(showLicensee.getAttributeValue(ATTRIBUTE_SHOW));
        }
        if ((welcomeScreen = parentNode.getChild(WELCOME_SCREEN_ELEMENT_NAME)) != null) {
            this.myWelcomeScreenCaptionUrl = welcomeScreen.getAttributeValue(CAPTION_URL_ATTR);
            this.myWelcomeScreenDeveloperSloganUrl = welcomeScreen.getAttributeValue(SLOGAN_URL_ATTR);
        }
        if ((helpElement = parentNode.getChild(HELP_ELEMENT_NAME)) != null) {
            this.myHelpFileName = helpElement.getAttributeValue(ATTRIBUTE_HELP_FILE);
            this.myHelpRootName = helpElement.getAttributeValue(ATTRIBUTE_HELP_ROOT);
            String webHelpUrl = helpElement.getAttributeValue(ATTRIBUTE_WEBHELP_URL);
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
        }
        Element updateUrls = parentNode.getChild(UPDATE_URLS_ELEMENT_NAME);
        this.myUpdateUrls = new UpdateUrlsImpl(updateUrls);
        Element documentationElement = parentNode.getChild(ELEMENT_DOCUMENTATION);
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((supportElement = parentNode.getChild(ELEMENT_SUPPORT)) != null) {
            this.mySupportUrl = supportElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((feedbackElement = parentNode.getChild(ELEMENT_FEEDBACK)) != null) {
            this.myEAPFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_EAP_URL);
            this.myReleaseFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_RELEASE_URL);
        }
        if ((whatsnewElement = parentNode.getChild(ELEMENT_WHATSNEW)) != null) {
            this.myWhatsNewUrl = whatsnewElement.getAttributeValue(ATTRIBUTE_URL);
        }
        this.myPluginsListUrl = "http://plugins.intellij.net/plugins/list/";
        this.myPluginsDownloadUrl = "http://plugins.intellij.net/pluginManager";
        Element pluginsElement = parentNode.getChild(ELEMENT_PLUGINS);
        if (pluginsElement != null) {
            String downloadUrl;
            this.myPluginManagerUrl = pluginsElement.getAttributeValue(ATTRIBUTE_URL);
            String listUrl = pluginsElement.getAttributeValue(ATTRIBUTE_LIST_URL);
            if (listUrl != null) {
                this.myPluginsListUrl = listUrl;
            }
            if ((downloadUrl = pluginsElement.getAttributeValue(ATTRIBUTE_DOWNLOAD_URL)) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
        } else {
            this.myPluginManagerUrl = DEFAULT_PLUGINS_HOST;
        }
        String pluginsHost = System.getProperty("idea.plugins.host");
        if (pluginsHost != null) {
            this.myPluginsListUrl = this.myPluginsListUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
            this.myPluginsDownloadUrl = this.myPluginsDownloadUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
        }
        if ((keymapElement = parentNode.getChild(ELEMENT_KEYMAP)) != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_WINDOWS_URL);
            this.myMacKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_MAC_URL);
        }
        this.myPluginChooserPages = new ArrayList<ApplicationInfoEx.PluginChooserPage>();
        List children = parentNode.getChildren(PLUGINS_PAGE_ELEMENT_NAME);
        for (Object child : children) {
            this.myPluginChooserPages.add(new PluginChooserPageImpl((Element)child));
        }
    }

    @Override
    public List<ApplicationInfoEx.PluginChooserPage> getPluginChooserPages() {
        return this.myPluginChooserPages;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        throw new WriteExternalException();
    }

    @NotNull
    public String getComponentName() {
        String string = ApplicationNamesInfo.getComponentName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/impl/ApplicationInfoImpl.getComponentName must not return null");
        }
        return string;
    }

    private static class PluginChooserPageImpl
    implements ApplicationInfoEx.PluginChooserPage {
        private final String myTitle;
        private final String myCategory;
        private final String myDependentPlugin;

        private PluginChooserPageImpl(Element e) {
            this.myTitle = e.getAttributeValue("title");
            this.myCategory = e.getAttributeValue("category");
            this.myDependentPlugin = e.getAttributeValue("depends");
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        public String getCategory() {
            return this.myCategory;
        }

        @Override
        public String getDependentPlugin() {
            return this.myDependentPlugin;
        }
    }

    private static class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private String myCheckingUrl;
        private String myPatchesUrl;

        private UpdateUrlsImpl(Element element) {
            if (element != null) {
                this.myCheckingUrl = element.getAttributeValue("check");
                this.myPatchesUrl = element.getAttributeValue("patches");
            }
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }
    }
}

