/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.template.HtmlContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class XmlSurroundDescriptor
implements SurroundDescriptor {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement[] psiElementArray;
        Pair<XmlTagChild, XmlTagChild> childrenInRange = XmlUtil.findTagChildrenInRange(file, startOffset, endOffset);
        if (childrenInRange == null) {
            PsiElement elementAt = file.findElementAt(startOffset);
            if (elementAt instanceof XmlToken && ((XmlToken)elementAt).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
                psiElementArray = new PsiElement[]{elementAt};
                if (psiElementArray == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlSurroundDescriptor.getElementsToSurround must not return null");
                return psiElementArray;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
                if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlSurroundDescriptor.getElementsToSurround must not return null");
                return psiElementArray;
            }
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiElement first = (PsiElement)childrenInRange.getFirst();
        PsiElement last = (PsiElement)childrenInRange.getSecond();
        while (true) {
            block7: {
                result.add(first);
                if (first == last) {
                    psiElementArray = result.toArray(new PsiElement[result.size()]);
                    if (psiElementArray != null) return psiElementArray;
                }
                break block7;
                throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlSurroundDescriptor.getElementsToSurround must not return null");
            }
            first = first.getNextSibling();
        }
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        Surrounder[] surrounderArray = new Surrounder[]{};
        if (surrounderArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlSurroundDescriptor.getSurrounders must not return null");
        }
        return surrounderArray;
    }

    protected boolean isEnabled(TemplateImpl template) {
        TemplateContext context = template.getTemplateContext();
        return context.isEnabled(new XmlContextType()) || context.isEnabled(new HtmlContextType());
    }
}

