/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lang.CompositeLanguage;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlPsiPolicy;
import com.intellij.psi.impl.source.xml.behavior.CDATAOnAnyEncodedPolicy;
import com.intellij.psi.impl.source.xml.behavior.EncodeEachSymbolPolicy;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XMLLanguage
extends CompositeLanguage {
    public static final XMLLanguage INSTANCE = new XMLLanguage();
    protected static final CDATAOnAnyEncodedPolicy CDATA_ON_ANY_ENCODED_POLICY = new CDATAOnAnyEncodedPolicy();
    protected static final EncodeEachSymbolPolicy ENCODE_EACH_SYMBOL_POLICY = new EncodeEachSymbolPolicy();

    private XMLLanguage() {
        this("XML", "text/xml");
        SyntaxHighlighterFactory.LANGUAGE_FACTORY.addExplicitExtension((Object)this, (Object)new SingleLazyInstanceSyntaxHighlighterFactory(){

            @NotNull
            protected SyntaxHighlighter createHighlighter() {
                XmlFileHighlighter xmlFileHighlighter = new XmlFileHighlighter();
                if (xmlFileHighlighter == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XMLLanguage$3.createHighlighter must not return null");
                }
                return xmlFileHighlighter;
            }
        });
    }

    protected XMLLanguage(@NonNls String name, String ... mime) {
        super(name, mime);
    }

    public XmlPsiPolicy getPsiPolicy() {
        return CDATA_ON_ANY_ENCODED_POLICY;
    }

    static {
        RenameInputValidatorRegistry.getInstance().registerInputValidator(PlatformPatterns.or((ElementPattern[])new ElementPattern[]{XmlPatterns.xmlTag().withMetaData(PlatformPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.instanceOf(XmlElementDescriptor.class), PlatformPatterns.instanceOf(XmlAttributeDescriptor.class)})), PlatformPatterns.psiElement(XmlElementDecl.class), PlatformPatterns.psiElement(XmlAttributeDecl.class), XmlPatterns.xmlTag().withDescriptor(PlatformPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.instanceOf(XmlElementDescriptor.class), PlatformPatterns.instanceOf(XmlAttributeDescriptor.class)}))}), new RenameInputValidator(){

            public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
                return newName.trim().matches("([\\d\\w\\_\\.\\-]+:)?[\\d\\w\\_\\.\\-]+");
            }
        });
        RenameInputValidatorRegistry.getInstance().registerInputValidator((ElementPattern)PlatformPatterns.psiElement(XmlAttributeValue.class), new RenameInputValidator(){

            public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
                return true;
            }
        });
    }
}

