/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.ASTDiffBuilder;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.DiffTree;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderImpl
extends UserDataHolderBase
implements PsiBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.impl.PsiBuilderImpl");
    private int[] myLexStarts;
    private IElementType[] myLexTypes;
    private final MyList myProduction = new MyList();
    private final Lexer myLexer;
    private final boolean myFileLevelParsing;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private int myCurrentLexem;
    private final CharSequence myText;
    private final char[] myTextArray;
    private boolean myDebugMode = false;
    private ASTNode myOriginalTree = null;
    private int myLexemCount = 0;
    boolean myTokenTypeChecked;
    private static TokenSet ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    private final LimitedPool<StartMarker> START_MARKERS = new LimitedPool(2000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<StartMarker>(){

        public StartMarker create() {
            return new StartMarker();
        }

        public void cleanup(StartMarker startMarker) {
            startMarker.clean();
        }
    });
    private final LimitedPool<DoneMarker> DONE_MARKERS = new LimitedPool(2000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<DoneMarker>(){

        public DoneMarker create() {
            return new DoneMarker();
        }

        public void cleanup(DoneMarker doneMarker) {
            doneMarker.clean();
        }
    });
    @NonNls
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";
    private ITokenTypeRemapper myRemapper;

    public static void registerWhitespaceToken(IElementType type) {
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{ourAnyLanguageWhitespaceTokens, TokenSet.create((IElementType[])new IElementType[]{type})});
    }

    public PsiBuilderImpl(Language lang, Lexer lexer, ASTNode chameleon, Project project, CharSequence text) {
        this.myText = text;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        assert (parserDefinition != null) : "ParserDefinition absent for language: " + lang.getID();
        this.myLexer = lexer != null ? lexer : parserDefinition.createLexer(project);
        this.myWhitespaces = parserDefinition.getWhitespaceTokens();
        this.myComments = parserDefinition.getCommentTokens();
        this.myCharTable = SharedImplUtil.findCharTableByTree(chameleon);
        this.myOriginalTree = (ASTNode)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED);
        this.myFileLevelParsing = this.myCharTable == null || this.myOriginalTree != null;
        this.cacheLexems();
    }

    public PsiBuilderImpl(Lexer lexer, TokenSet whitespaces, TokenSet comments, CharSequence text) {
        this.myWhitespaces = whitespaces;
        this.myLexer = lexer;
        this.myComments = comments;
        this.myText = text;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text);
        this.myFileLevelParsing = true;
        this.cacheLexems();
    }

    public void setOriginalTree(ASTNode originalTree) {
        this.myOriginalTree = originalTree;
        this.myCharTable = SharedImplUtil.findCharTableByTree(originalTree);
    }

    private void cacheLexems() {
        IElementType type;
        int approxLexCount = Math.max(10, this.myText.length() / 5);
        this.myLexStarts = new int[approxLexCount];
        this.myLexTypes = new IElementType[approxLexCount];
        this.myLexer.start(this.myText);
        int i = 0;
        while ((type = this.myLexer.getTokenType()) != null) {
            if (i >= this.myLexTypes.length - 1) {
                this.resizeLexems(i * 3 / 2);
            }
            this.myLexStarts[i] = this.myLexer.getTokenStart();
            this.myLexTypes[i] = type;
            ++i;
            this.myLexer.advance();
        }
        this.myLexStarts[i] = this.myText.length();
        this.myLexemCount = i;
    }

    public void enforceCommentTokens(TokenSet tokens) {
        this.myComments = tokens;
    }

    @Nullable
    public LighterASTNode getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            ProductionMarker marker = (ProductionMarker)this.myProduction.get(index);
            if (!(marker instanceof DoneMarker)) continue;
            return ((DoneMarker)marker).myStart;
        }
        return null;
    }

    private PsiBuilder.Marker precede(StartMarker marker) {
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("Cannot precede dropped or rolled-back marker");
        }
        StartMarker pre = this.createMarker(marker.myLexemIndex);
        this.myProduction.add(idx, pre);
        return pre;
    }

    public CharSequence getOriginalText() {
        return this.myText;
    }

    public IElementType getTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            IElementType type = this.myLexTypes[this.myCurrentLexem];
            this.myLexTypes[this.myCurrentLexem] = type = this.myRemapper.filter(type, this.myLexStarts[this.myCurrentLexem], this.myLexStarts[this.myCurrentLexem + 1], this.myLexer.getBufferSequence());
            return type;
        }
        return this.myLexTypes[this.myCurrentLexem];
    }

    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
    }

    public void advanceLexer() {
        if (!this.myTokenTypeChecked) {
            LOG.assertTrue(this.eof(), (Object)"Probably a bug: eating token without its type checking");
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexem;
    }

    private void skipWhitespace() {
        while (this.myCurrentLexem < this.myLexemCount && this.whitespaceOrComment(this.myLexTypes[this.myCurrentLexem])) {
            ++this.myCurrentLexem;
        }
    }

    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexem];
    }

    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type = this.getTokenType();
        if (type instanceof TokenWrapper) {
            return ((TokenWrapper)type).getValue();
        }
        return ((Object)this.myText.subSequence(this.myLexStarts[this.myCurrentLexem], this.myLexStarts[this.myCurrentLexem + 1])).toString();
    }

    private void resizeLexems(int newSize) {
        int count = Math.min(newSize, this.myLexTypes.length);
        int[] newStarts = new int[newSize + 1];
        System.arraycopy(this.myLexStarts, 0, newStarts, 0, count);
        this.myLexStarts = newStarts;
        IElementType[] newTypes = new IElementType[newSize];
        System.arraycopy(this.myLexTypes, 0, newTypes, 0, count);
        this.myLexTypes = newTypes;
    }

    private boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexem);
        this.myProduction.add(marker);
        return marker;
    }

    private StartMarker createMarker(int lexemIndex) {
        StartMarker marker = (StartMarker)this.START_MARKERS.alloc();
        marker.myLexemIndex = lexemIndex;
        marker.myBuilder = this;
        if (this.myDebugMode) {
            marker.myDebugAllocationPosition = new Throwable("Created at the following trace.");
        }
        return marker;
    }

    public final boolean eof() {
        this.markTokenTypeChecked();
        this.skipWhitespace();
        return this.myCurrentLexem >= this.myLexemCount;
    }

    private void markTokenTypeChecked() {
        this.myTokenTypeChecked = true;
    }

    private void rollbackTo(PsiBuilder.Marker marker) {
        this.myCurrentLexem = ((StartMarker)marker).myLexemIndex;
        this.markTokenTypeChecked();
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("The marker must be added before rolled back to.");
        }
        this.myProduction.removeRange(idx, this.myProduction.size());
        this.START_MARKERS.recycle((Object)((StartMarker)marker));
    }

    public void doneBefore(PsiBuilder.Marker marker, PsiBuilder.Marker before) {
        int idx;
        if (((StartMarker)marker).myDoneMarker != null) {
            LOG.error("Marker already done.");
        }
        if ((idx = this.myProduction.lastIndexOf(marker)) < 0) {
            LOG.error("Marker never been added.");
        }
        int beforeIndex = this.myProduction.lastIndexOf(before);
        DoneMarker doneMarker = (DoneMarker)this.DONE_MARKERS.alloc();
        doneMarker.myLexemIndex = ((StartMarker)before).myLexemIndex;
        doneMarker.myStart = (StartMarker)marker;
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(beforeIndex, doneMarker);
    }

    public void drop(PsiBuilder.Marker marker) {
        boolean removed;
        boolean bl = removed = this.myProduction.remove(this.myProduction.lastIndexOf(marker)) == marker;
        if (!removed) {
            LOG.error("The marker must be added before it is dropped.");
        }
        this.START_MARKERS.recycle((Object)((StartMarker)marker));
    }

    public void error(PsiBuilder.Marker marker, String message) {
        this.doValidityChecks(marker);
        DoneWithErrorMarker doneMarker = new DoneWithErrorMarker((StartMarker)marker, this.myCurrentLexem, message);
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(doneMarker);
    }

    public void done(PsiBuilder.Marker marker) {
        this.doValidityChecks(marker);
        DoneMarker doneMarker = (DoneMarker)this.DONE_MARKERS.alloc();
        doneMarker.myStart = (StartMarker)marker;
        doneMarker.myLexemIndex = this.myCurrentLexem;
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(doneMarker);
    }

    private void doValidityChecks(PsiBuilder.Marker marker) {
        if (this.myDebugMode) {
            int idx;
            DoneMarker doneMarker = ((StartMarker)marker).myDoneMarker;
            if (doneMarker != null) {
                LOG.error("Marker already done.");
            }
            if ((idx = this.myProduction.lastIndexOf(marker)) < 0) {
                LOG.error("Marker never been added.");
            }
            for (int i = this.myProduction.size() - 1; i > idx; --i) {
                Object item = this.myProduction.get(i);
                if (!(item instanceof PsiBuilder.Marker)) continue;
                StartMarker otherMarker = (StartMarker)item;
                if (otherMarker.myDoneMarker != null) continue;
                Throwable debugAllocOther = otherMarker.myDebugAllocationPosition;
                Throwable debugAllocThis = ((StartMarker)marker).myDebugAllocationPosition;
                if (debugAllocOther != null) {
                    debugAllocThis.printStackTrace(System.err);
                    debugAllocOther.printStackTrace(System.err);
                }
                LOG.error("Another not done marker added after this one. Must be done before this.");
            }
        }
    }

    public void error(String messageText) {
        ProductionMarker lastMarker = (ProductionMarker)this.myProduction.get(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemIndex == this.myCurrentLexem) {
            return;
        }
        this.myProduction.add(new ErrorItem(this, messageText, this.myCurrentLexem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode getTreeBuilt() {
        try {
            StartMarker rootMarker = this.prepareLightTree();
            if (this.myOriginalTree != null) {
                this.merge(this.myOriginalTree, rootMarker);
                throw new BlockSupport.ReparsedSuccessfullyException();
            }
            ASTNode rootNode = this.createRootAST(rootMarker);
            this.bind((CompositeElement)rootNode, rootMarker);
            ASTNode aSTNode = rootNode;
            return aSTNode;
        }
        finally {
            for (ProductionMarker marker : this.myProduction) {
                if (marker instanceof StartMarker) {
                    this.START_MARKERS.recycle((Object)((StartMarker)marker));
                    continue;
                }
                if (!(marker instanceof DoneMarker)) continue;
                this.DONE_MARKERS.recycle((Object)((DoneMarker)marker));
            }
        }
    }

    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        return new MyTreeStructure(rootMarker);
    }

    private ASTNode createRootAST(StartMarker rootMarker) {
        CompositeElement rootNode;
        if (this.myFileLevelParsing) {
            rootNode = new FileElement(rootMarker.myType, null);
            this.myCharTable = ((FileElement)rootNode).getCharTable();
        } else {
            rootNode = PsiBuilderImpl.createComposite(rootMarker);
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        return rootNode;
    }

    private void merge(final ASTNode oldNode, final StartMarker newNode) {
        final PsiFileImpl file = (PsiFileImpl)oldNode.getPsi().getContainingFile();
        final PomModel model = PomManager.getModel((Project)file.getProject());
        try {
            model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)file, model.getModelAspect(TreeAspect.class)){

                public PomModelEvent runInner() throws IncorrectOperationException {
                    MyBuilder builder = new MyBuilder(file, newNode);
                    DiffTree.diff((FlyweightCapableTreeStructure)new ASTStructure(oldNode), (FlyweightCapableTreeStructure)new MyTreeStructure(newNode), (ShallowNodeComparator)new MyComparator(), (DiffTreeChangeBuilder)builder);
                    file.subtreeChanged();
                    return new TreeAspectEvent(model, builder.getEvent());
                }
            });
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        catch (Throwable e) {
            throw new RuntimeException(UNBALANCED_MESSAGE, e);
        }
    }

    private StartMarker prepareLightTree() {
        boolean allTokensInserted;
        this.markTokenTypeChecked();
        MyList fProduction = this.myProduction;
        StartMarker rootMarker = (StartMarker)fProduction.get(0);
        for (int i = 1; i < fProduction.size() - 1; ++i) {
            IElementType prevTokenType;
            ProductionMarker item = (ProductionMarker)fProduction.get(i);
            if (item instanceof StartMarker) {
                IElementType nextTokenType;
                while (item.myLexemIndex < this.myLexemCount && (this.myWhitespaces.contains(nextTokenType = this.myLexTypes[item.myLexemIndex]) || this.myComments.contains(nextTokenType))) {
                    ++item.myLexemIndex;
                }
                continue;
            }
            if (!(item instanceof DoneMarker) && !(item instanceof ErrorItem)) continue;
            int prevProductionLexIndex = ((ProductionMarker)fProduction.get((int)(i - 1))).myLexemIndex;
            while (item.myLexemIndex > prevProductionLexIndex && item.myLexemIndex - 1 < this.myLexemCount && (this.myWhitespaces.contains(prevTokenType = this.myLexTypes[item.myLexemIndex - 1]) || this.myComments.contains(prevTokenType))) {
                --item.myLexemIndex;
            }
        }
        StartMarker curNode = rootMarker;
        Stack nodes = new Stack();
        nodes.push((Object)rootMarker);
        int lastErrorIndex = -1;
        for (int i = 1; i < fProduction.size(); ++i) {
            int curToken;
            ProductionMarker item = (ProductionMarker)fProduction.get(i);
            if (curNode == null) {
                LOG.error("Unexpected end of the production");
            }
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                curNode.addChild(marker);
                nodes.push((Object)curNode);
                curNode = marker;
                continue;
            }
            if (item instanceof DoneMarker) {
                curNode = (StartMarker)nodes.pop();
                continue;
            }
            if (!(item instanceof ErrorItem) || (curToken = item.myLexemIndex) == lastErrorIndex) continue;
            lastErrorIndex = curToken;
            curNode.addChild(item);
        }
        boolean bl = allTokensInserted = this.myCurrentLexem >= this.myLexemCount;
        if (!allTokensInserted) {
            LOG.error("Not all of the tokens inserted to the tree, parsed text:\n" + this.myText);
        }
        if (this.myLexStarts.length <= this.myCurrentLexem + 1) {
            this.resizeLexems(this.myCurrentLexem + 1);
        }
        this.myLexStarts[this.myCurrentLexem] = this.myText.length();
        this.myLexStarts[this.myCurrentLexem + 1] = 0;
        this.myLexTypes[this.myCurrentLexem] = null;
        LOG.assertTrue(curNode == rootMarker, (Object)UNBALANCED_MESSAGE);
        return rootMarker;
    }

    private void bind(CompositeElement ast, StartMarker marker) {
        this.bind(ast, marker, marker.myLexemIndex);
    }

    private int bind(CompositeElement ast, StartMarker marker, int lexIndex) {
        ProductionMarker child = marker.firstChild;
        while (child != null) {
            if (child instanceof StartMarker) {
                StartMarker childMarker = (StartMarker)child;
                lexIndex = this.insertLeafs(lexIndex, childMarker.myLexemIndex, ast);
                CompositeElement childNode = PsiBuilderImpl.createComposite(childMarker);
                ast.rawAddChildren(childNode);
                lexIndex = this.bind(childNode, childMarker, lexIndex);
                lexIndex = this.insertLeafs(lexIndex, childMarker.myDoneMarker.myLexemIndex, ast);
            } else if (child instanceof ErrorItem) {
                lexIndex = this.insertLeafs(lexIndex, child.myLexemIndex, ast);
                PsiErrorElementImpl errorElement = new PsiErrorElementImpl();
                errorElement.setErrorDescription(((ErrorItem)child).myMessage);
                ast.rawAddChildren(errorElement);
            }
            child = child.next;
        }
        return this.insertLeafs(lexIndex, marker.myDoneMarker.myLexemIndex, ast);
    }

    private int insertLeafs(int curToken, int lastIdx, CompositeElement curNode) {
        lastIdx = Math.min(lastIdx, this.myLexemCount);
        while (curToken < lastIdx) {
            int start = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type, start, end);
                curNode.rawAddChildren(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private static CompositeElement createComposite(StartMarker marker) {
        IElementType type = marker.myType;
        if (type == TokenType.ERROR_ELEMENT) {
            PsiErrorElementImpl childNode = new PsiErrorElementImpl();
            if (marker.myDoneMarker instanceof DoneWithErrorMarker) {
                childNode.setErrorDescription(((DoneWithErrorMarker)marker.myDoneMarker).myMessage);
            }
            return childNode;
        }
        if (type == null) {
            throw new RuntimeException(UNBALANCED_MESSAGE);
        }
        return ASTFactory.composite(type);
    }

    @Nullable
    public String getErrorMessage(LighterASTNode node) {
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker) {
            StartMarker marker = (StartMarker)node;
            if (marker.myType == TokenType.ERROR_ELEMENT && marker.myDoneMarker instanceof DoneWithErrorMarker) {
                return ((DoneWithErrorMarker)marker.myDoneMarker).myMessage;
            }
        }
        return null;
    }

    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    public Lexer getLexer() {
        return this.myLexer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TreeElement createLeaf(IElementType type, int start, int end) {
        TreeElement treeElement;
        CharSequence text = this.myCharTable.intern(this.myText, start, end);
        if (this.myWhitespaces.contains(type)) {
            treeElement = new PsiWhiteSpaceImpl(text);
            if (treeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
            return treeElement;
        }
        if (type instanceof CustomParsingType) {
            treeElement = (TreeElement)((CustomParsingType)type).parse(text, this.myCharTable);
            if (treeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
            return treeElement;
        }
        if (type instanceof ILazyParseableElementType) {
            treeElement = ASTFactory.lazy((ILazyParseableElementType)type, text);
            if (treeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
            return treeElement;
        }
        treeElement = ASTFactory.leaf(type, text);
        if (treeElement != null) return treeElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
    }

    private static class MyList
    extends ArrayList<ProductionMarker> {
        private static final Field ourElementDataField;
        private Object[] cachedElementData;

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }

        MyList() {
            super(256);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.cachedElementData == null) {
                return super.lastIndexOf(o);
            }
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.cachedElementData[i] != o) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void ensureCapacity(int minCapacity) {
            if (this.cachedElementData == null || minCapacity >= this.cachedElementData.length) {
                super.ensureCapacity(minCapacity);
                this.initCachedField();
            }
        }

        private void initCachedField() {
            if (ourElementDataField == null) {
                return;
            }
            try {
                this.cachedElementData = (Object[])ourElementDataField.get(this);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        static {
            Field f;
            try {
                f = ArrayList.class.getDeclaredField("elementData");
                f.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                f = null;
            }
            ourElementDataField = f;
        }
    }

    private class ASTConvertor
    implements Convertor<Node, ASTNode> {
        private final Node myRoot;

        public ASTConvertor(Node root) {
            this.myRoot = root;
        }

        public ASTNode convert(Node n) {
            if (n instanceof Token) {
                return PsiBuilderImpl.this.createLeaf(n.getTokenType(), ((Token)n).myTokenStart, ((Token)n).myTokenEnd);
            }
            if (n instanceof ErrorItem) {
                PsiErrorElementImpl errorElement = new PsiErrorElementImpl();
                errorElement.setErrorDescription(((ErrorItem)n).myMessage);
                return errorElement;
            }
            CompositeElement composite = n == this.myRoot ? (CompositeElement)PsiBuilderImpl.this.createRootAST((StartMarker)this.myRoot) : PsiBuilderImpl.createComposite((StartMarker)n);
            PsiBuilderImpl.this.bind(composite, (StartMarker)n);
            return composite;
        }
    }

    private class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<Token> myPool = new LimitedPool(1000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<Token>(){

            public void cleanup(Token token) {
                token.myHC = -1;
            }

            public Token create() {
                return new Token();
            }
        });
        private final StartMarker myRoot;
        private int count;

        public MyTreeStructure(StartMarker root) {
            this.myRoot = root;
        }

        @NotNull
        public LighterASTNode prepareForGetChildren(@NotNull LighterASTNode o) {
            if (o == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.prepareForGetChildren must not be null");
            }
            LighterASTNode lighterASTNode = o;
            if (lighterASTNode == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.prepareForGetChildren must not return null");
            }
            return lighterASTNode;
        }

        @NotNull
        public LighterASTNode getRoot() {
            StartMarker startMarker = this.myRoot;
            if (startMarker == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.getRoot must not return null");
            }
            return startMarker;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count) {
            for (int i = 0; i < count; ++i) {
                LighterASTNode node = nodes[i];
                if (!(node instanceof Token)) continue;
                this.myPool.recycle((Object)((Token)node));
            }
        }

        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.getChildren must not be null");
            }
            if (into == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.getChildren must not be null");
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child = marker.firstChild;
            int lexIndex = marker.myLexemIndex;
            while (child != null) {
                lexIndex = this.insertLeafs(lexIndex, child.myLexemIndex, into);
                this.ensureCapacity(into);
                ((LighterASTNode[])into.get())[this.count++] = child;
                if (child instanceof StartMarker) {
                    lexIndex = ((StartMarker)child).myDoneMarker.myLexemIndex;
                }
                child = child.next;
            }
            this.insertLeafs(lexIndex, marker.myDoneMarker.myLexemIndex, into);
            return this.count;
        }

        private void ensureCapacity(Ref<LighterASTNode[]> into) {
            LighterASTNode[] old = (LighterASTNode[])into.get();
            if (old == null) {
                old = new LighterASTNode[10];
                into.set((Object)old);
            } else if (this.count >= old.length) {
                LighterASTNode[] newStore = new LighterASTNode[this.count * 3 / 2];
                System.arraycopy(old, 0, newStore, 0, this.count);
                into.set((Object)newStore);
            }
        }

        private int insertLeafs(int curToken, int lastIdx, Ref<LighterASTNode[]> into) {
            lastIdx = Math.min(lastIdx, PsiBuilderImpl.this.myLexemCount);
            while (curToken < lastIdx) {
                int start = PsiBuilderImpl.this.myLexStarts[curToken];
                int end = PsiBuilderImpl.this.myLexStarts[curToken + 1];
                IElementType type = PsiBuilderImpl.this.myLexTypes[curToken];
                if (start < end || type instanceof ILeafElementType) {
                    Token lexem = (Token)this.myPool.alloc();
                    lexem.myTokenType = type;
                    lexem.myTokenStart = start;
                    lexem.myTokenEnd = end;
                    this.ensureCapacity(into);
                    ((LighterASTNode[])into.get())[this.count++] = lexem;
                }
                ++curToken;
            }
            return curToken;
        }
    }

    private class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private MyComparator() {
        }

        public ThreeState deepEqual(ASTNode oldNode, LighterASTNode newNode) {
            boolean newIsErrorElement;
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                return ThreeState.NO;
            }
            if (oldIsErrorElement && newIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)oldNode;
                return Comparing.equal((String)e1.getErrorDescription(), (String)PsiBuilderImpl.this.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
            }
            if (newNode instanceof Token) {
                if (oldNode instanceof ForeignLeafPsiElement) {
                    IElementType type = newNode.getTokenType();
                    return type instanceof ForeignLeafType && ((ForeignLeafType)type).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                }
                if (oldNode instanceof LeafElement) {
                    return ((LeafElement)oldNode).textMatches(PsiBuilderImpl.this.myText, ((Token)newNode).myTokenStart, ((Token)newNode).myTokenEnd) ? ThreeState.YES : ThreeState.NO;
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && newNode.getTokenType() instanceof ILazyParseableElementType || oldNode.getElementType() instanceof CustomParsingType && newNode.getTokenType() instanceof CustomParsingType) {
                    return ((TreeElement)oldNode).textMatches(PsiBuilderImpl.this.myText, ((Token)newNode).myTokenStart, ((Token)newNode).myTokenEnd) ? ThreeState.YES : ThreeState.NO;
                }
            }
            return ThreeState.UNSURE;
        }

        public boolean typesEqual(ASTNode n1, LighterASTNode n2) {
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || PsiBuilderImpl.this.myWhitespaces.contains(n2.getTokenType());
            }
            return this.derefToken(n1.getElementType()) == this.derefToken(n2.getTokenType());
        }

        public IElementType derefToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return this.derefToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        public boolean hashcodesEqual(ASTNode n1, LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                if (n1 instanceof ForeignLeafPsiElement && n2.getTokenType() instanceof ForeignLeafType) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(PsiBuilderImpl.this.myText, ((Token)n2).myTokenStart, ((Token)n2).myTokenEnd);
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Comparing.equal((String)(e1 = (PsiErrorElement)n1).getErrorDescription(), (String)PsiBuilderImpl.this.getErrorMessage(n2))) {
                return false;
            }
            return ((TreeElement)n1).hc() == ((Node)n2).hc();
        }
    }

    private class MyBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final ASTDiffBuilder myDelegate;
        private final ASTConvertor myConvertor;

        public MyBuilder(PsiFileImpl file, LighterASTNode rootNode) {
            this.myDelegate = new ASTDiffBuilder(file);
            this.myConvertor = new ASTConvertor((Node)rootNode);
        }

        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyBuilder.nodeDeleted must not be null");
            }
            if (oldNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyBuilder.nodeDeleted must not be null");
            }
            this.myDelegate.nodeDeleted(oldParent, oldNode);
        }

        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyBuilder.nodeInserted must not be null");
            }
            if (newNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyBuilder.nodeInserted must not be null");
            }
            this.myDelegate.nodeInserted(oldParent, this.myConvertor.convert((Node)newNode), pos);
        }

        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            if (oldChild == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyBuilder.nodeReplaced must not be null");
            }
            if (newChild == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyBuilder.nodeReplaced must not be null");
            }
            this.myDelegate.nodeReplaced(oldChild, this.myConvertor.convert((Node)newChild));
        }

        public TreeChangeEvent getEvent() {
            return this.myDelegate.getEvent();
        }
    }

    private static class ErrorItem
    extends ProductionMarker {
        String myMessage;
        private final PsiBuilderImpl myBuilder;

        public ErrorItem(PsiBuilderImpl builder, String message, int idx) {
            this.myBuilder = builder;
            this.myLexemIndex = idx;
            this.myMessage = message;
        }

        @Override
        public int hc() {
            return 0;
        }

        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myLexemIndex];
        }

        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemIndex];
        }

        public IElementType getTokenType() {
            return TokenType.ERROR_ELEMENT;
        }

        @Override
        public void clean() {
            super.clean();
            this.myMessage = null;
        }
    }

    private static class DoneWithErrorMarker
    extends DoneMarker {
        public String myMessage;

        public DoneWithErrorMarker(StartMarker marker, int currentLexem, String message) {
            super(marker, currentLexem);
            this.myMessage = message;
        }

        @Override
        public void clean() {
            super.clean();
            this.myMessage = null;
        }
    }

    private static class DoneMarker
    extends ProductionMarker {
        public StartMarker myStart;

        public DoneMarker() {
        }

        public DoneMarker(StartMarker marker, int currentLexem) {
            this.myLexemIndex = currentLexem;
            this.myStart = marker;
        }

        @Override
        public int hc() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public IElementType getTokenType() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getEndOffset() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getStartOffset() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        public void clean() {
            super.clean();
            this.myStart = null;
        }
    }

    private static abstract class ProductionMarker
    extends Node {
        public int myLexemIndex;
        ProductionMarker next;

        private ProductionMarker() {
        }

        public void clean() {
            this.myLexemIndex = 0;
            this.next = null;
        }
    }

    private class Token
    extends Node {
        public IElementType myTokenType;
        public int myTokenStart;
        public int myTokenEnd;
        public int myHC;

        private Token() {
            this.myHC = -1;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                int hc = 0;
                if (this.myTokenType instanceof TokenWrapper) {
                    String value = ((TokenWrapper)this.myTokenType).getValue();
                    for (int i = 0; i < value.length(); ++i) {
                        hc += value.charAt(i);
                    }
                } else {
                    int start = this.myTokenStart;
                    int end = this.myTokenEnd;
                    CharSequence buf = PsiBuilderImpl.this.myText;
                    char[] bufArray = PsiBuilderImpl.this.myTextArray;
                    for (int i = start; i < end; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        public int getEndOffset() {
            return this.myTokenEnd;
        }

        public int getStartOffset() {
            return this.myTokenStart;
        }

        public CharSequence getText() {
            if (this.myTokenType instanceof TokenWrapper) {
                return ((TokenWrapper)this.myTokenType).getValue();
            }
            return PsiBuilderImpl.this.myText.subSequence(this.myTokenStart, this.myTokenEnd);
        }

        public IElementType getTokenType() {
            return this.myTokenType;
        }
    }

    private static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        public PsiBuilderImpl myBuilder;
        public IElementType myType;
        public DoneMarker myDoneMarker;
        public Throwable myDebugAllocationPosition;
        public ProductionMarker firstChild;
        public ProductionMarker lastChild;
        private int myHC = -1;

        private StartMarker() {
        }

        @Override
        public void clean() {
            super.clean();
            this.myBuilder = null;
            this.myType = null;
            this.myDoneMarker = null;
            this.myDebugAllocationPosition = null;
            this.firstChild = null;
            this.lastChild = null;
            this.myHC = -1;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                PsiBuilderImpl builder = this.myBuilder;
                int hc = 0;
                CharSequence buf = builder.myText;
                char[] bufArray = builder.myTextArray;
                ProductionMarker child = this.firstChild;
                int lexIdx = this.myLexemIndex;
                while (child != null) {
                    int lastLeaf = child.myLexemIndex;
                    for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[lastLeaf]; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                    lexIdx = lastLeaf;
                    hc += child.hc();
                    if (child instanceof StartMarker) {
                        lexIdx = ((StartMarker)child).myDoneMarker.myLexemIndex;
                    }
                    child = child.next;
                }
                for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[this.myDoneMarker.myLexemIndex]; ++i) {
                    hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemIndex];
        }

        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myDoneMarker.myLexemIndex];
        }

        public void addChild(ProductionMarker node) {
            if (this.firstChild == null) {
                this.firstChild = node;
                this.lastChild = node;
            } else {
                this.lastChild.next = node;
                this.lastChild = node;
            }
        }

        public PsiBuilder.Marker precede() {
            return this.myBuilder.precede(this);
        }

        public void drop() {
            this.myBuilder.drop(this);
        }

        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        public void done(IElementType type) {
            this.myType = type;
            this.myBuilder.done(this);
        }

        public void doneBefore(IElementType type, PsiBuilder.Marker before) {
            this.myType = type;
            this.myBuilder.doneBefore(this, before);
        }

        public void doneBefore(IElementType type, PsiBuilder.Marker before, String errorMessage) {
            this.myBuilder.myProduction.add(this.myBuilder.myProduction.lastIndexOf(before), new ErrorItem(this.myBuilder, errorMessage, ((StartMarker)before).myLexemIndex));
            this.doneBefore(type, before);
        }

        public void error(String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.error(this, message);
        }

        public IElementType getTokenType() {
            return this.myType;
        }
    }

    private static abstract class Node
    implements LighterASTNode {
        private Node() {
        }

        public abstract int hc();
    }
}

