/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ExternalResourceManagerImpl;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ResourceRegistrarImpl
implements ResourceRegistrar {
    private final Map<String, Map<String, String>> myResources = new HashMap();
    private List<String> myIgnored = new ArrayList<String>();

    public void addStdResource(@NonNls String resource, @NonNls String fileName) {
        this.addStdResource(resource, null, fileName, this.getClass());
    }

    public void addStdResource(@NonNls String resource, @NonNls String fileName, Class klass) {
        this.addStdResource(resource, null, fileName, klass);
    }

    public void addStdResource(@NonNls String resource, @NonNls String version, @NonNls String fileName, Class klass) {
        String file = ResourceRegistrarImpl.getFile(fileName, klass);
        if (file != null) {
            Map<String, String> map = ExternalResourceManagerImpl.getMap(this.myResources, version, true);
            assert (map != null);
            map.put(resource, file);
        } else {
            String message = "Cannot find standard resource. filename:" + fileName + " klass=" + klass;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExternalResourceManagerImpl.LOG.error(message);
            } else {
                ExternalResourceManagerImpl.LOG.warn(message);
            }
        }
    }

    public void addIgnoredResource(@NonNls String url) {
        this.myIgnored.add(url);
    }

    public void addInternalResource(@NonNls String resource, @NonNls String fileName) {
        this.addInternalResource(resource, null, fileName, this.getClass());
    }

    public void addInternalResource(@NonNls String resource, @NonNls String fileName, Class clazz) {
        this.addInternalResource(resource, null, fileName, clazz);
    }

    public void addInternalResource(@NonNls String resource, @NonNls String version, @NonNls String fileName) {
        this.addInternalResource(resource, version, fileName, this.getClass());
    }

    public void addInternalResource(@NonNls String resource, @NonNls String version, @NonNls String fileName, Class clazz) {
        this.addStdResource(resource, version, "/standardSchemas/" + fileName, clazz);
    }

    @Nullable
    private static String getFile(String name, Class klass) {
        URL resource = klass.getResource(name);
        if (resource == null) {
            return null;
        }
        String path = FileUtil.unquote((String)resource.toString());
        path = path.replace('\\', '/');
        return path;
    }

    public Map<String, Map<String, String>> getResources() {
        return this.myResources;
    }

    public List<String> getIgnored() {
        return this.myIgnored;
    }
}

