/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.javaee.ProjectResources;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.ResourceRegistrarImpl;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalResourceManagerImpl", storages={@Storage(id="other", file="$APP_CONFIG$/other.xml")})
public class ExternalResourceManagerImpl
extends ExternalResourceManagerEx
implements JDOMExternalizable {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.openapi.impl.ExternalResourceManagerImpl");
    @NonNls
    public static final String J2EE_1_3 = "http://java.sun.com/dtd/";
    @NonNls
    public static final String J2EE_1_2 = "http://java.sun.com/j2ee/dtds/";
    @NonNls
    public static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee/";
    @NonNls
    public static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee/";
    private final Map<String, Map<String, String>> myResources = new HashMap();
    private final Set<String> myResourceLocations = new HashSet<String>();
    private final Set<NullableFunction<String, XmlNSDescriptor>> myImplicitNamespaces = new THashSet();
    private final Set<String> myIgnoredResources = new HashSet<String>();
    private final AtomicNotNullLazyValue<Map<String, Map<String, String>>> myStdResources = new AtomicNotNullLazyValue<Map<String, Map<String, String>>>(){

        @NotNull
        protected Map<String, Map<String, String>> compute() {
            Map<String, Map<String, String>> map = ExternalResourceManagerImpl.this.computeStdResources();
            if (map == null) {
                throw new IllegalStateException("@NotNull method com/intellij/javaee/ExternalResourceManagerImpl$1.compute must not return null");
            }
            return map;
        }
    };
    private final List<ExternalResourceListener> myListeners = new ArrayList<ExternalResourceListener>();
    private long myModificationCount = 0L;
    private final PathMacrosImpl myPathMacros;
    @NonNls
    private static final String RESOURCE_ELEMENT = "resource";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String LOCATION_ATTR = "location";
    @NonNls
    private static final String IGNORED_RESOURCE_ELEMENT = "ignored-resource";
    private static final String DEFAULT_VERSION = null;
    @NonNls
    public static final String STANDARD_SCHEMAS = "/standardSchemas/";
    private static final NotNullLazyKey<ProjectResources, Project> INSTANCE_CACHE = ServiceManager.createLazyKey(ProjectResources.class);

    protected Map<String, Map<String, String>> computeStdResources() {
        ResourceRegistrarImpl registrar = new ResourceRegistrarImpl();
        for (StandardResourceProvider provider : (StandardResourceProvider[])Extensions.getExtensions((ExtensionPointName)StandardResourceProvider.EP_NAME)) {
            provider.registerResources((ResourceRegistrar)registrar);
        }
        this.myIgnoredResources.addAll(registrar.getIgnored());
        return registrar.getResources();
    }

    public ExternalResourceManagerImpl(PathMacrosImpl pathMacros) {
        this.myPathMacros = pathMacros;
    }

    public static boolean isStandardResource(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return parent != null && parent.getName().equals("standardSchemas");
    }

    public boolean isUserResource(VirtualFile file) {
        return this.myResourceLocations.contains(file.getUrl());
    }

    @Nullable
    static Map<String, String> getMap(@NotNull Map<String, Map<String, String>> resources, @Nullable String version, boolean create) {
        if (resources == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/javaee/ExternalResourceManagerImpl.getMap must not be null");
        }
        Object map = resources.get(version);
        if (map == null) {
            if (create) {
                map = new HashMap();
                resources.put(version, (Map<String, String>)map);
            } else if (version == null || !version.equals(DEFAULT_VERSION)) {
                map = resources.get(DEFAULT_VERSION);
            }
        }
        return map;
    }

    public String getResourceLocation(String url) {
        return this.getResourceLocation(url, DEFAULT_VERSION);
    }

    public String getResourceLocation(@NonNls String url, String version) {
        String result = this.getUserResourse(url, version);
        if (result == null) {
            result = this.getStdResource(url, version);
        }
        if (result == null) {
            result = url;
        }
        return result;
    }

    @Override
    @Nullable
    public String getUserResourse(Project project, String url, String version) {
        String resourse = ExternalResourceManagerImpl.getProjectResources(project).getUserResourse(url, version);
        return resourse == null ? this.getUserResourse(url, version) : resourse;
    }

    @Override
    @Nullable
    public String getStdResource(String url, String version) {
        Map<String, String> map = ExternalResourceManagerImpl.getMap((Map)this.myStdResources.getValue(), version, false);
        return map != null ? map.get(url) : null;
    }

    @Nullable
    private String getUserResourse(String url, String version) {
        Map<String, String> map = ExternalResourceManagerImpl.getMap(this.myResources, version, false);
        return map != null ? map.get(url) : null;
    }

    public String getResourceLocation(@NonNls String url, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/javaee/ExternalResourceManagerImpl.getResourceLocation must not be null");
        }
        String location = ExternalResourceManagerImpl.getProjectResources(project).getResourceLocation(url);
        return location == null || location.equals(url) ? this.getResourceLocation(url) : location;
    }

    public String getResourceLocation(@NonNls String url, String version, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/javaee/ExternalResourceManagerImpl.getResourceLocation must not be null");
        }
        String location = ExternalResourceManagerImpl.getProjectResources(project).getResourceLocation(url, version);
        return location == null || location.equals(url) ? this.getResourceLocation(url, version) : location;
    }

    @Nullable
    public PsiFile getResourceLocation(@NotNull @NonNls String url, @NotNull PsiFile baseFile, String version) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/javaee/ExternalResourceManagerImpl.getResourceLocation must not be null");
        }
        if (baseFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/javaee/ExternalResourceManagerImpl.getResourceLocation must not be null");
        }
        XmlFile schema = XmlSchemaProvider.findSchema((String)url, (PsiFile)baseFile);
        if (schema != null) {
            return schema;
        }
        String location = this.getResourceLocation(url, version, baseFile.getProject());
        return XmlUtil.findXmlFile(baseFile, location);
    }

    public String[] getResourceUrls(FileType fileType, boolean includeStandard) {
        return this.getResourceUrls(fileType, DEFAULT_VERSION, includeStandard);
    }

    public String[] getResourceUrls(@Nullable FileType fileType, @NonNls String version, boolean includeStandard) {
        LinkedList<String> result = new LinkedList<String>();
        ExternalResourceManagerImpl.addResourcesFromMap(fileType, result, version, this.myResources);
        if (includeStandard) {
            ExternalResourceManagerImpl.addResourcesFromMap(fileType, result, version, (Map)this.myStdResources.getValue());
        }
        return ArrayUtil.toStringArray(result);
    }

    private static void addResourcesFromMap(@Nullable FileType fileType, List<String> result, String version, Map<String, Map<String, String>> resourcesMap) {
        Map<String, String> resources = ExternalResourceManagerImpl.getMap(resourcesMap, version, false);
        if (resources == null) {
            return;
        }
        Set<String> keySet = resources.keySet();
        for (String key : keySet) {
            String resource = resources.get(key);
            if (fileType != null) {
                String defaultExtension = fileType.getDefaultExtension();
                if (!resource.endsWith(defaultExtension) || resource.length() <= defaultExtension.length() || resource.charAt(resource.length() - defaultExtension.length() - 1) != '.') continue;
                result.add(key);
                continue;
            }
            result.add(key);
        }
    }

    public void addResource(String url, String location) {
        this.addResource(url, DEFAULT_VERSION, location);
    }

    public void addResource(@NonNls String url, @NonNls String version, @NonNls String location) {
        this.addSilently(url, version, location);
        this.fireExternalResourceChanged();
    }

    private void addSilently(String url, String version, String location) {
        Map<String, String> map = ExternalResourceManagerImpl.getMap(this.myResources, version, true);
        assert (map != null);
        map.put(url, location);
        this.myResourceLocations.add(location);
        ++this.myModificationCount;
    }

    public void removeResource(String url) {
        this.removeResource(url, DEFAULT_VERSION);
    }

    public void removeResource(String url, String version) {
        Map<String, String> map = ExternalResourceManagerImpl.getMap(this.myResources, version, false);
        if (map != null) {
            String location = map.remove(url);
            if (location != null) {
                this.myResourceLocations.remove(location);
            }
            ++this.myModificationCount;
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public void removeResource(String url, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/javaee/ExternalResourceManagerImpl.removeResource must not be null");
        }
        ExternalResourceManagerImpl.getProjectResources(project).removeResource(url);
    }

    @Override
    public void addResource(@NonNls String url, @NonNls String location, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/javaee/ExternalResourceManagerImpl.addResource must not be null");
        }
        ExternalResourceManagerImpl.getProjectResources(project).addResource(url, location);
    }

    @Override
    public String[] getAvailableUrls() {
        HashSet<String> urls = new HashSet<String>();
        for (Map<String, String> map : this.myResources.values()) {
            urls.addAll(map.keySet());
        }
        return ArrayUtil.toStringArray(urls);
    }

    @Override
    public String[] getAvailableUrls(Project project) {
        return ExternalResourceManagerImpl.getProjectResources(project).getAvailableUrls();
    }

    @Override
    public void clearAllResources() {
        this.myResources.clear();
        this.myIgnoredResources.clear();
    }

    @Override
    public void clearAllResources(Project project) {
        this.clearAllResources();
        ExternalResourceManagerImpl.getProjectResources(project).clearAllResources();
        ++this.myModificationCount;
        this.fireExternalResourceChanged();
    }

    @Override
    public void addIgnoredResource(String url) {
        this.addIgnoredSilently(url);
        this.fireExternalResourceChanged();
    }

    private void addIgnoredSilently(String url) {
        this.myIgnoredResources.add(url);
        ++this.myModificationCount;
    }

    @Override
    public void removeIgnoredResource(String url) {
        if (this.myIgnoredResources.remove(url)) {
            ++this.myModificationCount;
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public boolean isIgnoredResource(String url) {
        return this.myIgnoredResources.contains(url) || ExternalResourceManagerImpl.isImplicitNamespaceDescriptor(url);
    }

    private static boolean isImplicitNamespaceDescriptor(String url) {
        for (ImplicitNamespaceDescriptorProvider namespaceDescriptorProvider : (ImplicitNamespaceDescriptorProvider[])Extensions.getExtensions(ImplicitNamespaceDescriptorProvider.EP_NAME)) {
            if (namespaceDescriptorProvider.getNamespaceDescriptor(null, url) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getIgnoredResources() {
        return ArrayUtil.toStringArray(this.myIgnoredResources);
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element e;
        ExpandMacroToPathMap macroExpands = new ExpandMacroToPathMap();
        this.myPathMacros.addMacroExpands(macroExpands);
        macroExpands.substitute(element, SystemInfo.isFileSystemCaseSensitive);
        ++this.myModificationCount;
        for (Object o1 : element.getChildren(RESOURCE_ELEMENT)) {
            e = (Element)o1;
            this.addSilently(e.getAttributeValue(URL_ATTR), DEFAULT_VERSION, e.getAttributeValue(LOCATION_ATTR).replace('/', File.separatorChar));
        }
        for (Object o : element.getChildren(IGNORED_RESOURCE_ELEMENT)) {
            e = (Element)o;
            this.addIgnoredSilently(e.getAttributeValue(URL_ATTR));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String[] ignoredResources;
        Element e;
        String[] urls;
        for (String url : urls = this.getAvailableUrls()) {
            String location;
            if (url == null || (location = this.getResourceLocation(url)) == null) continue;
            e = new Element(RESOURCE_ELEMENT);
            e.setAttribute(URL_ATTR, url);
            e.setAttribute(LOCATION_ATTR, location.replace(File.separatorChar, '/'));
            element.addContent(e);
        }
        for (String ignoredResource : ignoredResources = this.getIgnoredResources()) {
            e = new Element(IGNORED_RESOURCE_ELEMENT);
            e.setAttribute(URL_ATTR, ignoredResource);
            element.addContent(e);
        }
        ReplacePathToMacroMap macroReplacements = new ReplacePathToMacroMap();
        PathMacrosImpl.getInstanceEx().addMacroReplacements(macroReplacements);
        macroReplacements.substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void addExternalResourceListener(ExternalResourceListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeExternalResourceListener(ExternalResourceListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireExternalResourceChanged() {
        for (ExternalResourceListener listener : this.myListeners.toArray(new ExternalResourceListener[this.myListeners.size()])) {
            listener.externalResourceChanged();
        }
    }

    private static ExternalResourceManagerImpl getProjectResources(Project project) {
        return (ExternalResourceManagerImpl)((Object)INSTANCE_CACHE.getValue((UserDataHolder)project));
    }
}

