/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.EditLocationDialog;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.XmlBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nullable;

public class ExternalResourceConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
OptionalConfigurable {
    private JPanel myPanel;
    private List<EditLocationDialog.NameLocationPair> myPairs;
    private List<String> myIgnoredUrls;
    private AddEditRemovePanel<EditLocationDialog.NameLocationPair> myExtPanel;
    private AddEditRemovePanel<String> myIgnorePanel;
    private final Project myProject;

    public ExternalResourceConfigurable(Project project) {
        this.myProject = project;
    }

    public String getDisplayName() {
        return XmlBundle.message((String)"display.name.edit.external.resource", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        this.myPanel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(700, 400);
            }
        };
        this.myExtPanel = new AddEditRemovePanel<EditLocationDialog.NameLocationPair>((AddEditRemovePanel.TableModel)new ExtUrlsTableModel(), this.myPairs, XmlBundle.message((String)"label.edit.external.resource.configure.external.resources", (Object[])new Object[0])){

            protected EditLocationDialog.NameLocationPair addItem() {
                return ExternalResourceConfigurable.this.addExtLocation();
            }

            protected boolean removeItem(EditLocationDialog.NameLocationPair o) {
                ExternalResourceConfigurable.this.setModified(true);
                return true;
            }

            protected EditLocationDialog.NameLocationPair editItem(EditLocationDialog.NameLocationPair o) {
                return ExternalResourceConfigurable.this.editExtLocation(o);
            }
        };
        this.myExtPanel.setRenderer(1, (TableCellRenderer)new PathRenderer());
        JTable table = this.myExtPanel.getTable();
        TableColumn column = table.getColumn(table.getColumnName(2));
        column.setMaxWidth(50);
        column.setCellEditor(Table.createBooleanEditor());
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ExternalResourceConfigurable.this.setModified(true);
            }
        });
        this.myIgnorePanel = new AddEditRemovePanel<String>((AddEditRemovePanel.TableModel)new IgnoredUrlsModel(), this.myIgnoredUrls, XmlBundle.message((String)"label.edit.external.resource.configure.ignored.resources", (Object[])new Object[0])){

            protected String addItem() {
                return ExternalResourceConfigurable.this.addIgnoreLocation();
            }

            protected boolean removeItem(String o) {
                ExternalResourceConfigurable.this.setModified(true);
                return true;
            }

            protected String editItem(String o) {
                return ExternalResourceConfigurable.this.editIgnoreLocation(o);
            }
        };
        this.myPanel.add((Component)this.myExtPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 2, 4, 2), 0, 0));
        this.myPanel.add((Component)this.myIgnorePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 2, 4, 2), 0, 0));
        this.myExtPanel.setData(this.myPairs);
        this.myIgnorePanel.setData(this.myIgnoredUrls);
        return this.myPanel;
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableExternalResources.png");
    }

    public void apply() {
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        manager.clearAllResources(this.myProject);
        Iterator<Object> i$ = this.myPairs.iterator();
        while (i$.hasNext()) {
            EditLocationDialog.NameLocationPair myPair;
            EditLocationDialog.NameLocationPair pair = myPair = i$.next();
            String s = pair.myLocation.replace('\\', '/');
            if (pair.myShared) {
                manager.addResource(pair.myName, s);
                continue;
            }
            manager.addResource(pair.myName, s, this.myProject);
        }
        i$ = this.myIgnoredUrls.iterator();
        while (i$.hasNext()) {
            String myIgnoredUrl;
            String url = myIgnoredUrl = (String)i$.next();
            manager.addIgnoredResource(url);
        }
        this.setModified(false);
    }

    public void reset() {
        String loc;
        String[] urls;
        this.myPairs = new ArrayList<EditLocationDialog.NameLocationPair>();
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        for (String url : urls = manager.getAvailableUrls()) {
            loc = manager.getResourceLocation(url, this.myProject);
            this.myPairs.add(new EditLocationDialog.NameLocationPair(url, loc, true));
        }
        for (String url : urls = manager.getAvailableUrls(this.myProject)) {
            loc = manager.getResourceLocation(url, this.myProject);
            this.myPairs.add(new EditLocationDialog.NameLocationPair(url, loc, false));
        }
        Collections.sort(this.myPairs);
        this.myIgnoredUrls = new ArrayList<String>();
        String[] ignoredResources = manager.getIgnoredResources();
        this.myIgnoredUrls.addAll(Arrays.asList(ignoredResources));
        Collections.sort(this.myIgnoredUrls);
        if (this.myExtPanel != null) {
            this.myExtPanel.setData(this.myPairs);
            this.myIgnorePanel.setData(this.myIgnoredUrls);
        }
        this.setModified(false);
    }

    public void disposeUIResources() {
        this.myPanel = null;
        this.myExtPanel = null;
        this.myIgnorePanel = null;
    }

    public String getHelpTopic() {
        return this.getId();
    }

    @Nullable
    private EditLocationDialog.NameLocationPair addExtLocation() {
        EditLocationDialog dialog = new EditLocationDialog(null, true);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        this.setModified(true);
        return dialog.getPair();
    }

    @Nullable
    private EditLocationDialog.NameLocationPair editExtLocation(Object o) {
        EditLocationDialog dialog = new EditLocationDialog(null, true);
        EditLocationDialog.NameLocationPair pair = (EditLocationDialog.NameLocationPair)o;
        dialog.init(pair);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        this.setModified(true);
        return dialog.getPair();
    }

    @Nullable
    private String addIgnoreLocation() {
        EditLocationDialog dialog = new EditLocationDialog(null, false);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        this.setModified(true);
        return dialog.getPair().myName;
    }

    @Nullable
    private String editIgnoreLocation(Object o) {
        EditLocationDialog dialog = new EditLocationDialog(null, false);
        dialog.init(new EditLocationDialog.NameLocationPair(o.toString(), null, false));
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        this.setModified(true);
        return dialog.getPair().myName;
    }

    public void selectResource(String uri) {
        this.myExtPanel.setSelected((Object)new EditLocationDialog.NameLocationPair(uri, null, false));
    }

    public String getId() {
        return "preferences.externalResources";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public boolean needDisplay() {
        return !"Ruby".equals(System.getProperty("idea.platform.prefix"));
    }

    private static class ExtUrlsTableModel
    extends AddEditRemovePanel.TableModel<EditLocationDialog.NameLocationPair> {
        final String[] myNames = new String[]{XmlBundle.message((String)"column.name.edit.external.resource.uri", (Object[])new Object[0]), XmlBundle.message((String)"column.name.edit.external.resource.location", (Object[])new Object[0]), "Project"};

        private ExtUrlsTableModel() {
        }

        public int getColumnCount() {
            return this.myNames.length;
        }

        public Object getField(EditLocationDialog.NameLocationPair pair, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return pair.myName;
                }
                case 1: {
                    return pair.myLocation;
                }
                case 2: {
                    return !pair.myShared;
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return columnIndex == 2 ? Boolean.class : String.class;
        }

        public boolean isEditable(int column) {
            return column == 2;
        }

        public void setValue(Object aValue, EditLocationDialog.NameLocationPair data, int columnIndex) {
            data.myShared = (Boolean)aValue == false;
        }

        public String getColumnName(int column) {
            return this.myNames[column];
        }
    }

    private static class IgnoredUrlsModel
    extends AddEditRemovePanel.TableModel<String> {
        private final String[] myNames = new String[]{XmlBundle.message((String)"column.name.edit.external.resource.uri", (Object[])new Object[0])};

        private IgnoredUrlsModel() {
        }

        public int getColumnCount() {
            return this.myNames.length;
        }

        public Object getField(String o, int columnIndex) {
            return o;
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isEditable(int column) {
            return false;
        }

        public void setValue(Object aValue, String data, int columnIndex) {
        }

        public String getColumnName(int column) {
            return this.myNames[column];
        }
    }

    private static class PathRenderer
    extends DefaultTableCellRenderer {
        private PathRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                String loc = value.toString().replace('\\', '/');
                int jarDelimIndex = loc.indexOf("!/");
                VirtualFile path = jarDelimIndex != -1 ? JarFileSystem.getInstance().findFileByPath(loc) : LocalFileSystem.getInstance().findFileByPath(loc);
                this.setForeground(path != null ? (isSelected ? UIUtil.getTableSelectionForeground() : Color.black) : new Color(210, 0, 0));
            }
            return rendererComponent;
        }
    }
}

