/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.ApplicationInfoProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;

public class IdeaLogger
extends com.intellij.openapi.diagnostic.Logger {
    private static ApplicationInfoProvider ourApplicationInfoProvider = IdeaLogger.getIdeaInfoProvider();
    public static String ourLastActionId = "";
    private final Logger myLogger;
    public static Exception ourErrorsOccurred;
    private static String ourCompilationTimestamp;
    @NonNls
    private static final String COMPILATION_TIMESTAMP_RESOURCE_NAME = "/.compilation-timestamp";

    public static String getOurCompilationTimestamp() {
        return ourCompilationTimestamp;
    }

    IdeaLogger(Logger logger) {
        this.myLogger = logger;
    }

    public boolean isDebugEnabled() {
        return this.myLogger.isDebugEnabled();
    }

    public void debug(String message) {
        this.myLogger.debug((Object)message);
    }

    public void debug(Throwable t) {
        this.myLogger.debug((Object)"", t);
    }

    public void debug(@NonNls String message, Throwable t) {
        this.myLogger.debug((Object)message, t);
    }

    public void error(String message, Throwable t, String ... details) {
        if (t instanceof ProcessCanceledException) {
            this.myLogger.error((Object)"Do not log ProcessCanceledException. Thrown at:", t);
            this.myLogger.error((Object)"Do not log ProcessCanceledException. Logged at: ", new Throwable());
            throw (ProcessCanceledException)t;
        }
        if (t.getClass().getName().contains("ReparsedSuccessfullyException")) {
            this.myLogger.error((Object)"Do not log ReparsedSuccessfullyException. Thrown at: ", t);
            this.myLogger.error((Object)"Do not log ReparsedSuccessfullyException. Logged at: ", new Throwable());
            throw (RuntimeException)t;
        }
        String detailString = "";
        for (String detail : details) {
            detailString = detailString + detail + "\n";
        }
        if (ourErrorsOccurred == null) {
            String s = message != null && message.length() > 0 ? "Error message is '" + message + "'" : "";
            String mess = "Logger errors occurred. See IDEA logs for details. " + s;
            ourErrorsOccurred = new Exception(mess + (detailString.length() > 0 ? "\nDetails: " + detailString : ""), t);
        }
        this.myLogger.error((Object)(message + (detailString.length() > 0 ? "\nDetails: " + detailString : "")), t);
        this.logErrorHeader();
        if (t.getCause() != null) {
            this.myLogger.error((Object)"Original exception: ", t.getCause());
        }
    }

    private void logErrorHeader() {
        String info = ourApplicationInfoProvider.getInfo();
        if (info != null) {
            this.myLogger.error((Object)info);
        }
        if (ourCompilationTimestamp != null) {
            this.myLogger.error((Object)("Internal version. Compiled " + ourCompilationTimestamp));
        }
        this.myLogger.error((Object)("JDK: " + System.getProperties().getProperty("java.version", "unknown")));
        this.myLogger.error((Object)("VM: " + System.getProperties().getProperty("java.vm.name", "unknown")));
        this.myLogger.error((Object)("Vendor: " + System.getProperties().getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + System.getProperties().getProperty("os.name", "unknown")));
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        if (application != null && application.isComponentsCreated()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = CommandProcessor.getInstance()) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    public void info(String message) {
        this.myLogger.info((Object)message);
    }

    public void info(String message, Throwable t) {
        this.myLogger.info((Object)message, t);
    }

    public void warn(@NonNls String message, Throwable t) {
        if (t == null) {
            this.myLogger.warn((Object)message);
        } else {
            this.myLogger.warn((Object)message, t);
        }
    }

    public static void setApplicationInfoProvider(ApplicationInfoProvider aProvider) {
        ourApplicationInfoProvider = aProvider;
    }

    private static ApplicationInfoProvider getIdeaInfoProvider() {
        return new ApplicationInfoProvider(){

            public String getInfo() {
                ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
                if (application != null && application.isComponentsCreated() && application.hasComponent(ApplicationInfo.class)) {
                    ApplicationInfoEx ideInfo = (ApplicationInfoEx)application.getComponent(ApplicationInfo.class);
                    return ideInfo.getFullApplicationName() + "  " + "Build #" + ideInfo.getBuild().asString();
                }
                return null;
            }
        };
    }

    public void setLevel(Level level) {
        this.myLogger.setLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream stream = com.intellij.openapi.diagnostic.Logger.class.getResourceAsStream(COMPILATION_TIMESTAMP_RESOURCE_NAME);
        if (stream != null) {
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
            try {
                String s = reader.readLine();
                if (s != null) {
                    ourCompilationTimestamp = s.trim();
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

