/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.util.Collection;

public abstract class ChangeListTodosPanel
extends TodoPanel {
    private final Alarm myAlarm;

    public ChangeListTodosPanel(Project project, TodoPanelSettings settings, Content content) {
        super(project, settings, false, content);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        final MyChangeListManagerListener myChangeListManagerListener = new MyChangeListManagerListener();
        changeListManager.addChangeListListener((ChangeListListener)myChangeListManagerListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                ChangeListManager.getInstance((Project)ChangeListTodosPanel.this.myProject).removeChangeListListener((ChangeListListener)myChangeListManagerListener);
            }
        });
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)project);
    }

    private final class MyChangeListManagerListener
    extends ChangeListAdapter {
        private MyChangeListManagerListener() {
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            this.rebuild();
            ChangeListTodosPanel.this.setDisplayName(IdeBundle.message((String)"changelist.todo.title", (Object[])new Object[]{newDefaultList.getName()}));
        }

        public void changeListRenamed(ChangeList list, String oldName) {
            ChangeListTodosPanel.this.setDisplayName(IdeBundle.message((String)"changelist.todo.title", (Object[])new Object[]{list.getName()}));
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            this.rebuild();
        }

        private void rebuild() {
            ChangeListTodosPanel.this.myAlarm.cancelAllRequests();
            ChangeListTodosPanel.this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            ChangeListTodosPanel.this.myTodoTreeBuilder.rebuildCache();
                        }
                    });
                    ChangeListTodosPanel.this.updateTree();
                }
            }, 300);
        }
    }
}

