/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NamedLibraryElementNode
extends ProjectViewNode<NamedLibraryElement> {
    private static final Icon GENERIC_JDK_ICON = IconLoader.getIcon((String)"/general/jdk.png");
    private static final Icon LIB_ICON_OPEN = IconLoader.getIcon((String)"/nodes/ppLibOpen.png");
    private static final Icon LIB_ICON_CLOSED = IconLoader.getIcon((String)"/nodes/ppLibClosed.png");

    public NamedLibraryElementNode(Project project, NamedLibraryElement value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    public NamedLibraryElementNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (NamedLibraryElement)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        LibraryGroupNode.addLibraryChildren(((NamedLibraryElement)this.getValue()).getOrderEntry(), children, this.getProject(), this);
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode.getChildren must not return null");
        }
        return arrayList;
    }

    public String getTestPresentation() {
        return "Library: " + ((NamedLibraryElement)this.getValue()).getName();
    }

    private static Icon getJdkIcon(JdkOrderEntry entry, boolean isExpanded) {
        Sdk jdk = entry.getJdk();
        if (jdk == null) {
            return GENERIC_JDK_ICON;
        }
        return isExpanded ? jdk.getSdkType().getIconForExpandedTreeNode() : jdk.getSdkType().getIcon();
    }

    public String getName() {
        return ((NamedLibraryElement)this.getValue()).getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode.contains must not be null");
        }
        return NamedLibraryElementNode.orderEntryContainsFile(((NamedLibraryElement)this.getValue()).getOrderEntry(), file);
    }

    private static boolean orderEntryContainsFile(OrderEntry orderEntry, VirtualFile file) {
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            if (!NamedLibraryElementNode.containsFileInOrderType(orderEntry, rootType, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFileInOrderType(OrderEntry orderEntry, OrderRootType orderType, VirtualFile file) {
        VirtualFile[] files;
        if (!orderEntry.isValid()) {
            return false;
        }
        for (VirtualFile virtualFile : files = orderEntry.getFiles(orderType)) {
            boolean ancestor = VfsUtil.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false);
            if (!ancestor) continue;
            return true;
        }
        return false;
    }

    public void update(PresentationData presentation) {
        JdkOrderEntry jdkOrderEntry;
        Sdk projectJdk;
        presentation.setPresentableText(((NamedLibraryElement)this.getValue()).getName());
        OrderEntry orderEntry = ((NamedLibraryElement)this.getValue()).getOrderEntry();
        presentation.setOpenIcon(orderEntry instanceof JdkOrderEntry ? NamedLibraryElementNode.getJdkIcon((JdkOrderEntry)orderEntry, true) : LIB_ICON_OPEN);
        presentation.setClosedIcon(orderEntry instanceof JdkOrderEntry ? NamedLibraryElementNode.getJdkIcon((JdkOrderEntry)orderEntry, false) : LIB_ICON_CLOSED);
        if (orderEntry instanceof JdkOrderEntry && (projectJdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) != null) {
            presentation.setLocationString(FileUtil.toSystemDependentName((String)projectJdk.getHomePath()));
        }
    }

    protected String getToolTip() {
        OrderEntry orderEntry = ((NamedLibraryElement)this.getValue()).getOrderEntry();
        return orderEntry instanceof JdkOrderEntry ? IdeBundle.message((String)"node.projectview.jdk", (Object[])new Object[0]) : StringUtil.capitalize((String)IdeBundle.message((String)"node.projectview.library", (Object[])new Object[]{((LibraryOrderEntry)orderEntry).getLibraryLevel()}));
    }

    public void navigate(boolean requestFocus) {
        ProjectSettingsService.getInstance(this.myProject).openProjectLibrarySettings((NamedLibraryElement)this.getValue());
    }

    public boolean canNavigate() {
        return true;
    }
}

