/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsiBasedNode<Value>
extends ProjectViewNode<Value>
implements ValidateableNode {
    private static final Logger LOG = Logger.getInstance((String)AbstractPsiBasedNode.class.getName());

    protected AbstractPsiBasedNode(Project project, Value value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @Nullable
    protected abstract PsiElement extractPsiFromValue();

    @Nullable
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected abstract void updateImpl(PresentationData var1);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        Collection<Object> collection;
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            collection = new ArrayList<AbstractTreeNode>();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode.getChildren must not return null");
            return collection;
        }
        boolean valid = psiElement.isValid();
        if (!LOG.assertTrue(valid)) {
            collection = Collections.emptyList();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode.getChildren must not return null");
            return collection;
        }
        Collection<AbstractTreeNode> children = this.getChildrenImpl();
        collection = children != null ? children : Collections.emptyList();
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode.getChildren must not return null");
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }

    protected boolean isMarkReadOnly() {
        AbstractTreeNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof AbstractPsiBasedNode) {
            PsiElement psiElement = ((AbstractPsiBasedNode)parent).extractPsiFromValue();
            return psiElement instanceof PsiDirectory;
        }
        Object parentValue = parent.getValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof Module;
    }

    public FileStatus getFileStatus() {
        VirtualFile file = this.getVirtualFileForValue();
        if (file == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)this.getProject()).getStatus(file);
    }

    @Nullable
    private VirtualFile getVirtualFileForValue() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return null;
        }
        return PsiUtilBase.getVirtualFile((PsiElement)psiElement);
    }

    public void update(PresentationData data) {
        if (!this.validate()) {
            return;
        }
        PsiElement value = this.extractPsiFromValue();
        LOG.assertTrue(value.isValid());
        int flags = this.getIconableFlags();
        try {
            Icon icon = value.getIcon(flags);
            data.setClosedIcon(icon);
            data.setOpenIcon(icon);
        }
        catch (IndexNotReadyException ignored) {
            // empty catch block
        }
        data.setPresentableText(this.myName);
        try {
            if (this.isDeprecated()) {
                data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
            }
        }
        catch (IndexNotReadyException ignored) {
            // empty catch block
        }
        this.updateImpl(data);
        for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
            decorator.decorate(this, data);
        }
    }

    protected int getIconableFlags() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        return flags;
    }

    protected boolean isDeprecated() {
        return false;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode.contains must not be null");
        }
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile valueFile = containingFile.getVirtualFile();
        return valueFile != null && file.equals(valueFile);
    }

    @Nullable
    public NavigationItem getNavigationItem() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement instanceof NavigationItem ? (NavigationItem)psiElement : null;
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            if (requestFocus) {
                NavigationUtil.activateFileWithPsiElement(this.extractPsiFromValue());
            } else {
                this.getNavigationItem().navigate(requestFocus);
            }
        }
    }

    public boolean canNavigate() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigate();
    }

    public boolean canNavigateToSource() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigateToSource();
    }

    @Nullable
    protected String calcTooltip() {
        return null;
    }

    public boolean validate() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }
}

