/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.SortableProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class PluginTableModel
extends AbstractTableModel
implements SortableColumnModel {
    protected ColumnInfo[] columns;
    protected SortableProvider sortableProvider;
    protected List<IdeaPluginDescriptor> view;

    protected PluginTableModel() {
    }

    public PluginTableModel(SortableProvider sortableProvider, ColumnInfo ... columns) {
        this.columns = columns;
        this.sortableProvider = sortableProvider;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.columns;
    }

    public boolean isSortable() {
        return true;
    }

    public void setSortable(boolean aBoolean) {
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column].getName();
    }

    public int getSortedColumnIndex() {
        return this.sortableProvider.getSortColumn();
    }

    public int getSortingType() {
        return this.sortableProvider.getSortOrder();
    }

    public IdeaPluginDescriptor getObjectAt(int row) {
        return this.view.get(row);
    }

    @Override
    public int getRowCount() {
        return this.view.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].valueOf((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].isCellEditable((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.columns[columnIndex].setValue((Object)this.getObjectAt(rowIndex), aValue);
    }

    public void sortByColumn(int columnIndex) {
        Collections.sort(this.view, this.columns[columnIndex].getComparator());
        this.fireTableDataChanged();
    }

    public void sortByColumn(int columnIndex, int sortingType) {
        this.sortByColumn(columnIndex);
    }

    public ArrayList<IdeaPluginDescriptorImpl> dependent(IdeaPluginDescriptorImpl plugin) {
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>();
        block0: for (IdeaPluginDescriptor any : this.view) {
            PluginId[] dep;
            if (!(any instanceof IdeaPluginDescriptorImpl)) continue;
            for (PluginId id : dep = any.getDependentPluginIds()) {
                if (id != plugin.getPluginId()) continue;
                list.add((IdeaPluginDescriptorImpl)any);
                continue block0;
            }
        }
        return list;
    }

    public abstract void addData(List<IdeaPluginDescriptor> var1);

    public abstract void modifyData(List<IdeaPluginDescriptor> var1);

    public void filter(ArrayList<IdeaPluginDescriptor> filtered) {
        this.safeSort();
    }

    protected void safeSort() {
        int sortColumn = this.sortableProvider.getSortColumn();
        this.sortByColumn(-1 < sortColumn && sortColumn < this.getColumnCount() ? sortColumn : 0);
    }

    public abstract int getNameColumn();
}

