/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.BaseTokenParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class KeywordParser
extends BaseTokenParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.highlighter.custom.tokens.KeywordParser");
    private final HashSet[] myKeywordSets = new HashSet[4];
    private final int mySmartUpdateShift;
    private final boolean myIgnoreCase;
    private final BitSet myFirstCharacters = new BitSet();
    private final BitSet myCharacters = new BitSet();

    public KeywordParser(Set[] keywordSets, boolean ignoreCase) {
        LOG.assertTrue(keywordSets.length == this.myKeywordSets.length);
        this.myIgnoreCase = ignoreCase;
        int maxLength = 0;
        for (int i = 0; i < keywordSets.length; ++i) {
            Set keywordSet = keywordSets[i];
            this.myKeywordSets[i] = this.getKeywordSet(keywordSet);
            for (String s : keywordSet) {
                maxLength = Math.max(maxLength, s.length());
                char firstChar = s.charAt(0);
                if (ignoreCase) {
                    this.myFirstCharacters.set((int)Character.toUpperCase(firstChar), Character.toUpperCase(firstChar) + '\u0001');
                    this.myFirstCharacters.set((int)Character.toLowerCase(firstChar), Character.toLowerCase(firstChar) + '\u0001');
                } else {
                    this.myFirstCharacters.set((int)firstChar, firstChar + '\u0001');
                }
                for (int j = 0; j < s.length(); ++j) {
                    char currentChar = s.charAt(j);
                    if (ignoreCase) {
                        this.myCharacters.set((int)Character.toUpperCase(currentChar), Character.toUpperCase(currentChar) + '\u0001');
                        this.myCharacters.set((int)Character.toLowerCase(currentChar), Character.toLowerCase(currentChar) + '\u0001');
                        continue;
                    }
                    this.myCharacters.set((int)currentChar, currentChar + '\u0001');
                }
            }
        }
        this.mySmartUpdateShift = maxLength;
    }

    private HashSet getKeywordSet(Set keywordSet) {
        if (!this.myIgnoreCase) {
            return new HashSet(keywordSet);
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : keywordSet) {
            result.add(s.toUpperCase());
        }
        return result;
    }

    @Override
    public boolean hasToken(int position) {
        if (!this.myFirstCharacters.get(this.myBuffer.charAt(position))) {
            return false;
        }
        int start = position++;
        while (position < this.myEndOffset) {
            char c = this.myBuffer.charAt(position);
            if (!this.myCharacters.get(c)) {
                if (!Character.isJavaIdentifierPart(c)) break;
                return false;
            }
            ++position;
        }
        String keyword = ((Object)this.myBuffer.subSequence(start, position)).toString();
        String testKeyword = this.myIgnoreCase ? keyword.toUpperCase() : keyword;
        for (int i = 0; i < this.myKeywordSets.length; ++i) {
            HashSet keywordSet = this.myKeywordSets[i];
            if (!keywordSet.contains(testKeyword)) continue;
            this.myTokenInfo.updateData(start, position, KeywordParser.getToken(i));
            return true;
        }
        return false;
    }

    private static IElementType getToken(int keywordSetIndex) {
        switch (keywordSetIndex) {
            case 0: {
                return CustomHighlighterTokenType.KEYWORD_1;
            }
            case 1: {
                return CustomHighlighterTokenType.KEYWORD_2;
            }
            case 2: {
                return CustomHighlighterTokenType.KEYWORD_3;
            }
            case 3: {
                return CustomHighlighterTokenType.KEYWORD_4;
            }
        }
        return null;
    }

    @Override
    public int getSmartUpdateShift() {
        return this.mySmartUpdateShift;
    }
}

