/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;

public class SubtypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final String myCurrentScopeType;

    protected SubtypesHierarchyTreeStructure(Project project, HierarchyNodeDescriptor descriptor, String currentScopeType) {
        super(project, descriptor);
        this.myCurrentScopeType = currentScopeType;
    }

    public SubtypesHierarchyTreeStructure(Project project, PsiClass psiClass, String currentScopeType) {
        super(project, new TypeHierarchyNodeDescriptor(project, null, psiClass, true));
        this.myCurrentScopeType = currentScopeType;
    }

    @Override
    protected final Object[] buildChildren(HierarchyNodeDescriptor descriptor) {
        PsiClass psiClass = ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return new Object[]{IdeBundle.message((String)"node.hierarchy.java.lang.object", (Object[])new Object[0])};
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (psiClass.hasModifierProperty("final")) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        ArrayList classes = new ArrayList(ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)psiClass.getUseScope().intersectWith(this.getSearchScope(this.myCurrentScopeType, (PsiElement)psiClass)), (boolean)false).findAll());
        HierarchyNodeDescriptor[] descriptors = new HierarchyNodeDescriptor[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            descriptors[i] = new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiClass)classes.get(i), false);
        }
        return descriptors;
    }
}

