/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.actions;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseHierarchyActionBase
extends AnAction {
    private final LanguageExtension<HierarchyProvider> myExtension;

    protected BrowseHierarchyActionBase(LanguageExtension<HierarchyProvider> extension) {
        this.myExtension = extension;
    }

    public final void actionPerformed(AnActionEvent e) {
        Content content;
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final HierarchyProvider provider = this.getProvider(e);
        if (provider == null) {
            return;
        }
        PsiElement target = provider.getTarget(dataContext);
        if (target == null) {
            return;
        }
        final HierarchyBrowser hierarchyBrowser = provider.createHierarchyBrowser(target);
        HierarchyBrowserManager hierarchyBrowserManager = HierarchyBrowserManager.getInstance(project);
        ContentManager contentManager = hierarchyBrowserManager.getContentManager();
        Content selectedContent = contentManager.getSelectedContent();
        if (selectedContent != null && !selectedContent.isPinned()) {
            content = selectedContent;
            JComponent component = content.getComponent();
            if (component instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)component));
            }
            content.setComponent(hierarchyBrowser.getComponent());
        } else {
            content = ContentFactory.SERVICE.getInstance().createContent(hierarchyBrowser.getComponent(), null, true);
            contentManager.addContent(content);
        }
        contentManager.setSelectedContent(content);
        hierarchyBrowser.setContent(content);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                provider.browserActivated(hierarchyBrowser);
            }
        };
        ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.HIERARCHY).activate(runnable);
    }

    public void update(AnActionEvent e) {
        if (!this.myExtension.hasAnyExtensions()) {
            e.getPresentation().setVisible(false);
        } else {
            boolean enabled = this.isEnabled(e);
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                e.getPresentation().setVisible(enabled);
            } else {
                e.getPresentation().setVisible(true);
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private boolean isEnabled(AnActionEvent e) {
        HierarchyProvider provider = this.getProvider(e);
        return provider != null && provider.getTarget(e.getDataContext()) != null;
    }

    @Nullable
    private HierarchyProvider getProvider(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (file == null) {
            return null;
        }
        return (HierarchyProvider)this.myExtension.forLanguage(file.getLanguage());
    }
}

