/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryConfiguration;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.integration.EventDispatcher;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryActionImpl;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.LocalHistoryCacheUpdater;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;

public class LocalHistoryService {
    private final LocalVcs myVcs;
    private final IdeaGateway myGateway;
    private final LocalHistoryConfiguration myConfiguration;
    private final StartupManager myStartupManager;
    private final ProjectRootManagerEx myRootManager;
    private final VirtualFileManagerEx myFileManager;
    private final CommandProcessor myCommandProcessor;
    private CacheUpdater myCacheUpdater;
    private EventDispatcher myEventDispatcher;

    public LocalHistoryService(LocalVcs vcs, IdeaGateway gw, LocalHistoryConfiguration c, StartupManager sm, ProjectRootManagerEx projectRootManager, VirtualFileManagerEx fm, CommandProcessor cp) {
        this.myVcs = vcs;
        this.myGateway = gw;
        this.myConfiguration = c;
        this.myStartupManager = sm;
        this.myRootManager = projectRootManager;
        this.myFileManager = fm;
        this.myCommandProcessor = cp;
        this.registerCacheUpdaters();
        this.registerListeners();
    }

    private void registerCacheUpdaters() {
        this.myStartupManager.registerCacheUpdater((CacheUpdater)new StartupCacheUpdater(this.myVcs, this.myGateway));
        this.myCacheUpdater = new LocalHistoryCacheUpdater(LocalHistoryBundle.message("system.label.roots.change", new Object[0]), this.myVcs, this.myGateway);
        this.myRootManager.registerRootsChangeUpdater(this.myCacheUpdater);
    }

    private void registerListeners() {
        this.myEventDispatcher = new EventDispatcher(this.myVcs, this.myGateway);
        this.myCommandProcessor.addCommandListener((CommandListener)this.myEventDispatcher);
        this.myFileManager.addVirtualFileListener((VirtualFileListener)this.myEventDispatcher);
        this.myFileManager.addVirtualFileManagerListener(this.myEventDispatcher);
        this.myRootManager.registerRefreshUpdater(this.myEventDispatcher);
    }

    public void shutdown() {
        this.myRootManager.unregisterRefreshUpdater(this.myEventDispatcher);
        this.myRootManager.unregisterRootsChangeUpdater(this.myCacheUpdater);
        this.myFileManager.removeVirtualFileListener((VirtualFileListener)this.myEventDispatcher);
        this.myFileManager.removeVirtualFileManagerListener(this.myEventDispatcher);
        this.myCommandProcessor.removeCommandListener((CommandListener)this.myEventDispatcher);
    }

    public LocalHistoryAction startAction(String name) {
        LocalHistoryActionImpl a = new LocalHistoryActionImpl(this.myEventDispatcher, name);
        a.start();
        return a;
    }

    public class StartupCacheUpdater
    extends LocalHistoryCacheUpdater {
        public StartupCacheUpdater(LocalVcs vcs, IdeaGateway gw) {
            super(LocalHistoryBundle.message("system.label.project.open", new Object[0]), vcs, gw);
        }

        @Override
        public void updatingDone() {
            super.updatingDone();
            if (((LocalHistoryService)LocalHistoryService.this).myConfiguration.ADD_LABEL_ON_PROJECT_OPEN) {
                LocalHistoryService.this.myVcs.putSystemLabel(LocalHistoryBundle.message("system.label.project.open", new Object[0]), -1);
            }
        }
    }
}

